/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.VLANInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet;
import org.jclouds.http.HttpResponse;

@Singleton
public class KeyValuesDelimitedByBlankLinesToVLANInfo
implements Function<HttpResponse, VLANInfo> {
    private final ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet setParser;

    @Inject
    public KeyValuesDelimitedByBlankLinesToVLANInfo(ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet setParser) {
        this.setParser = setParser;
    }

    public VLANInfo apply(HttpResponse response) {
        Set<VLANInfo> drives = this.setParser.apply(response);
        if (drives.size() == 0) {
            return null;
        }
        return (VLANInfo)Iterables.get(drives, (int)0);
    }
}

