/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.options;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jclouds.cloudsigma.domain.AffinityType;

public class CloneDriveOptions {
    private static final String SSD_AFFINITY_TAG = "affinity:ssd";
    private final Map<String, String> options = Maps.newLinkedHashMap();

    public CloneDriveOptions size(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size must be >= 0");
        this.options.put("size", size + "");
        return this;
    }

    public CloneDriveOptions tags(String ... tags) {
        String currentTagsString = this.options.remove("tags");
        LinkedHashSet currentTags = currentTagsString == null ? new HashSet() : Sets.newLinkedHashSet((Iterable)Splitter.on((char)' ').split((CharSequence)currentTagsString));
        LinkedHashSet newTags = Sets.newLinkedHashSet();
        for (String tag : tags) {
            newTags.add(tag);
        }
        if (currentTags.contains(SSD_AFFINITY_TAG)) {
            newTags.add(SSD_AFFINITY_TAG);
        }
        this.options.put("tags", Joiner.on((char)' ').join((Iterable)newTags));
        return this;
    }

    public CloneDriveOptions affinity(AffinityType affinity) {
        String currentTagsString = this.options.remove("tags");
        LinkedHashSet tags = currentTagsString == null ? new LinkedHashSet() : Sets.newLinkedHashSet((Iterable)Splitter.on((char)' ').split((CharSequence)currentTagsString));
        switch (affinity) {
            case SSD: {
                tags.add(SSD_AFFINITY_TAG);
                break;
            }
            case HDD: {
                tags.remove(SSD_AFFINITY_TAG);
            }
        }
        if (!tags.isEmpty()) {
            this.options.put("tags", Joiner.on((char)' ').join((Iterable)tags));
        }
        return this;
    }

    public Map<String, String> getOptions() {
        return ImmutableMap.copyOf(this.options);
    }

    public static class Builder {
        public static CloneDriveOptions size(long size) {
            CloneDriveOptions options = new CloneDriveOptions();
            return options.size(size);
        }

        public static CloneDriveOptions tags(String ... tags) {
            CloneDriveOptions options = new CloneDriveOptions();
            return options.tags(tags);
        }

        public static CloneDriveOptions affinity(AffinityType affinity) {
            CloneDriveOptions options = new CloneDriveOptions();
            return options.affinity(affinity);
        }
    }
}

