/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.DynECTExceptions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class DynectApiMockTest {
    private static final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
    String session = "{\"status\": \"success\", \"data\": {\"token\": \"FFFFFFFFFF\", \"version\": \"3.3.8\"}, \"job_id\": 254417252, \"msgs\": [{\"INFO\": \"login: Login successful\", \"SOURCE\": \"BLL\", \"ERR_CD\": null, \"LVL\": \"INFO\"}]}";
    String running = "{\"status\": \"running\", \"data\": {}, \"job_id\": 274509427, \"msgs\": [{\"INFO\": \"token: This session already has a job running\", \"SOURCE\": \"API-B\", \"ERR_CD\": \"OPERATION_FAILED\", \"LVL\": \"ERROR\"}]}";
    String taskBlocking = "[{\"status\": \"failure\", \"data\": {}, \"job_id\": 275545493, \"msgs\": [{\"INFO\": \"zone: Operation blocked by current task\", \"SOURCE\": \"BLL\", \"ERR_CD\": \"ILLEGAL_OPERATION\", \"LVL\": \"ERROR\"}, {\"INFO\": \"task_name: ProvisionZone\", \"SOURCE\": \"BLL\", \"ERR_CD\": null, \"LVL\": \"INFO\"}, {\"INFO\": \"task_id: 39120953\", \"SOURCE\": \"BLL\", \"ERR_CD\": null, \"LVL\": \"INFO\"}]}]";
    String targetExists = "[{\"status\": \"failure\", \"data\": {}, \"job_id\": 275533917, \"msgs\": [{\"INFO\": \"name: Name already exists\", \"SOURCE\": \"BLL\", \"ERR_CD\": \"TARGET_EXISTS\", \"LVL\": \"ERROR\"}, {\"INFO\": \"create: You already have this zone.\", \"SOURCE\": \"BLL\", \"ERR_CD\": null, \"LVL\": \"INFO\"}]}]";

    static DynECTApi mockDynectApi(String uri) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.max-retries", "1");
        return (DynECTApi)ContextBuilder.newBuilder((String)"dynect").credentials("jclouds:joe", "letmein").endpoint(uri).overrides(overrides).modules(modules).buildApi(DynECTApi.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={DynECTExceptions.JobStillRunningException.class}, expectedExceptionsMessageRegExp="This session already has a job running")
    public void test200OnFailureThrowsExceptionWithoutRetryWhenJobRunning() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(Response.Status.OK.getStatusCode()).setBody(this.session));
        server.enqueue(new MockResponse().setResponseCode(Response.Status.OK.getStatusCode()).setBody(this.running));
        server.play();
        DynECTApi api = DynectApiMockTest.mockDynectApi(server.getUrl("/").toString());
        try {
            api.getZoneApi().list();
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={DynECTExceptions.JobStillRunningException.class}, expectedExceptionsMessageRegExp="Operation blocked by current task")
    public void test200OnFailureThrowsExceptionWithoutRetryWhenOperationBlocked() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(Response.Status.OK.getStatusCode()).setBody(this.session));
        server.enqueue(new MockResponse().setResponseCode(Response.Status.OK.getStatusCode()).setBody(this.taskBlocking));
        server.play();
        DynECTApi api = DynectApiMockTest.mockDynectApi(server.getUrl("/").toString());
        try {
            api.getZoneApi().list();
        }
        finally {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={DynECTExceptions.TargetExistsException.class}, expectedExceptionsMessageRegExp="Name already exists")
    public void test200OnFailureThrowsExceptionWithoutRetryOnNameExists() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        server.enqueue(new MockResponse().setResponseCode(Response.Status.OK.getStatusCode()).setBody(this.session));
        server.enqueue(new MockResponse().setResponseCode(Response.Status.OK.getStatusCode()).setBody(this.targetExists));
        server.play();
        DynECTApi api = DynectApiMockTest.mockDynectApi(server.getUrl("/").toString());
        try {
            api.getZoneApi().list();
        }
        finally {
            server.shutdown();
        }
    }
}

