/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.logging.Logger;
import org.jclouds.JcloudsVersion;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.DynECTExceptions;
import org.jclouds.dynect.v3.domain.CreateRecord;
import org.jclouds.dynect.v3.domain.Job;
import org.jclouds.dynect.v3.domain.Record;
import org.jclouds.dynect.v3.domain.RecordId;
import org.jclouds.dynect.v3.domain.SOARecord;
import org.jclouds.dynect.v3.domain.Zone;
import org.jclouds.dynect.v3.domain.rdata.AAAAData;
import org.jclouds.dynect.v3.domain.rdata.AData;
import org.jclouds.dynect.v3.domain.rdata.CNAMEData;
import org.jclouds.dynect.v3.domain.rdata.MXData;
import org.jclouds.dynect.v3.domain.rdata.NSData;
import org.jclouds.dynect.v3.domain.rdata.PTRData;
import org.jclouds.dynect.v3.domain.rdata.SOAData;
import org.jclouds.dynect.v3.domain.rdata.SPFData;
import org.jclouds.dynect.v3.domain.rdata.SRVData;
import org.jclouds.dynect.v3.domain.rdata.SSHFPData;
import org.jclouds.dynect.v3.domain.rdata.TXTData;
import org.jclouds.dynect.v3.features.RecordApi;
import org.jclouds.dynect.v3.features.ZoneApi;
import org.jclouds.dynect.v3.internal.BaseDynECTApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="RecordApiLiveTest")
public class RecordApiLiveTest
extends BaseDynECTApiLiveTest {
    String zoneFQDN = System.getProperty("user.name").replace('.', '-') + ".record.dynecttest.jclouds.org";
    String contact = JcloudsVersion.get() + ".jclouds.org";
    String fqdn = "www." + this.zoneFQDN;
    CreateRecord<AData> record = CreateRecord.builder().fqdn("www." + this.zoneFQDN).type("A").ttl(86400).rdata((Map)AData.a((String)"1.1.1.1")).build();
    RecordId id;

    private void checkRecordId(RecordId record) {
        Assert.assertTrue((record.getId() > 0L ? 1 : 0) != 0, (String)("Id cannot be zero for RecordId: " + record));
        Preconditions.checkNotNull((Object)record.getType(), (String)"Type cannot be null for RecordId: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)record.getFQDN(), (String)"FQDN cannot be null for RecordId: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)record.getZone(), (String)"Zone cannot be null for RecordId: %s", (Object[])new Object[]{record});
    }

    private void checkRecord(Record<? extends Map<String, Object>> record) {
        this.checkRecordId((RecordId)record);
        Assert.assertTrue((record.getRData().size() > 0 ? 1 : 0) != 0, (String)("RData entries should be present for cannot be zero for Record: " + record));
        Preconditions.checkNotNull((Object)record.getTTL(), (String)"TTL cannot be null for RecordId: %s", (Object[])new Object[]{record});
    }

    @Test
    protected void testListAndGetRecords() {
        for (String zone : this.zoneApi().list()) {
            RecordApi api = this.api(zone);
            ImmutableList records = api.list().toList();
            Logger.getAnonymousLogger().info("zone: " + zone + " record count: " + records.size());
            for (RecordId recordId : records) {
                Object record = "AAAA".equals(recordId.getType()) ? this.checkAAAARecord((Record<AAAAData>)api.getAAAA(recordId.getFQDN(), recordId.getId())) : ("A".equals(recordId.getType()) ? this.checkARecord((Record<AData>)api.getA(recordId.getFQDN(), recordId.getId())) : ("CNAME".equals(recordId.getType()) ? this.checkCNAMERecord((Record<CNAMEData>)api.getCNAME(recordId.getFQDN(), recordId.getId())) : ("MX".equals(recordId.getType()) ? this.checkMXRecord((Record<MXData>)api.getMX(recordId.getFQDN(), recordId.getId())) : ("NS".equals(recordId.getType()) ? this.checkNSRecord((Record<NSData>)api.getNS(recordId.getFQDN(), recordId.getId())) : ("PTR".equals(recordId.getType()) ? this.checkPTRRecord((Record<PTRData>)api.getPTR(recordId.getFQDN(), recordId.getId())) : ("SOA".equals(recordId.getType()) ? this.checkSOARecord(api.getSOA(recordId.getFQDN(), recordId.getId())) : ("SPF".equals(recordId.getType()) ? this.checkSPFRecord((Record<SPFData>)api.getSPF(recordId.getFQDN(), recordId.getId())) : ("SRV".equals(recordId.getType()) ? this.checkSRVRecord((Record<SRVData>)api.getSRV(recordId.getFQDN(), recordId.getId())) : ("SSHFP".equals(recordId.getType()) ? this.checkSSHFPRecord((Record<SSHFPData>)api.getSSHFP(recordId.getFQDN(), recordId.getId())) : ("TXT".equals(recordId.getType()) ? this.checkTXTRecord((Record<TXTData>)api.getTXT(recordId.getFQDN(), recordId.getId())) : api.get(recordId)))))))))));
                Assert.assertEquals(record, (Object)recordId);
                this.checkRecord((Record<? extends Map<String, Object>>)record);
            }
        }
    }

    private Record<AAAAData> checkAAAARecord(Record<AAAAData> record) {
        AAAAData rdata = (AAAAData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getAddress(), (String)"rdata.address cannot be null for AAAARecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<AData> checkARecord(Record<AData> record) {
        AData rdata = (AData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getAddress(), (String)"rdata.address cannot be null for ARecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<CNAMEData> checkCNAMERecord(Record<CNAMEData> record) {
        CNAMEData rdata = (CNAMEData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getCname(), (String)"rdata.cname cannot be null for CNAMERecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<MXData> checkMXRecord(Record<MXData> record) {
        MXData rdata = (MXData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getPreference(), (String)"rdata.preference cannot be null for MXRecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getExchange(), (String)"rdata.exchange cannot be null for MXRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<NSData> checkNSRecord(Record<NSData> record) {
        NSData rdata = (NSData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getNsdname(), (String)"rdata.nsdname cannot be null for NSRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<PTRData> checkPTRRecord(Record<PTRData> record) {
        PTRData rdata = (PTRData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getPtrdname(), (String)"rdata.ptrdname cannot be null for PTRRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private SOARecord checkSOARecord(SOARecord record) {
        Preconditions.checkNotNull((Object)record.getSerialStyle(), (String)"SerialStyle cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        SOAData rdata = (SOAData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getMname(), (String)"rdata.mname cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getRname(), (String)"rdata.rname cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getSerial(), (String)"rdata.serial cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getRefresh(), (String)"rdata.refresh cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getRetry(), (String)"rdata.retry cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getExpire(), (String)"rdata.expire cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getMinimum(), (String)"rdata.minimum cannot be null for SOARecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<SPFData> checkSPFRecord(Record<SPFData> record) {
        SPFData rdata = (SPFData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getTxtdata(), (String)"rdata.txtdata cannot be null for SPFRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<SRVData> checkSRVRecord(Record<SRVData> record) {
        SRVData rdata = (SRVData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getPriority(), (String)"rdata.priority cannot be null for SRVRecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getWeight(), (String)"rdata.weight cannot be null for SRVRecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getPort(), (String)"rdata.port cannot be null for SRVRecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getTarget(), (String)"rdata.target cannot be null for SRVRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<SSHFPData> checkSSHFPRecord(Record<SSHFPData> record) {
        SSHFPData rdata = (SSHFPData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getAlgorithm(), (String)"rdata.algorithm cannot be null for SSHFPRecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getType(), (String)"rdata.type cannot be null for SSHFPRecord: %s", (Object[])new Object[]{record});
        Preconditions.checkNotNull((Object)rdata.getFingerprint(), (String)"rdata.fingerprint cannot be null for SSHFPRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private Record<TXTData> checkTXTRecord(Record<TXTData> record) {
        TXTData rdata = (TXTData)record.getRData();
        Preconditions.checkNotNull((Object)rdata.getTxtdata(), (String)"rdata.txtdata cannot be null for TXTRecord: %s", (Object[])new Object[]{record});
        return record;
    }

    private void createZone() {
        Job job = this.zoneApi().scheduleCreateWithContact(this.zoneFQDN, this.contact);
        Preconditions.checkNotNull((Object)job, (String)"unable to create zone %s", (Object[])new Object[]{this.zoneFQDN});
        Logger.getAnonymousLogger().info("created zone: " + job);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
        Zone zone = this.zoneApi().publish(this.zoneFQDN);
        Preconditions.checkNotNull((Object)zone, (String)"unable to publish zone %s", (Object[])new Object[]{this.zoneFQDN});
        Logger.getAnonymousLogger().info("published zone: " + zone);
    }

    public void testCreateRecord() {
        this.createZone();
        Job job = null;
        while (true) {
            try {
                job = this.api(this.zoneFQDN).scheduleCreate(this.record);
            }
            catch (DynECTExceptions.JobStillRunningException e) {
                continue;
            }
            break;
        }
        Preconditions.checkNotNull((Object)job, (String)"unable to create record %s", (Object[])new Object[]{this.record});
        Logger.getAnonymousLogger().info("created record: " + job);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
        this.zoneApi().publish(this.zoneFQDN);
    }

    @Test(dependsOnMethods={"testCreateRecord"})
    public void testListByFQDNAndType() {
        this.id = (RecordId)this.api(this.zoneFQDN).listByFQDNAndType(this.record.getFQDN(), this.record.getType()).toList().get(0);
        Logger.getAnonymousLogger().info(this.id.toString());
        Record newRecord = this.api(this.zoneFQDN).get(this.id);
        Assert.assertEquals((String)newRecord.getFQDN(), (String)this.record.getFQDN());
        Assert.assertEquals((String)newRecord.getType(), (String)this.record.getType());
        Assert.assertEquals((int)newRecord.getTTL(), (int)this.record.getTTL());
        Assert.assertEquals((Map)newRecord.getRData(), (Map)this.record.getRData());
        this.checkRecord((Record<? extends Map<String, Object>>)newRecord);
    }

    @Test(dependsOnMethods={"testCreateRecord"})
    public void testListByFQDN() {
        this.id = (RecordId)this.api(this.zoneFQDN).listByFQDN(this.record.getFQDN()).toList().get(0);
        Logger.getAnonymousLogger().info(this.id.toString());
        Record newRecord = this.api(this.zoneFQDN).get(this.id);
        Assert.assertEquals((String)newRecord.getFQDN(), (String)this.record.getFQDN());
        Assert.assertEquals((String)newRecord.getType(), (String)this.record.getType());
        Assert.assertEquals((int)newRecord.getTTL(), (int)this.record.getTTL());
        Assert.assertEquals((Map)newRecord.getRData(), (Map)this.record.getRData());
        this.checkRecord((Record<? extends Map<String, Object>>)newRecord);
    }

    @Test(dependsOnMethods={"testListByFQDNAndType", "testListByFQDN"})
    public void testDeleteRecord() {
        Job job = this.api(this.zoneFQDN).scheduleDelete(this.id);
        Preconditions.checkNotNull((Object)job, (String)"unable to delete record %s", (Object[])new Object[]{this.id});
        Logger.getAnonymousLogger().info("deleted record: " + job);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
        this.zoneApi().publish(this.zoneFQDN);
    }

    protected RecordApi api(String zoneFQDN) {
        return ((DynECTApi)this.api).getRecordApiForZone(zoneFQDN);
    }

    protected ZoneApi zoneApi() {
        return ((DynECTApi)this.api).getZoneApi();
    }

    @AfterClass(groups={"live"}, alwaysRun=true)
    protected void tearDown() {
        this.zoneApi().delete(this.zoneFQDN);
        super.tearDown();
    }
}

