/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import javax.ws.rs.core.Response;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.SessionCredentials;
import org.jclouds.dynect.v3.internal.BaseDynECTApiExpectTest;
import org.jclouds.dynect.v3.parse.CreateSessionResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SessionApiExpectTest")
public class SessionApiExpectTest
extends BaseDynECTApiExpectTest {
    HttpRequest isValid;
    HttpResponse validResponse;
    HttpResponse invalidResponse;
    HttpRequest logout;
    HttpResponse logoutResponse;

    public SessionApiExpectTest() {
        this.isValid = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/Session").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.validResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/session_valid.json", "application/json"))).build();
        this.invalidResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload(this.payloadFromResourceWithContentType("/session_invalid.json", "application/json"))).build();
        this.logout = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://api2.dynect.net/REST/Session").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.logoutResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/logout.json", "application/json"))).build();
    }

    public void testCreateWhenResponseIs2xx() {
        DynECTApi apiCreatesSession = (DynECTApi)this.requestSendsResponse(this.createSession, this.createSessionResponse);
        Assert.assertEquals((String)apiCreatesSession.getSessionApi().login(SessionCredentials.builder().customerName("jclouds").userName("joe").password("letmein").build()).toString(), (String)new CreateSessionResponseTest().expected().toString());
    }

    public void testSessionValid() {
        DynECTApi apiWhenValid = (DynECTApi)this.requestSendsResponse(this.isValid, this.validResponse);
        Assert.assertTrue((boolean)apiWhenValid.getSessionApi().isValid(this.authToken));
    }

    public void testSessionInvalid() {
        DynECTApi apiWhenInvalid = (DynECTApi)this.requestSendsResponse(this.isValid, this.invalidResponse);
        Assert.assertFalse((boolean)apiWhenInvalid.getSessionApi().isValid(this.authToken));
    }

    public void testLogout() {
        DynECTApi apiWhenLogoutSuccess = (DynECTApi)this.requestSendsResponse(this.logout, this.logoutResponse);
        apiWhenLogoutSuccess.getSessionApi().logout(this.authToken);
    }
}

