/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.logging.Logger;
import org.jclouds.JcloudsVersion;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.Job;
import org.jclouds.dynect.v3.domain.Zone;
import org.jclouds.dynect.v3.features.ZoneApi;
import org.jclouds.dynect.v3.internal.BaseDynECTApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ZoneApiLiveTest")
public class ZoneApiLiveTest
extends BaseDynECTApiLiveTest {
    String fqdn = System.getProperty("user.name").replace('.', '-') + ".zone.dynecttest.jclouds.org";
    String contact = JcloudsVersion.get() + ".jclouds.org";

    private void checkZone(Zone zone) {
        Preconditions.checkNotNull((Object)zone.getFQDN(), (String)"FQDN cannot be null for a Zone: %s", (Object[])new Object[]{zone});
        Preconditions.checkNotNull((Object)zone.getSerial(), (String)"Serial cannot be null for a Zone: %s", (Object[])new Object[]{zone});
    }

    @Test
    protected void testListAndGetZones() {
        ImmutableList zones = this.api().list().toList();
        Logger.getAnonymousLogger().info("zones: " + zones.size());
        for (String fqdn : zones) {
            Zone zone = this.api().get(fqdn);
            Preconditions.checkNotNull((Object)zone, (String)"zone was null for Zone: %s", (Object[])new Object[]{fqdn});
            this.checkZone(zone);
        }
    }

    @Test
    public void testGetZoneWhenNotFound() {
        Assert.assertNull((Object)this.api().get("AAAAAAAAAAAAAAAA.foo.com"));
    }

    @Test
    public void testDeleteZoneWhenNotFound() {
        Assert.assertNull((Object)this.api().delete("AAAAAAAAAAAAAAAA.foo.com"));
    }

    @Test
    public void testCreateZone() {
        Job job = this.api().scheduleCreateWithContact(this.fqdn, this.contact);
        Preconditions.checkNotNull((Object)job, (String)"unable to create zone %s", (Object[])new Object[]{this.fqdn});
        Logger.getAnonymousLogger().info("created zone: " + job);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
    }

    @Test(dependsOnMethods={"testCreateZone"})
    public void testPublishZone() {
        Zone zone = this.api().publish(this.fqdn);
        Preconditions.checkNotNull((Object)zone, (String)"unable to publish zone %s", (Object[])new Object[]{this.fqdn});
        Logger.getAnonymousLogger().info("published zone: " + zone);
        this.checkZone(zone);
    }

    @Test(dependsOnMethods={"testPublishZone"})
    public void testFreezeZone() {
        Job job = this.api().freeze(this.fqdn);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
    }

    @Test(dependsOnMethods={"testFreezeZone"})
    public void testThawZone() {
        Job job = this.api().thaw(this.fqdn);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
    }

    @Test(dependsOnMethods={"testThawZone"})
    public void testDeleteZoneChanges() {
        Job job = this.api().deleteChanges(this.fqdn);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
    }

    @Test(dependsOnMethods={"testDeleteZoneChanges"})
    public void testDeleteZone() {
        Job job = this.api().delete(this.fqdn);
        Assert.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCESS);
        Assert.assertEquals((Object)((DynECTApi)this.api).getJob(job.getId()), (Object)job);
        Assert.assertNull((Object)this.api().get(this.fqdn), (String)("job " + job + " didn't delete zone" + this.fqdn));
    }

    protected ZoneApi api() {
        return ((DynECTApi)this.api).getZoneApi();
    }

    @AfterClass(groups={"live"}, alwaysRun=true)
    protected void tearDown() {
        this.api().delete(this.fqdn);
        super.tearDown();
    }
}

