/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.filters;

import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Resources;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.jclouds.domain.Credentials;
import org.jclouds.dynect.v3.domain.Session;
import org.jclouds.dynect.v3.domain.SessionCredentials;
import org.jclouds.dynect.v3.features.SessionApi;
import org.jclouds.dynect.v3.filters.SessionManager;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SessionManagerTest")
public class SessionManagerTest {
    SessionCredentials creds = SessionCredentials.builder().customerName("customer").userName("robbie").password("password").build();
    Session session = Session.forTokenAndVersion((String)"token", (String)"version");

    public void testAlreadySessionCredentials() {
        Assert.assertSame((Object)SessionManager.convert((Credentials)this.creds), (Object)this.creds);
    }

    public void testConvertCredentialsParsesCustomer() {
        Assert.assertEquals((Object)SessionManager.convert((Credentials)new Credentials("customer:robbie", "password")), (Object)this.creds);
    }

    public void testCacheLoadLogsIn() {
        SessionApi sessionApi = (SessionApi)EasyMock.createMock(SessionApi.class);
        EasyMock.expect((Object)sessionApi.login(this.creds)).andReturn((Object)this.session);
        EasyMock.replay((Object[])new Object[]{sessionApi});
        Assert.assertSame((Object)SessionManager.buildCache((SessionApi)sessionApi).apply((Object)this.creds), (Object)this.session);
        EasyMock.verify((Object[])new Object[]{sessionApi});
    }

    @Test
    public void testUnauthorizedShouldInvalidateSessionAndRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        Supplier creds = (Supplier)EasyMock.createMock(Supplier.class);
        LoadingCache sessionCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        SessionApi sessionApi = (SessionApi)EasyMock.createMock(SessionApi.class);
        sessionCache.invalidateAll();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)command.incrementFailureCount()).andReturn((Object)1);
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true);
        EasyMock.expect((Object)command.getFailureCount()).andReturn((Object)1).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{creds, sessionCache, sessionApi, command});
        HttpResponse response = HttpResponse.builder().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).build();
        SessionManager retry = new SessionManager(creds, sessionCache, sessionApi);
        Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{creds, sessionCache, sessionApi, command});
    }

    @Test
    public void testIPMismatchShouldInvalidateSessionAndRetry() throws IOException {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        Supplier creds = (Supplier)EasyMock.createMock(Supplier.class);
        LoadingCache sessionCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        SessionApi sessionApi = (SessionApi)EasyMock.createMock(SessionApi.class);
        sessionCache.invalidateAll();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)command.incrementFailureCount()).andReturn((Object)1);
        EasyMock.expect((Object)command.isReplayable()).andReturn((Object)true);
        EasyMock.expect((Object)command.getFailureCount()).andReturn((Object)1).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{creds, sessionCache, sessionApi, command});
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).payload(Resources.getResource((String)"ip_mismatch.json").openStream())).build();
        SessionManager retry = new SessionManager(creds, sessionCache, sessionApi);
        Assert.assertTrue((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{creds, sessionCache, sessionApi, command});
    }

    @Test
    public void testForbiddenShouldNotInvalidateSessionOrRetry() {
        HttpCommand command = (HttpCommand)EasyMock.createMock(HttpCommand.class);
        Supplier creds = (Supplier)EasyMock.createMock(Supplier.class);
        LoadingCache sessionCache = (LoadingCache)EasyMock.createMock(LoadingCache.class);
        SessionApi sessionApi = (SessionApi)EasyMock.createMock(SessionApi.class);
        EasyMock.replay((Object[])new Object[]{creds, sessionCache, sessionApi, command});
        HttpResponse response = HttpResponse.builder().statusCode(Response.Status.FORBIDDEN.getStatusCode()).build();
        SessionManager retry = new SessionManager(creds, sessionCache, sessionApi);
        Assert.assertFalse((boolean)retry.shouldRetryRequest(command, response));
        EasyMock.verify((Object[])new Object[]{creds, sessionCache, sessionApi, command});
    }
}

