/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.internal;

import com.google.common.base.Predicate;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.Server;
import org.jclouds.glesys.domain.ServerDetails;
import org.jclouds.glesys.domain.ServerSpec;
import org.jclouds.glesys.domain.ServerStatus;
import org.jclouds.glesys.features.DomainApi;
import org.jclouds.glesys.features.ServerApi;
import org.jclouds.glesys.internal.BaseGleSYSApiLiveTest;
import org.jclouds.glesys.options.AddDomainOptions;
import org.jclouds.glesys.options.CreateServerOptions;
import org.jclouds.glesys.options.DestroyServerOptions;
import org.jclouds.glesys.options.ServerStatusOptions;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class BaseGleSYSApiWithAServerLiveTest
extends BaseGleSYSApiLiveTest {
    protected String serverId;
    protected Predicate<Server.State> serverStatusChecker;

    public BaseGleSYSApiWithAServerLiveTest() {
        this.provider = "glesys";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        Assert.assertNull((Object)this.serverId, (String)"This method should be called EXACTLY once per run");
        super.setup();
        this.serverStatusChecker = this.createServer(this.hostName);
    }

    @AfterClass(groups={"integration", "live"})
    public void tearDown() {
        ((GleSYSApi)this.api).getServerApi().destroy(this.serverId, DestroyServerOptions.Builder.discardIp());
        super.tearDown();
    }

    @Override
    protected void createDomain(String domain) {
        final DomainApi domainApi = ((GleSYSApi)this.api).getDomainApi();
        int before = domainApi.list().size();
        domainApi.create(domain, new AddDomainOptions[0]);
        Predicate result = Predicates2.retry((Predicate)new Predicate<Integer>(){

            public boolean apply(Integer value) {
                return domainApi.list().size() == value.intValue();
            }
        }, (long)30L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertTrue((boolean)result.apply((Object)(before + 1)));
    }

    protected Predicate<Server.State> createServer(String hostName) {
        ServerApi serverApi = ((GleSYSApi)this.api).getServerApi();
        ServerDetails testServer = serverApi.createWithHostnameAndRootPassword(ServerSpec.builder().datacenter("Falkenberg").platform("OpenVZ").templateName("Ubuntu 10.04 LTS 32-bit").diskSizeGB(5).memorySizeMB(512).cpuCores(1).transferGB(50).build(), hostName, UUID.randomUUID().toString().replace("-", ""), new CreateServerOptions[0]);
        Assert.assertNotNull((Object)testServer.getId());
        Assert.assertEquals((String)testServer.getHostname(), (String)hostName);
        Assert.assertFalse((boolean)testServer.getIps().isEmpty());
        Predicate<Server.State> statusChecker = this.statusChecker(serverApi, testServer.getId());
        Assert.assertTrue((boolean)statusChecker.apply((Object)Server.State.RUNNING));
        this.serverId = testServer.getId();
        return statusChecker;
    }

    protected Predicate<Server.State> statusChecker(final ServerApi api, final String serverId) {
        return Predicates2.retry((Predicate)new Predicate<Server.State>(){

            public boolean apply(Server.State value) {
                ServerStatus status = api.getStatus(serverId, new ServerStatusOptions[]{ServerStatusOptions.Builder.state()});
                return status.getState() == value;
            }
        }, (long)300L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }
}

