/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jclouds.apis.BaseApiLiveTest;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.GoGridResponseException;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.LoadBalancer;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.options.AddLoadBalancerOptions;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.GetServerListOptions;
import org.jclouds.gogrid.predicates.LoadBalancerLatestJobCompleted;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.TestException;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(enabled=false, groups={"live"}, singleThreaded=true, testName="GoGridLiveTestDisabled")
public class GoGridLiveTestDisabled
extends BaseApiLiveTest<GoGridClient> {
    private Predicate<Server> serverLatestJobCompleted;
    private Predicate<LoadBalancer> loadBalancerLatestJobCompleted;
    private List<String> serversToDeleteAfterTheTests = Lists.newArrayList();
    private List<String> loadBalancersToDeleteAfterTest = Lists.newArrayList();

    public GoGridLiveTestDisabled() {
        this.provider = "gogrid";
    }

    @BeforeGroups(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.serverLatestJobCompleted = Predicates2.retry((Predicate)new ServerLatestJobCompleted(((GoGridClient)this.api).getJobServices()), (long)800L, (long)20L, (TimeUnit)TimeUnit.SECONDS);
        this.loadBalancerLatestJobCompleted = Predicates2.retry((Predicate)new LoadBalancerLatestJobCompleted(((GoGridClient)this.api).getJobServices()), (long)800L, (long)20L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Test(enabled=true)
    public void testDescriptionIs500Characters() {
        String nameOfServer = "Description" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = ((GoGridClient)this.api).getIpServices().getUnassignedPublicIpList();
        Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
        String ram = ((Option)Iterables.get((Iterable)((GoGridClient)this.api).getServerServices().getRamSizes(), (int)0)).getName();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 500; ++i) {
            builder.append('a');
        }
        String description = builder.toString();
        Server createdServer = ((GoGridClient)this.api).getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", ram, availableIp.getIp(), new AddServerOptions[]{new AddServerOptions().withDescription(description)});
        Assert.assertNotNull((Object)createdServer);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        Assert.assertEquals((String)((Server)Iterables.getLast((Iterable)((GoGridClient)this.api).getServerServices().getServersByName(new String[]{nameOfServer}))).getDescription(), (String)description);
    }

    @Test(enabled=true)
    public void testServerLifecycle() {
        int serverCountBeforeTest = ((GoGridClient)this.api).getServerServices().getServerList(new GetServerListOptions[0]).size();
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = ((GoGridClient)this.api).getIpServices().getUnassignedPublicIpList();
        Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
        String ram = ((Option)Iterables.get((Iterable)((GoGridClient)this.api).getServerServices().getRamSizes(), (int)0)).getName();
        Server createdServer = ((GoGridClient)this.api).getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", ram, availableIp.getIp(), new AddServerOptions[0]);
        Assert.assertNotNull((Object)createdServer);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        Set response = ((GoGridClient)this.api).getServerServices().getServersByName(new String[]{nameOfServer});
        assert (response.size() == 1);
        ((GoGridClient)this.api).getServerServices().power(nameOfServer, PowerCommand.RESTART);
        Set jobs = ((GoGridClient)this.api).getJobServices().getJobsForObjectName(nameOfServer);
        assert ("RestartVirtualServer".equals(((Job)Iterables.getLast((Iterable)jobs)).getCommand().getName()));
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        int serverCountAfterAddingOneServer = ((GoGridClient)this.api).getServerServices().getServerList(new GetServerListOptions[0]).size();
        assert (serverCountAfterAddingOneServer == serverCountBeforeTest + 1) : "There should be +1 increase in the number of servers since the test started";
        ((GoGridClient)this.api).getServerServices().deleteByName(nameOfServer);
        jobs = ((GoGridClient)this.api).getJobServices().getJobsForObjectName(nameOfServer);
        assert ("DeleteVirtualServer".equals(((Job)Iterables.getLast((Iterable)jobs)).getCommand().getName()));
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        int serverCountAfterDeletingTheServer = ((GoGridClient)this.api).getServerServices().getServerList(new GetServerListOptions[0]).size();
        assert (serverCountAfterDeletingTheServer == serverCountBeforeTest) : "There should be the same # of servers as since the test started";
        assert (((GoGridClient)this.api).getIpServices().getUnassignedIpList().contains(availableIp));
    }

    @Test(dependsOnMethods={"testServerLifecycle"}, enabled=true)
    public void testJobs() {
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = ((GoGridClient)this.api).getIpServices().getUnassignedPublicIpList();
        String ram = ((Option)Iterables.get((Iterable)((GoGridClient)this.api).getServerServices().getRamSizes(), (int)0)).getName();
        Server createdServer = ((GoGridClient)this.api).getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", ram, ((Ip)Iterables.getLast((Iterable)availableIps)).getIp(), new AddServerOptions[0]);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        ((GoGridClient)this.api).getServerServices().power(nameOfServer, PowerCommand.RESTART);
        Set jobs = ((GoGridClient)this.api).getJobServices().getJobsForObjectName(nameOfServer);
        Job latestJob = (Job)Iterables.getLast((Iterable)jobs);
        Long latestJobId = latestJob.getId();
        Job latestJobFetched = (Job)Iterables.getOnlyElement((Iterable)((GoGridClient)this.api).getJobServices().getJobsById(new long[]{latestJobId}));
        assert (latestJob.equals((Object)latestJobFetched)) : "Job and its representation found by ID don't match";
        long[] idsOfAllJobs = new long[jobs.size()];
        int i = 0;
        for (Job job : jobs) {
            idsOfAllJobs[i++] = job.getId();
        }
        Set jobsFetched = ((GoGridClient)this.api).getJobServices().getJobsById(idsOfAllJobs);
        assert (jobsFetched.size() == jobs.size()) : String.format("Number of jobs fetched by ids doesn't match the number of jobs requested. Requested/expected: %d. Found: %d.", jobs.size(), jobsFetched.size());
        ((GoGridClient)this.api).getServerServices().deleteByName(nameOfServer);
    }

    @Test(enabled=true)
    public void testLoadBalancerLifecycle() {
        int lbCountBeforeTest = ((GoGridClient)this.api).getLoadBalancerServices().getLoadBalancerList().size();
        String nameOfLoadBalancer = "LoadBalancer" + String.valueOf(new Date().getTime()).substring(6);
        this.loadBalancersToDeleteAfterTest.add(nameOfLoadBalancer);
        Set availableIps = ((GoGridClient)this.api).getIpServices().getUnassignedPublicIpList();
        if (availableIps.size() < 4) {
            throw new SkipException("Not enough available IPs (4 needed) to run the test");
        }
        Iterator ipIterator = availableIps.iterator();
        Ip vip = (Ip)ipIterator.next();
        Ip realIp1 = (Ip)ipIterator.next();
        Ip realIp2 = (Ip)ipIterator.next();
        Ip realIp3 = (Ip)ipIterator.next();
        AddLoadBalancerOptions options = new AddLoadBalancerOptions.Builder().create(LoadBalancerType.LEAST_CONNECTED, LoadBalancerPersistenceType.SOURCE_ADDRESS);
        LoadBalancer createdLoadBalancer = ((GoGridClient)this.api).getLoadBalancerServices().addLoadBalancer(nameOfLoadBalancer, IpPortPair.builder().ip(vip).port(80).build(), Arrays.asList(IpPortPair.builder().ip(realIp1).port(80).build(), IpPortPair.builder().ip(realIp2).port(80).build()), new AddLoadBalancerOptions[]{options});
        Assert.assertNotNull((Object)createdLoadBalancer);
        assert (this.loadBalancerLatestJobCompleted.apply((Object)createdLoadBalancer));
        Set response = ((GoGridClient)this.api).getLoadBalancerServices().getLoadBalancersByName(new String[]{nameOfLoadBalancer});
        assert (response.size() == 1);
        createdLoadBalancer = (LoadBalancer)Iterables.getOnlyElement((Iterable)response);
        Assert.assertNotNull((Object)createdLoadBalancer.getRealIpList());
        Assert.assertEquals((int)createdLoadBalancer.getRealIpList().size(), (int)2);
        Assert.assertNotNull((Object)createdLoadBalancer.getVirtualIp());
        Assert.assertEquals((String)createdLoadBalancer.getVirtualIp().getIp().getIp(), (String)vip.getIp());
        LoadBalancer editedLoadBalancer = ((GoGridClient)this.api).getLoadBalancerServices().editLoadBalancerNamed(nameOfLoadBalancer, Arrays.asList(IpPortPair.builder().ip(realIp3).port(8181).build()));
        assert (this.loadBalancerLatestJobCompleted.apply((Object)editedLoadBalancer));
        Assert.assertNotNull((Object)editedLoadBalancer.getRealIpList());
        Assert.assertEquals((int)editedLoadBalancer.getRealIpList().size(), (int)1);
        Assert.assertEquals((String)((IpPortPair)Iterables.getOnlyElement((Iterable)editedLoadBalancer.getRealIpList())).getIp().getIp(), (String)realIp3.getIp());
        int lbCountAfterAddingOneServer = ((GoGridClient)this.api).getLoadBalancerServices().getLoadBalancerList().size();
        assert (lbCountAfterAddingOneServer == lbCountBeforeTest + 1) : "There should be +1 increase in the number of load balancers since the test started";
        ((GoGridClient)this.api).getLoadBalancerServices().deleteByName(nameOfLoadBalancer);
        Set jobs = ((GoGridClient)this.api).getJobServices().getJobsForObjectName(nameOfLoadBalancer);
        assert ("DeleteLoadBalancer".equals(((Job)Iterables.getLast((Iterable)jobs)).getCommand().getName()));
        assert (this.loadBalancerLatestJobCompleted.apply((Object)createdLoadBalancer));
        int lbCountAfterDeletingTheServer = ((GoGridClient)this.api).getLoadBalancerServices().getLoadBalancerList().size();
        assert (lbCountAfterDeletingTheServer == lbCountBeforeTest) : "There should be the same # of load balancers as since the test started";
    }

    @Test(enabled=true)
    public void testImageLifecycle() {
        GetImageListOptions options = GetImageListOptions.Builder.publicDatabaseServers();
        Set images = ((GoGridClient)this.api).getImageServices().getImageList(new GetImageListOptions[]{options});
        Predicate<ServerImage> isDatabaseServer = new Predicate<ServerImage>(){

            public boolean apply(@Nullable ServerImage serverImage) {
                return ((ServerImage)Preconditions.checkNotNull((Object)serverImage)).getType() == ServerImageType.DATABASE_SERVER;
            }
        };
        assert (Iterables.all((Iterable)images, (Predicate)isDatabaseServer)) : "All of the images should've been of database type";
        ServerImage image = (ServerImage)Iterables.getLast((Iterable)images);
        ServerImage imageFromServer = (ServerImage)Iterables.getOnlyElement((Iterable)((GoGridClient)this.api).getImageServices().getImagesByName(new String[]{image.getName()}));
        Assert.assertEquals((Object)image, (Object)imageFromServer);
        try {
            ((GoGridClient)this.api).getImageServices().editImageDescription(image.getName(), "newDescription");
            throw new TestException("An exception hasn't been thrown where expected; expected GoGridResponseException");
        }
        catch (GoGridResponseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("GoGridIllegalArgumentException"));
            return;
        }
    }

    @Test(enabled=true)
    public void testShellAccess() throws IOException {
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = ((GoGridClient)this.api).getIpServices().getUnassignedIpList();
        Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
        Server createdServer = ((GoGridClient)this.api).getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", "1", availableIp.getIp(), new AddServerOptions[0]);
        Assert.assertNotNull((Object)createdServer);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        Set response = ((GoGridClient)this.api).getServerServices().getServersByName(new String[]{nameOfServer});
        assert (response.size() == 1);
        createdServer = (Server)Iterables.getOnlyElement((Iterable)response);
        Map credsMap = ((GoGridClient)this.api).getServerServices().getServerCredentialsList();
        LoginCredentials instanceCredentials = LoginCredentials.fromCredentials((Credentials)((Credentials)credsMap.get(createdServer.getName())));
        Assert.assertNotNull((Object)instanceCredentials);
        HostAndPort socket = HostAndPort.fromParts((String)createdServer.getIp().getIp(), (int)22);
        SocketOpen socketOpen = (SocketOpen)Guice.createInjector((Module[])new Module[0]).getInstance(SocketOpen.class);
        Predicate socketTester = Predicates2.retry((Predicate)socketOpen, (long)180L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        socketTester.apply((Object)socket);
        Assert.assertEquals((Object)((GoGridClient)this.api).getServerServices().getServerCredentials(createdServer.getId()), (Object)instanceCredentials);
        try {
            Assert.assertEquals((Object)((GoGridClient)this.api).getServerServices().getServerCredentials(Long.MAX_VALUE), null);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        ((GoGridClient)this.api).getServerServices().deleteByName(nameOfServer);
    }

    @AfterTest
    public void cleanup() {
        for (String serverName : this.serversToDeleteAfterTheTests) {
            try {
                ((GoGridClient)this.api).getServerServices().deleteByName(serverName);
            }
            catch (Exception e) {}
        }
        for (String loadBalancerName : this.loadBalancersToDeleteAfterTest) {
            try {
                ((GoGridClient)this.api).getLoadBalancerServices().deleteByName(loadBalancerName);
            }
            catch (Exception exception) {}
        }
    }
}

