/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Singleton;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.JobProperties;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.functions.ParseJobListFromJsonResponse;
import org.jclouds.gogrid.functions.internal.CustomDeserializers;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseJobsFromJsonResponseTest")
public class ParseJobsFromJsonResponseTest {
    Injector i = Guice.createInjector((Module[])new Module[]{new GsonModule(){

        protected void configure() {
            this.bind(GsonModule.DateAdapter.class).to(GsonModule.LongDateAdapter.class);
            super.configure();
        }

        @Provides
        @Singleton
        public Map<Type, Object> provideCustomAdapterBindings() {
            HashMap bindings = Maps.newHashMap();
            bindings.put(ObjectType.class, new CustomDeserializers.ObjectTypeAdapter());
            bindings.put(JobState.class, new CustomDeserializers.JobStateAdapter());
            return bindings;
        }
    }});

    @Test
    public void testApplyInputStreamDetails() throws UnknownHostException {
        InputStream is = this.getClass().getResourceAsStream("/test_get_job_list.json");
        ParseJobListFromJsonResponse parser = (ParseJobListFromJsonResponse)this.i.getInstance(ParseJobListFromJsonResponse.class);
        SortedSet response = parser.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        ImmutableMap details = ImmutableMap.of((Object)"image", (Object)"GSI-f8979644-e646-4711-ad58-d98a5fa3612c", (Object)"ip", (Object)"204.51.240.189", (Object)"name", (Object)"ServerCreated40562", (Object)"type", (Object)"virtual_server");
        Job job = Job.builder().id(250628L).command(Option.createWithIdNameAndDescription((Long)7L, (String)"DeleteVirtualServer", (String)"Delete Virtual Server")).objectType(ObjectType.VIRTUAL_SERVER).createdOn(new Date(1267404528895L)).lastUpdatedOn(new Date(1267404538592L)).currentState(JobState.SUCCEEDED).attempts(1).owner("3116784158f0af2d-24076@api.gogrid.com").history(new JobProperties[]{JobProperties.builder().id(940263L).updatedOn(new Date(1267404528897L)).state(JobState.CREATED).build(), JobProperties.builder().id(940264L).updatedOn(new Date(1267404528967L)).state(JobState.QUEUED).build()}).details((Map)details).build();
        Assert.assertEquals((Object)job, (Object)Iterables.getOnlyElement((Iterable)response));
    }
}

