/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import org.jclouds.date.TimeStamp;
import org.jclouds.gogrid.GoGridProviderMetadata;
import org.jclouds.gogrid.config.GoGridRestClientModule;
import org.jclouds.gogrid.filters.SharedKeyLiteAuthentication;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public abstract class BaseGoGridAsyncClientTest<T>
extends BaseAsyncClientTest<T> {
    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SharedKeyLiteAuthentication.class);
    }

    protected Module createModule() {
        return new TestGoGridRestClientModule();
    }

    public ProviderMetadata createProviderMetadata() {
        return new GoGridProviderMetadata();
    }

    @ConfiguresRestClient
    protected static final class TestGoGridRestClientModule
    extends GoGridRestClientModule {
        protected TestGoGridRestClientModule() {
        }

        protected void configure() {
            super.configure();
        }

        protected Long provideTimeStamp(@TimeStamp Supplier<Long> cache) {
            return 1267243795L;
        }
    }
}

