/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.functions.ParseImageFromJsonResponse;
import org.jclouds.gogrid.functions.ParseImageListFromJsonResponse;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.SaveImageOptions;
import org.jclouds.gogrid.services.BaseGoGridAsyncClientTest;
import org.jclouds.gogrid.services.GridImageAsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GridImageAsyncClientTest")
public class GridImageAsyncClientTest
extends BaseGoGridAsyncClientTest<GridImageAsyncClient> {
    @Test
    public void testGetImageListWithOptions() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"getImageList", (Class[])new Class[]{GetImageListOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)new GetImageListOptions().onlyPublic().setState(ServerImageState.AVAILABLE).setType(ServerImageType.WEB_APPLICATION_SERVER)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/list?v=1.5&isPublic=true&image.state=Available&image.type=Web%20Server HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/list?v=1.5&isPublic=true&image.state=Available&image.type=Web%20Server&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetImagesByName() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"getImagesByName", (Class[])new Class[]{String[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"name1", (Object)"name2"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/get?v=1.5&name=name1&name=name2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/get?v=1.5&name=name1&name=name2&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditImageDescription() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"editImageDescription", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"imageName", (Object)"newDesc"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&description=newDesc HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&description=newDesc&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditImageFriendlyName() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"editImageFriendlyName", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"imageName", (Object)"newFriendlyName"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&friendlyName=newFriendlyName HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/edit?v=1.5&image=imageName&friendlyName=newFriendlyName&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testDeleteById() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"deleteById", (Class[])new Class[]{Long.TYPE});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)11L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/delete?v=1.5&id=11 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
    }

    @Test
    public void testSaveImageFromServerNoOptions() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"saveImageFromServer", (Class[])new Class[]{String.class, String.class, SaveImageOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"friendly", (Object)"serverName"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/save?v=1.5&friendlyName=friendly&server=serverName HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }

    @Test
    public void testSaveImageOptions() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridImageAsyncClient.class, (String)"saveImageFromServer", (Class[])new Class[]{String.class, String.class, SaveImageOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"friendly", (Object)"serverName", (Object)new SaveImageOptions().withDescription("fooy")));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/image/save?v=1.5&friendlyName=friendly&server=serverName&description=fooy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseImageFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
    }
}

