/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.gogrid.functions.ParseJobListFromJsonResponse;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.gogrid.services.BaseGoGridAsyncClientTest;
import org.jclouds.gogrid.services.GridJobAsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GridJobAsyncClientTest")
public class GridJobAsyncClientTest
extends BaseGoGridAsyncClientTest<GridJobAsyncClient> {
    @Test
    public void testGetJobListWithOptions() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridJobAsyncClient.class, (String)"getJobList", (Class[])new Class[]{GetJobListOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)GetJobListOptions.Builder.startDate((Date)new Date(1267385381770L)).withEndDate(new Date(1267385382770L)).onlyForObjectType(ObjectType.VIRTUAL_SERVER).onlyForState(JobState.PROCESSING)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&startdate=1267385381770&enddate=1267385382770&job.objecttype=VirtualServer&job.state=Processing HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJobListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&startdate=1267385381770&enddate=1267385382770&job.objecttype=VirtualServer&job.state=Processing&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetJobListNoOptions() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridJobAsyncClient.class, (String)"getJobList", (Class[])new Class[]{GetJobListOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetJobsForServerName() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridJobAsyncClient.class, (String)"getJobsForObjectName", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"MyServer"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&object=MyServer HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJobListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/list?v=1.5&object=MyServer&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetJobsById() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridJobAsyncClient.class, (String)"getJobsById", (Class[])new Class[]{long[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)123L, (Object)456L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/get?v=1.5&id=123&id=456 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseJobListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/job/get?v=1.5&id=123&id=456&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }
}

