/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.beans.ConstructorProperties;
import org.jclouds.gogrid.domain.IpState;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.javax.annotation.Nullable;

public class Ip
implements Comparable<Ip> {
    private final long id;
    private final String ip;
    private final String subnet;
    private final boolean isPublic;
    private final IpState state;
    private final Option datacenter;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromIp(this);
    }

    @ConstructorProperties(value={"id", "ip", "subnet", "public", "state", "datacenter"})
    protected Ip(long id, String ip, @Nullable String subnet, boolean isPublic, @Nullable IpState state, @Nullable Option datacenter) {
        this.id = id;
        this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
        this.subnet = subnet;
        this.isPublic = isPublic;
        this.state = state == null ? IpState.UNRECOGNIZED : state;
        this.datacenter = datacenter;
    }

    public long getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    @Nullable
    public String getSubnet() {
        return this.subnet;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public IpState getState() {
        return this.state;
    }

    @Nullable
    public Option getDatacenter() {
        return this.datacenter;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.ip, this.subnet, this.isPublic, this.state, this.datacenter});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Ip that = (Ip)Ip.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.ip, (Object)that.ip) && Objects.equal((Object)this.subnet, (Object)that.subnet) && Objects.equal((Object)this.isPublic, (Object)that.isPublic) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.datacenter, (Object)that.datacenter);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("ip", (Object)this.ip).add("subnet", (Object)this.subnet).add("isPublic", this.isPublic).add("state", (Object)this.state).add("datacenter", (Object)this.datacenter);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Ip o) {
        return Longs.compare((long)this.id, (long)o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long id;
        protected String ip;
        protected String subnet;
        protected boolean isPublic;
        protected IpState state;
        protected Option datacenter;

        protected abstract T self();

        public T id(long id) {
            this.id = id;
            return this.self();
        }

        public T ip(String ip) {
            this.ip = ip;
            return this.self();
        }

        public T subnet(String subnet) {
            this.subnet = subnet;
            return this.self();
        }

        public T isPublic(boolean isPublic) {
            this.isPublic = isPublic;
            return this.self();
        }

        public T state(IpState state) {
            this.state = state;
            return this.self();
        }

        public T datacenter(Option datacenter) {
            this.datacenter = datacenter;
            return this.self();
        }

        public Ip build() {
            return new Ip(this.id, this.ip, this.subnet, this.isPublic, this.state, this.datacenter);
        }

        public T fromIp(Ip in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).ip(in.getIp())).subnet(in.getSubnet())).isPublic(in.isPublic())).state(in.getState())).datacenter(in.getDatacenter());
        }
    }
}

