
package org.jclouds.googlecloudstorage.domain;

import javax.annotation.Generated;
import org.jclouds.javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_RewriteResponse extends RewriteResponse {

  private final long totalBytesRewritten;
  private final long objectSize;
  private final boolean done;
  private final String rewriteToken;
  private final GoogleCloudStorageObject resource;

  AutoValue_RewriteResponse(
      long totalBytesRewritten,
      long objectSize,
      boolean done,
      @Nullable String rewriteToken,
      GoogleCloudStorageObject resource) {
    this.totalBytesRewritten = totalBytesRewritten;
    this.objectSize = objectSize;
    this.done = done;
    this.rewriteToken = rewriteToken;
    if (resource == null) {
      throw new NullPointerException("Null resource");
    }
    this.resource = resource;
  }

  @Override
  public long totalBytesRewritten() {
    return totalBytesRewritten;
  }

  @Override
  public long objectSize() {
    return objectSize;
  }

  @Override
  public boolean done() {
    return done;
  }

  @Nullable
  @Override
  public String rewriteToken() {
    return rewriteToken;
  }

  @Override
  public GoogleCloudStorageObject resource() {
    return resource;
  }

  @Override
  public String toString() {
    return "RewriteResponse{"
        + "totalBytesRewritten=" + totalBytesRewritten + ", "
        + "objectSize=" + objectSize + ", "
        + "done=" + done + ", "
        + "rewriteToken=" + rewriteToken + ", "
        + "resource=" + resource
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RewriteResponse) {
      RewriteResponse that = (RewriteResponse) o;
      return (this.totalBytesRewritten == that.totalBytesRewritten())
           && (this.objectSize == that.objectSize())
           && (this.done == that.done())
           && ((this.rewriteToken == null) ? (that.rewriteToken() == null) : this.rewriteToken.equals(that.rewriteToken()))
           && (this.resource.equals(that.resource()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (this.totalBytesRewritten >>> 32) ^ this.totalBytesRewritten;
    h *= 1000003;
    h ^= (this.objectSize >>> 32) ^ this.objectSize;
    h *= 1000003;
    h ^= this.done ? 1231 : 1237;
    h *= 1000003;
    h ^= (rewriteToken == null) ? 0 : this.rewriteToken.hashCode();
    h *= 1000003;
    h ^= this.resource.hashCode();
    return h;
  }

}
