/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage;

import com.google.common.collect.FluentIterable;
import java.net.URI;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApiMetadata;
import org.jclouds.hpcloud.objectstorage.domain.CDNContainer;
import org.jclouds.hpcloud.objectstorage.extensions.CDNContainerApi;
import org.jclouds.hpcloud.objectstorage.options.ListCDNContainerOptions;
import org.jclouds.openstack.swift.CommonSwiftClientLiveTest;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="HPCloudObjectStorageClientLiveTest")
public class HPCloudObjectStorageClientLiveTest
extends CommonSwiftClientLiveTest<HPCloudObjectStorageApi> {
    public HPCloudObjectStorageClientLiveTest() {
        this.provider = "hpcloud-objectstorage";
    }

    public HPCloudObjectStorageApi getApi() {
        return (HPCloudObjectStorageApi)((RestContext)((BlobStoreContext)this.view).unwrap(HPCloudObjectStorageApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    protected void testGetObjectContentType(SwiftObject getBlob) {
        Assert.assertEquals((String)getBlob.getInfo().getContentType(), (String)"application/x-www-form-urlencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=true)
    public void testCDNOperations() throws Exception {
        long minimumTTL = 3600L;
        String containerNameWithCDN = this.getContainerName();
        String containerNameWithoutCDN = this.getContainerName();
        try {
            try {
                ((CDNContainerApi)this.getApi().getCDNExtension().get()).disable(containerNameWithCDN);
                ((CDNContainerApi)this.getApi().getCDNExtension().get()).disable(containerNameWithoutCDN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CDNContainer cdnMetadata = null;
            URI cdnUri = ((CDNContainerApi)this.getApi().getCDNExtension().get()).enable(containerNameWithCDN);
            Assert.assertNotNull((Object)cdnUri);
            cdnMetadata = ((CDNContainerApi)this.getApi().getCDNExtension().get()).get(containerNameWithCDN);
            Assert.assertTrue((boolean)cdnMetadata.isCDNEnabled());
            Assert.assertEquals((Object)cdnMetadata.getCDNUri(), (Object)cdnUri);
            cdnMetadata = ((CDNContainerApi)this.getApi().getCDNExtension().get()).get(containerNameWithoutCDN);
            assert (cdnMetadata == null || !cdnMetadata.isCDNEnabled()) : containerNameWithoutCDN + " should not have metadata";
            assert (((CDNContainerApi)this.getApi().getCDNExtension().get()).get("DoesNotExist") == null);
            FluentIterable cdnMetadataList = ((CDNContainerApi)this.getApi().getCDNExtension().get()).list();
            Assert.assertTrue((cdnMetadataList.size() >= 1 ? 1 : 0) != 0);
            long initialTTL = cdnMetadata.getTTL();
            Assert.assertTrue((boolean)cdnMetadataList.contains((Object)CDNContainer.builder().name(containerNameWithCDN).CDNEnabled(true).ttl(initialTTL).CDNUri(cdnUri).build()));
            cdnMetadataList = ((CDNContainerApi)this.getApi().getCDNExtension().get()).list(ListCDNContainerOptions.Builder.afterMarker((String)containerNameWithCDN.substring(0, containerNameWithCDN.length() - 1)).maxResults(1));
            Assert.assertEquals((int)cdnMetadataList.size(), (int)1);
            long ttl = 4000L;
            ((CDNContainerApi)this.getApi().getCDNExtension().get()).enable(containerNameWithCDN, ttl);
            cdnMetadata = ((CDNContainerApi)this.getApi().getCDNExtension().get()).get(containerNameWithCDN);
            Assert.assertTrue((boolean)cdnMetadata.isCDNEnabled());
            Assert.assertEquals((long)cdnMetadata.getTTL(), (long)ttl);
            ttl = 3600L;
            ((CDNContainerApi)this.getApi().getCDNExtension().get()).update(containerNameWithCDN, 3600L);
            cdnMetadata = ((CDNContainerApi)this.getApi().getCDNExtension().get()).get(containerNameWithCDN);
            Assert.assertTrue((boolean)cdnMetadata.isCDNEnabled());
            Assert.assertEquals((long)cdnMetadata.getTTL(), (long)3600L);
            ((CDNContainerApi)this.getApi().getCDNExtension().get()).update(containerNameWithCDN, 3599L);
            cdnMetadata = ((CDNContainerApi)this.getApi().getCDNExtension().get()).get(containerNameWithCDN);
            Assert.assertEquals((long)cdnMetadata.getTTL(), (long)3599L);
            Assert.assertTrue((boolean)((CDNContainerApi)this.getApi().getCDNExtension().get()).disable(containerNameWithCDN));
            cdnMetadata = ((CDNContainerApi)this.getApi().getCDNExtension().get()).get(containerNameWithCDN);
            Assert.assertEquals((boolean)cdnMetadata.isCDNEnabled(), (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.recycleContainer(containerNameWithCDN);
            this.recycleContainer(containerNameWithoutCDN);
        }
    }
}

