/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.internal.BaseBlobSignerExpectTest;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApiMetadata;
import org.jclouds.hpcloud.objectstorage.blobstore.config.HPCloudObjectStorageBlobStoreContextModule;
import org.jclouds.hpcloud.objectstorage.config.HPCloudObjectStorageRestClientModule;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.config.MappedAuthenticationApiModule;
import org.jclouds.openstack.swift.config.SwiftRestClientModule;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HPCloudObjectStorageBlobSignerExpectTest")
public class HPCloudObjectStorageBlobSignerExpectTest
extends BaseBlobSignerExpectTest {
    public HPCloudObjectStorageBlobSignerExpectTest() {
        this.identity = "12346637803162:identity";
    }

    protected HttpRequest getBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
    }

    protected HttpRequest getBlobWithTime() {
        return HttpRequest.builder().method("GET").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name?temp_url_sig=40806637803162%3Aidentity%3Ada88bc31122f0d0806b1c7bf71cd3af5c5d5b94c&temp_url_expires=123456792").build();
    }

    protected HttpRequest getBlobWithOptions() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).addHeader("Range", new String[]{"bytes=0-1"})).build();
    }

    protected HttpRequest putBlob() {
        return ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("ETag", new String[]{"00020408"})).addHeader("Expect", new String[]{"100-continue"})).addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
    }

    protected HttpRequest putBlobWithTime() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name?temp_url_sig=40806637803162%3Aidentity%3Ac90269245ab0a316d5ea5e654d4c2a975fb4bf77&temp_url_expires=123456792").addHeader("Expect", new String[]{"100-continue"})).build();
    }

    protected HttpRequest removeBlob() {
        return ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://objects.jclouds.org/v1.0/40806637803162/container/name").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
    }

    protected Map<HttpRequest, HttpResponse> init() {
        HttpRequest authenticate = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/tokens").addHeader("Accept", new String[]{"application/json"})).payload(HPCloudObjectStorageBlobSignerExpectTest.payloadFromStringWithContentType((String)"{\"auth\":{\"passwordCredentials\":{\"username\":\"identity\",\"password\":\"credential\"},\"tenantName\":\"12346637803162\"}}", (String)"application/json"))).build();
        HttpResponse authenticationResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/keystoneAuthResponseWithCDN.json", "application/json"))).build();
        HttpRequest temporaryKeyRequest = ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://objects.jclouds.org/v1.0/40806637803162/").addHeader("X-Auth-Token", new String[]{"Auth_4f173437e4b013bee56d1007"})).build();
        HttpResponse temporaryKeyResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).addHeader("X-Account-Meta-Temp-Url-Key", new String[]{"TEMPORARY_KEY"})).build();
        return ImmutableMap.builder().put((Object)authenticate, (Object)authenticationResponse).put((Object)temporaryKeyRequest, (Object)temporaryKeyResponse).build();
    }

    protected ApiMetadata createApiMetadata() {
        return ((HPCloudObjectStorageApiMetadata.Builder)new HPCloudObjectStorageApiMetadata().toBuilder().defaultModules((Set)ImmutableSet.builder().add(MappedAuthenticationApiModule.class).add(SwiftRestClientModule.KeystoneStorageEndpointModule.class).add(KeystoneAuthenticationModule.RegionModule.class).add(HPCloudObjectStorageRestClientModule.class).add(HPCloudObjectStorageBlobStoreContextModule.class).add(StaticTimeAndTemporaryUrlKeyModule.class).build())).build();
    }

    public static class StaticTimeAndTemporaryUrlKeyModule
    extends HPCloudObjectStorageApiMetadata.HPCloudObjectStorageTemporaryUrlExtensionModule {
        public static final long UNIX_EPOCH_TIMESTAMP = 123456789L;

        protected Long unixEpochTimestampProvider() {
            return 123456789L;
        }
    }
}

