/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud;

import com.google.common.net.HostAndPort;
import java.util.Map;
import java.util.Properties;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ssh.SshClient;
import org.jclouds.trmk.ecloud.TerremarkECloudClient;
import org.jclouds.trmk.ecloud.suppliers.TerremarkECloudInternetServiceAndPublicIpAddressSupplier;
import org.jclouds.trmk.vcloud_0_8.TerremarkClientLiveTest;
import org.jclouds.trmk.vcloud_0_8.domain.InternetService;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.PublicIpAddress;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true, testName="TerremarkECloudClientLiveTest")
public class TerremarkECloudClientLiveTest
extends TerremarkClientLiveTest {
    public TerremarkECloudClientLiveTest() {
        this.provider = "trmk-ecloud";
        this.itemName = "Ubuntu Server 10.04 x64";
        this.expectedOs = "Ubuntu Linux (64-bit)";
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.setProperty("jclouds.vcloud.defaults.vdc", ".* - " + System.getProperty("test.trmk-ecloud.datacenter", "MIA"));
        return props;
    }

    protected SshClient getConnectionFor(HostAndPort socket) {
        return this.sshFactory.create(socket, LoginCredentials.builder().user("ecloud").password("TmrkCl0ud1s#1!").privateKey(this.key.getPrivateKey()).authenticateSudo(true).build());
    }

    protected Map.Entry<InternetService, PublicIpAddress> getNewInternetServiceAndIpForSSH(VApp vApp) {
        return new TerremarkECloudInternetServiceAndPublicIpAddressSupplier((TerremarkECloudClient)TerremarkECloudClient.class.cast(this.api)).getNewInternetServiceAndIp(vApp, 22, Protocol.TCP);
    }
}

