/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Module;
import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.QueueDispatcher;
import com.google.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.rest.RestContext;
import org.jclouds.trmk.ecloud.TerremarkECloudApiMetadata;
import org.jclouds.trmk.ecloud.TerremarkECloudClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TerremarkECloudClientMockTest {
    private static final Set<Module> modules = ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
    String versionXML = "<SupportedVersions><VersionInfo><Version>0.8b-ext2.8</Version><LoginUrl>URLv0.8/login</LoginUrl></VersionInfo></SupportedVersions>";

    static TerremarkECloudClient mockTerremarkECloudClient(String uri) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.max-retries", "1");
        return (TerremarkECloudClient)((RestContext)ContextBuilder.newBuilder((String)"trmk-ecloud").credentials("user", "password").endpoint(uri).overrides(overrides).modules(modules).build(TerremarkECloudApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoginSetsContentLength() throws IOException, InterruptedException {
        MockWebServer server = new MockWebServer();
        AtomicReference<URL> url = this.setURLReplacingDispatcher(server);
        server.enqueue(new MockResponse().setResponseCode(200).setBody(this.versionXML));
        server.enqueue(new MockResponse().setResponseCode(200).addHeader("x-vcloud-authorization", (Object)"cookie").setBody("<OrgList />"));
        server.play();
        url.set(server.getUrl("/"));
        TerremarkECloudClient api = TerremarkECloudClientMockTest.mockTerremarkECloudClient(url.get().toString());
        try {
            api.listOrgs();
        }
        finally {
            RecordedRequest getVersions = server.takeRequest();
            Assert.assertEquals((String)getVersions.getRequestLine(), (String)"GET /versions HTTP/1.1");
            RecordedRequest login = server.takeRequest();
            Assert.assertEquals((String)login.getRequestLine(), (String)"POST /v0.8/login HTTP/1.1");
            Assert.assertEquals((String)login.getHeader("Authorization"), (String)"Basic dXNlcjpwYXNzd29yZA==");
            Assert.assertEquals((String)login.getHeader("Content-Length"), (String)"0");
            server.shutdown();
        }
    }

    private AtomicReference<URL> setURLReplacingDispatcher(MockWebServer server) {
        final AtomicReference<URL> url = new AtomicReference<URL>();
        QueueDispatcher dispatcher = new QueueDispatcher(){
            protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                MockResponse response = this.responseQueue.take();
                if (response.getBody() != null) {
                    String newBody = new String(response.getBody()).replace("URL", ((URL)url.get()).toString());
                    response = response.setBody(newBody);
                }
                return response;
            }

            public void enqueueResponse(MockResponse response) {
                this.responseQueue.add(response);
            }
        };
        server.setDispatcher((Dispatcher)dispatcher);
        return url;
    }
}

