/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.trmk.ecloud.compute.functions.TerremarkECloudParseOsFromVAppTemplateName;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.xml.CatalogHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TerremarkECloudParseOsFromVAppTemplateNameTest")
public class TerremarkECloudParseOsFromVAppTemplateNameTest {
    public Set<String> parseNames(String resource) {
        InputStream is = this.getClass().getResourceAsStream(resource);
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        return ((Catalog)factory.create((ParseSax.HandlerWithResult)injector.getInstance(CatalogHandler.class)).parse(is)).keySet();
    }

    public void test() {
        TerremarkECloudParseOsFromVAppTemplateName function = new TerremarkECloudParseOsFromVAppTemplateName((Map)((Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class)).fromJson(new ComputeServiceConstants.ReferenceData().osVersionMapJson, new TypeLiteral<Map<OsFamily, Map<String, String>>>(){}.getType()));
        Set<String> names = this.parseNames("/catalog-ecloud.xml");
        Assert.assertEquals((Set)Sets.newLinkedHashSet((Iterable)Iterables.transform(names, (Function)function)), (Set)ImmutableSet.of((Object)new OperatingSystem.Builder().family(OsFamily.CENTOS).version("5.0").description("CentOS 5 (x64)").is64Bit(true).build(), (Object)new OperatingSystem.Builder().family(OsFamily.CENTOS).version("5.0").description("CentOS 5 (x86)").is64Bit(false).build(), (Object)new OperatingSystem.Builder().family(OsFamily.CENTOS).version("5.5").description("CentOS 5.5 x32").is64Bit(false).build(), (Object)new OperatingSystem.Builder().family(OsFamily.CENTOS).version("5.5").description("CentOS 5.5 x64").is64Bit(true).build(), (Object)new OperatingSystem.Builder().family(OsFamily.RHEL).version("5.0").description("Red Hat Enterprise Linux 5 (x64)").is64Bit(true).build(), (Object)new OperatingSystem.Builder().family(OsFamily.RHEL).version("5.0").description("Red Hat Enterprise Linux 5 (x86)").is64Bit(false).build(), (Object[])new OperatingSystem[]{new OperatingSystem.Builder().family(OsFamily.RHEL).version("5.5").description("Red Hat Enterprise Linux 5.5 x32").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.RHEL).version("5.5").description("Red Hat Enterprise Linux 5.5 x64").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.SOLARIS).version("10").description("Sun Solaris 10 (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.UBUNTU).version("8.04").description("Ubuntu 8.04 LTS (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.UBUNTU).version("8.04").description("Ubuntu 8.04 LTS (x86)").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.UBUNTU).version("10.04").description("Ubuntu Server 10.04 x32").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.UBUNTU).version("10.04").description("Ubuntu Server 10.04 x64").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2003 R2").description("-Windows 2003 Std. R2 SQL 2005 Std. (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2003 R2").description("-Windows 2003 Std. R2 SQL 2008 Std. (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008 R2").description("-Windows 2008 R2 Std wSQL 2008 R2 Std (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008 R2").description("-Windows 2008 R2 Std wSQL 2008 R2 Web (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows 2008 Std wSQL 2008 Std (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows 2008 Std wSQL 2008 Web (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2003 R2").description("-Windows Server 2003 R2 Enterprise Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2003 R2").description("-Windows Server 2003 R2 Enterprise Edition (x86)").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2003 R2").description("-Windows Server 2003 R2 Standard Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2003 R2").description("-Windows Server 2003 R2 Standard Edition (x86)").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows Server 2008 Enterprise Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows Server 2008 Enterprise Edition (x86)").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008 R2").description("-Windows Server 2008 R2 Enterprise Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008 R2").description("-Windows Server 2008 R2 Standard Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008 R2").description("-Windows Server 2008 R2 Web Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows Server 2008 Standard Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows Server 2008 Standard Edition (x86)").is64Bit(false).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows Server 2008 Web Edition (x64)").is64Bit(true).build(), new OperatingSystem.Builder().family(OsFamily.WINDOWS).version("2008").description("-Windows Server 2008 Web Edition (x86)").is64Bit(false).build()}));
    }
}

