/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.ecloud.BaseTerremarkECloudAsyncClientTest;
import org.jclouds.trmk.ecloud.features.TagOperationsAsyncClient;
import org.jclouds.trmk.ecloud.xml.TagNameToUsageCountHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TagOperationsAsyncClientTest")
public class TagOperationsAsyncClientTest
extends BaseTerremarkECloudAsyncClientTest<TagOperationsAsyncClient> {
    public void testgetTagNameToUsageCount() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TagOperationsAsyncClient.class, (String)"getTagNameToUsageCount", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/deviceTags")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/deviceTags HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.tagsList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TagNameToUsageCountHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptyMapOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testgetTagNameToUsageCountInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TagOperationsAsyncClient.class, (String)"getTagNameToUsageCountInOrg", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/deviceTags/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.tagsList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TagNameToUsageCountHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptyMapOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

