/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.xml;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.ecloud.TerremarkECloudApiMetadata;
import org.jclouds.trmk.ecloud.domain.ECloudOrg;
import org.jclouds.trmk.ecloud.xml.ECloudOrgHandler;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ECloudOrgHandlerTest")
public class ECloudOrgHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                Names.bindProperties((Binder)this.binder(), (Properties)TerremarkECloudApiMetadata.defaultProperties());
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org-ecloud.xml");
        ECloudOrg result = (ECloudOrg)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(ECloudOrgHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Cloud Conscious, LLC");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/org/1910324"));
        Assert.assertEquals((Map)result.getVDCs(), (Map)ImmutableMap.of((Object)"Cloud Conscious LLC - MIA", (Object)new ReferenceTypeImpl("Cloud Conscious LLC - MIA", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/vdc/1155")), (Object)"Cloud Conscious LLC - AMA", (Object)new ReferenceTypeImpl("Cloud Conscious LLC - AMA", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/vdc/1169"))));
        Assert.assertEquals((Map)result.getCatalogs(), (Map)ImmutableMap.of((Object)"Cloud Conscious LLC - MIA Catalog", (Object)new ReferenceTypeImpl("Cloud Conscious LLC - MIA Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/vdc/1155/catalog")), (Object)"Cloud Conscious LLC - AMA Catalog", (Object)new ReferenceTypeImpl("Cloud Conscious LLC - AMA Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/vdc/1169/catalog"))));
        Assert.assertEquals((Map)result.getTasksLists(), (Map)ImmutableMap.of((Object)"Cloud Conscious LLC - MIA Tasks List", (Object)new ReferenceTypeImpl("Cloud Conscious LLC - MIA Tasks List", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/vdc/1155/tasksList")), (Object)"Cloud Conscious LLC - AMA Tasks List", (Object)new ReferenceTypeImpl("Cloud Conscious LLC - AMA Tasks List", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/vdc/1169/tasksList"))));
        Assert.assertEquals((Object)result.getKeys(), (Object)new ReferenceTypeImpl("Keys", "application/vnd.tmrk.ecloud.keysList+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/keys")));
        Assert.assertEquals((Object)result.getTags(), (Object)new ReferenceTypeImpl("Device Tags", "application/vnd.tmrk.ecloud.tagsList+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/deviceTags")));
        Assert.assertEquals((Object)result.getVAppCatalog(), (Object)new ReferenceTypeImpl("VApp Catalog", "application/vnd.tmrk.ecloud.VAppCatalogList+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/vappCatalog")));
        Assert.assertEquals((Object)result.getDataCenters(), (Object)new ReferenceTypeImpl("DataCenters", "application/vnd.tmrk.ecloud.dataCentersList+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/dataCenters")));
    }
}

