/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import org.apache.jena.query.ARQ;
import org.apache.jena.riot.IO_Jena;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.mgt.SystemInfo;

public class RIOT {
    public static final String riotIRI = "http://jena.apache.org/#riot";
    public static final String NAME = "RIOT";
    public static String VERSION;
    public static String BUILD_DATE;
    public static final String PATH = "org.apache.jena.riot";
    private static volatile boolean initialized;
    private static Object initLock;
    private static boolean registered;

    public static void setStrictMode(boolean state) {
        SysRIOT.strictMode = state;
        SysRIOT.StrictXSDLexicialForms = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                return;
            }
            initialized = true;
            RDFLanguages.init();
            RDFParserRegistry.init();
            RDFWriterRegistry.init();
            IO_Jena.wireIntoJena();
        }
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        VERSION = RIOT.getVersion();
        BUILD_DATE = RIOT.getBuildDate();
        SystemInfo sysInfo2 = new SystemInfo(riotIRI, PATH, VERSION, BUILD_DATE);
        SystemARQ.registerSubSystem(sysInfo2);
    }

    public static String getVersion() {
        return ARQ.VERSION;
    }

    public static String getBuildDate() {
        return ARQ.BUILD_DATE;
    }

    static {
        initialized = false;
        initLock = new Object();
        registered = false;
    }
}

