/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.lang.LangBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.vocabulary.OWL;

public abstract class LangTurtleBase
extends LangBase {
    protected static final String KW_A = "a";
    protected static final String KW_SAME_AS = "=";
    protected static final String KW_LOG_IMPLIES = "=>";
    protected static final String KW_TRUE = "true";
    protected static final String KW_FALSE = "false";
    protected static final boolean VERBOSE = false;
    private Node currentGraph = null;
    protected static final Node nodeSameAs = OWL.sameAs.asNode();
    protected static final Node nodeLogImplies = NodeFactory.createURI((String)"http://www.w3.org/2000/10/swap/log#implies");

    public final Node getCurrentGraph() {
        return this.currentGraph;
    }

    public final void setCurrentGraph(Node graph) {
        this.currentGraph = graph;
    }

    protected LangTurtleBase(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    protected final void runParser() {
        while (this.moreTokens()) {
            Token t = this.peekToken();
            if (this.lookingAt(TokenType.DIRECTIVE)) {
                this.directive();
                continue;
            }
            if (this.lookingAt(TokenType.KEYWORD) && (t.getImage().equalsIgnoreCase("PREFIX") || t.getImage().equalsIgnoreCase("BASE"))) {
                this.directiveKeyword();
                continue;
            }
            this.oneTopLevelElement();
            if (!this.lookingAt(TokenType.EOF)) continue;
            break;
        }
    }

    protected abstract void oneTopLevelElement();

    protected abstract void emit(Node var1, Node var2, Node var3);

    protected final void directiveKeyword() {
        Token t = this.peekToken();
        String x = t.getImage();
        this.nextToken();
        if (x.equalsIgnoreCase("BASE")) {
            this.directiveBase();
            return;
        }
        if (x.equalsIgnoreCase("PREFIX")) {
            this.directivePrefix();
            return;
        }
        this.exception(t, "Unrecognized keyword for directive: %s", x);
    }

    protected final void directive() {
        Token t = this.peekToken();
        String x = t.getImage();
        this.nextToken();
        if (x.equals("base")) {
            this.directiveBase();
            if (this.profile.isStrictMode()) {
                this.expect("Base directive not terminated by a dot", TokenType.DOT);
            } else {
                this.skipIf(TokenType.DOT);
            }
            return;
        }
        if (x.equals("prefix")) {
            this.directivePrefix();
            if (this.profile.isStrictMode()) {
                this.expect("Prefix directive not terminated by a dot", TokenType.DOT);
            } else {
                this.skipIf(TokenType.DOT);
            }
            return;
        }
        this.exception(t, "Unrecognized directive: %s", x);
    }

    protected final void directivePrefix() {
        if (!this.lookingAt(TokenType.PREFIXED_NAME)) {
            this.exception(this.peekToken(), "@prefix or PREFIX requires a prefix (found '" + this.peekToken() + "')", new Object[0]);
        }
        if (this.peekToken().getImage2().length() != 0) {
            this.exception(this.peekToken(), "@prefix or PREFIX requires a prefix with no suffix (found '" + this.peekToken() + "')", new Object[0]);
        }
        String prefix = this.peekToken().getImage();
        this.nextToken();
        if (!this.lookingAt(TokenType.IRI)) {
            this.exception(this.peekToken(), "@prefix requires an IRI (found '" + this.peekToken() + "')", new Object[0]);
        }
        String iriStr = this.peekToken().getImage();
        IRI iri2 = this.profile.makeIRI(iriStr, this.currLine, this.currCol);
        this.profile.getPrologue().getPrefixMap().add(prefix, iri2);
        this.emitPrefix(prefix, iri2.toString());
        this.nextToken();
    }

    protected final void directiveBase() {
        Token token = this.peekToken();
        if (!this.lookingAt(TokenType.IRI)) {
            this.exception(token, "@base requires an IRI (found '" + token + "')", new Object[0]);
        }
        String baseStr = token.getImage();
        IRI baseIRI = this.profile.makeIRI(baseStr, this.currLine, this.currCol);
        this.emitBase(baseIRI.toString());
        this.nextToken();
        this.profile.getPrologue().setBaseURI(baseIRI);
    }

    protected final void triplesSameSubject() {
        if (this.lookingAt(TokenType.NODE)) {
            this.triples();
            return;
        }
        boolean maybeList = this.lookingAt(TokenType.LPAREN);
        if (this.peekTriplesNodeCompound()) {
            Node n = this.triplesNodeCompound();
            if (this.profile.isStrictMode() && maybeList) {
                if (this.peekPredicate()) {
                    this.predicateObjectList(n);
                    this.expectEndOfTriples();
                    return;
                }
                this.exception(this.peekToken(), "Predicate/object required after (...) - Unexpected token : %s", this.peekToken());
            }
            if (this.lookingAt(TokenType.EOF)) {
                return;
            }
            if (this.lookingAt(TokenType.DOT)) {
                this.nextToken();
                return;
            }
            if (this.peekPredicate()) {
                this.predicateObjectList(n);
            }
            this.expectEndOfTriples();
            return;
        }
        this.exception(this.peekToken(), "Out of place: %s", this.peekToken());
    }

    protected final void triples() {
        Node subject = this.node();
        if (subject == null) {
            this.exception(this.peekToken(), "Not recognized: expected node: %s", this.peekToken().text());
        }
        this.nextToken();
        this.predicateObjectList(subject);
        this.expectEndOfTriples();
    }

    protected abstract void expectEndOfTriples();

    protected void expectEndOfTriplesTurtle() {
        if (this.profile.isStrictMode()) {
            this.expect("Triples not terminated by DOT", TokenType.DOT);
        } else {
            this.expectOrEOF("Triples not terminated by DOT", TokenType.DOT);
        }
    }

    protected final void predicateObjectList(Node subject) {
        this.predicateObjectItem(subject);
        while (this.lookingAt(TokenType.SEMICOLON)) {
            while (this.lookingAt(TokenType.SEMICOLON)) {
                this.nextToken();
            }
            if (!this.peekPredicate()) break;
            this.predicateObjectItem(subject);
        }
    }

    protected final void predicateObjectItem(Node subject) {
        Node predicate = this.predicate();
        this.nextToken();
        this.objectList(subject, predicate);
    }

    protected final Node predicate() {
        Node n;
        Token t = this.peekToken();
        if (t.hasType(TokenType.KEYWORD)) {
            boolean strict = this.profile.isStrictMode();
            Token tErr = this.peekToken();
            String image = this.peekToken().getImage();
            if (image.equals(KW_A)) {
                return NodeConst.nodeRDFType;
            }
            if (!strict && image.equals(KW_SAME_AS)) {
                return nodeSameAs;
            }
            if (!strict && image.equals(KW_LOG_IMPLIES)) {
                return NodeConst.nodeRDFType;
            }
            this.exception(tErr, "Unrecognized: " + image, new Object[0]);
        }
        if ((n = this.node()) == null || !n.isURI()) {
            this.exception(t, "Expected IRI for predicate: got: %s", t);
        }
        return n;
    }

    protected final boolean peekPredicate() {
        if (this.lookingAt(TokenType.KEYWORD)) {
            String image = this.peekToken().getImage();
            boolean strict = this.profile.isStrictMode();
            if (image.equals(KW_A)) {
                return true;
            }
            if (!strict && image.equals(KW_SAME_AS)) {
                return true;
            }
            return !strict && image.equals(KW_LOG_IMPLIES);
        }
        if (this.lookingAt(TokenType.IRI)) {
            return true;
        }
        return this.lookingAt(TokenType.PREFIXED_NAME);
    }

    protected final Node node() {
        Node n = this.tokenAsNode(this.peekToken());
        if (n == null) {
            return null;
        }
        return n;
    }

    protected final void objectList(Node subject, Node predicate) {
        while (true) {
            Node object = this.triplesNode();
            this.emitTriple(subject, predicate, object);
            if (!this.moreTokens() || !this.lookingAt(TokenType.COMMA)) break;
            this.nextToken();
        }
    }

    protected final Node triplesNode() {
        if (this.lookingAt(TokenType.NODE)) {
            Node n = this.node();
            this.nextToken();
            return n;
        }
        if (this.lookingAt(TokenType.KEYWORD)) {
            Token tErr = this.peekToken();
            String image = this.peekToken().getImage();
            this.nextToken();
            if (image.equals(KW_TRUE)) {
                return NodeConst.nodeTrue;
            }
            if (image.equals(KW_FALSE)) {
                return NodeConst.nodeFalse;
            }
            if (image.equals(KW_A)) {
                this.exception(tErr, "Keyword 'a' not legal at this point", new Object[0]);
            }
            this.exception(tErr, "Unrecognized keyword: " + image, new Object[0]);
        }
        return this.triplesNodeCompound();
    }

    protected final boolean peekTriplesNodeCompound() {
        if (this.lookingAt(TokenType.LBRACKET)) {
            return true;
        }
        if (this.lookingAt(TokenType.LBRACE)) {
            return true;
        }
        return this.lookingAt(TokenType.LPAREN);
    }

    protected final Node triplesNodeCompound() {
        if (this.lookingAt(TokenType.LBRACKET)) {
            return this.triplesBlankNode();
        }
        if (this.lookingAt(TokenType.LBRACE)) {
            return this.triplesFormula();
        }
        if (this.lookingAt(TokenType.LPAREN)) {
            return this.triplesList();
        }
        this.exception(this.peekToken(), "Unrecognized: " + this.peekToken(), new Object[0]);
        return null;
    }

    protected final Node triplesBlankNode() {
        Token t = this.nextToken();
        Node subject = this.profile.createBlankNode(this.currentGraph, t.getLine(), t.getColumn());
        this.triplesBlankNode(subject);
        return subject;
    }

    protected final void triplesBlankNode(Node subject) {
        if (this.peekPredicate()) {
            this.predicateObjectList(subject);
        }
        this.expect("Triples not terminated properly in []-list", TokenType.RBRACKET);
    }

    protected final Node triplesFormula() {
        this.exception(this.peekToken(), "Not implemented (formulae, graph literals)", new Object[0]);
        return null;
    }

    protected final Node triplesList() {
        this.nextToken();
        Node lastCell = null;
        Node listHead = null;
        this.startList();
        do {
            Token errorToken = this.peekToken();
            if (this.eof()) {
                this.exception(this.peekToken(), "Unterminated list", new Object[0]);
            }
            if (this.lookingAt(TokenType.RPAREN)) {
                this.nextToken();
                break;
            }
            Node n = this.triplesNode();
            if (n == null) {
                this.exception(errorToken, "Malformed list", new Object[0]);
            }
            Node nextCell = NodeFactory.createBlankNode();
            if (listHead == null) {
                listHead = nextCell;
            }
            if (lastCell != null) {
                this.emitTriple(lastCell, NodeConst.nodeRest, nextCell);
            }
            lastCell = nextCell;
            this.emitTriple(nextCell, NodeConst.nodeFirst, n);
        } while (this.moreTokens());
        if (lastCell == null) {
            return NodeConst.nodeNil;
        }
        this.emitTriple(lastCell, NodeConst.nodeRest, NodeConst.nodeNil);
        this.finishList();
        return listHead;
    }

    protected void finishList() {
    }

    protected void startList() {
    }

    protected final void emitTriple(Node subject, Node predicate, Node object) {
        this.emit(subject, predicate, object);
    }

    private final void emitPrefix(String prefix, String iriStr) {
        this.dest.prefix(prefix, iriStr);
    }

    private final void emitBase(String baseStr) {
        this.dest.base(baseStr);
    }

    protected final Node tokenAsNode(Token token) {
        return this.profile.create(this.currentGraph, token);
    }
}

