/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpExtBuilder;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderOp;

public class OpExtRegistry {
    static Map<String, OpExtBuilder> extensions = new HashMap<String, OpExtBuilder>();

    public static void register(OpExtBuilder builder) {
        extensions.put(builder.getTagName(), builder);
        if (BuilderOp.contains(builder.getTagName())) {
            throw new ARQException("Tag '" + builder.getTagName() + "' already defined");
        }
        BuilderOp.add(builder.getTagName(), new BuildExt2());
    }

    public static void unregister(String subtag) {
        extensions.remove(subtag);
    }

    public static OpExtBuilder builder(String tag) {
        return extensions.get(tag);
    }

    public static Op buildExt(String tag, ItemList args) {
        OpExtBuilder b = OpExtRegistry.builder(tag);
        OpExt ext = b.make(args);
        return ext;
    }

    static {
        BuilderOp.add("ext", new BuildExtExt());
    }

    public static class BuildExt2
    implements BuilderOp.Build {
        @Override
        public Op make(ItemList list) {
            String subtag = list.get(0).getSymbol();
            list = list.sublist(1);
            return OpExtRegistry.buildExt(subtag, list);
        }
    }

    public static class BuildExtExt
    implements BuilderOp.Build {
        @Override
        public Op make(ItemList list) {
            String subtag = list.get(1).getSymbol();
            list = list.sublist(2);
            return OpExtRegistry.buildExt(subtag, list);
        }
    }
}

