/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.LabelExistsException;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphMap;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeUtils;

public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Transactional transactional = null;
    private Cache<Graph, Model> cache = this.createCache();
    private Object internalLock = new Object();

    protected DatasetImpl(DatasetGraph dsg) {
        this.dsg = dsg;
        if (dsg instanceof Transactional) {
            this.transactional = (Transactional)((Object)dsg);
        }
    }

    public static Dataset wrap(DatasetGraph datasetGraph) {
        DatasetImpl ds = new DatasetImpl(datasetGraph);
        return ds;
    }

    public static Dataset cloneStructure(DatasetGraph datasetGraph) {
        return new DatasetImpl(new DatasetGraphMap(datasetGraph));
    }

    public DatasetImpl(Model model) {
        this.addToCache(model);
        this.dsg = DatasetGraphFactory.create(model.getGraph());
    }

    public DatasetImpl(Dataset ds) {
        this.dsg = DatasetGraphFactory.create(ds.asDatasetGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getDefaultModel() {
        Object object = this.internalLock;
        synchronized (object) {
            return this.graph2model(this.dsg.getDefaultGraph());
        }
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public Context getContext() {
        return this.dsg.getContext();
    }

    @Override
    public boolean supportsTransactions() {
        return this.transactional != null;
    }

    @Override
    public void begin(ReadWrite mode) {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.begin(mode);
    }

    @Override
    public boolean isInTransaction() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        return this.transactional.isInTransaction();
    }

    @Override
    public void commit() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.commit();
    }

    @Override
    public void abort() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.abort();
    }

    @Override
    public void end() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.end();
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        Object object = this.internalLock;
        synchronized (object) {
            Graph g = this.dsg.getGraph(n);
            if (g == null) {
                return null;
            }
            return this.graph2model(g);
        }
    }

    @Override
    public void addNamedModel(String uri, Model model) throws LabelExistsException {
        DatasetImpl.checkGraphName(uri);
        this.addToCache(model);
        Node n = NodeFactory.createURI((String)uri);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void removeNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
    }

    @Override
    public void replaceNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
        this.addToCache(model);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void setDefaultModel(Model model) {
        if (model == null) {
            model = ModelFactory.createDefaultModel();
        }
        this.removeFromCache(this.dsg.getDefaultGraph());
        this.addToCache(model);
        this.dsg.setDefaultGraph(model.getGraph());
    }

    @Override
    public boolean containsNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        return this.dsg.containsGraph(n);
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    @Override
    public void close() {
        this.dsg.close();
        this.cache = null;
    }

    protected Cache<Graph, Model> createCache() {
        return CacheFactory.createCache((int)100);
    }

    protected void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove((Object)graph);
    }

    protected void addToCache(Model model) {
        this.cache.put((Object)model.getGraph(), (Object)model);
    }

    protected Model graph2model(final Graph graph) {
        Callable<Model> filler = new Callable<Model>(){

            @Override
            public Model call() {
                return ModelFactory.createModelForGraph((Graph)graph);
            }
        };
        return (Model)this.cache.getOrFill((Object)graph, (Callable)filler);
    }

    protected static void checkGraphName(String uri) {
        if (uri == null) {
            throw new ARQException("null for graph name");
        }
    }
}

