/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorExpr;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;

abstract class AggMinBase
extends AggregatorBase {
    protected AggMinBase(Expr expr, boolean isDistinct) {
        super("MIN", isDistinct, expr);
    }

    @Override
    public final Accumulator createAccumulator() {
        return new AccMin(this.getExpr());
    }

    @Override
    public final Node getValueEmpty() {
        return null;
    }

    private static class AccMin
    extends AccumulatorExpr {
        private NodeValue minSoFar = null;
        static final boolean DEBUG = false;

        public AccMin(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.minSoFar == null) {
                this.minSoFar = nv;
                return;
            }
            int x = NodeValue.compareAlways(this.minSoFar, nv);
            if (x > 0) {
                this.minSoFar = nv;
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.minSoFar;
        }
    }
}

