/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.CastXSD;
import org.apache.jena.sparql.function.Function;

public class CastXSD_Numeric
extends CastXSD {
    public CastXSD_Numeric(XSDDatatype dt) {
        super(dt);
    }

    @Override
    public Function create(String uri) {
        return new Instance(this.castType);
    }

    protected static class Instance
    extends CastXSD.Instance {
        Instance(XSDDatatype dt) {
            super(dt);
        }

        @Override
        protected NodeValue cast(String s, NodeValue nv, XSDDatatype castType) {
            if (nv.isBoolean()) {
                boolean b = nv.getBoolean();
                if (XSDDatatype.XSDfloat.equals(castType) || XSDDatatype.XSDdouble.equals(castType)) {
                    s = b ? "1.0E0" : "0.0E0";
                } else if (XSDDatatype.XSDdecimal.equals(castType)) {
                    s = b ? "1.0" : "0.0";
                } else if (XSDFuncOp.isIntegerType(castType)) {
                    s = b ? "1" : "0";
                }
            }
            return super.cast(s, nv, castType);
        }
    }
}

