/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Arrays;
import java.util.Properties;
import org.apache.jena.JenaRuntime;
import org.apache.jena.n3.turtle.TurtleReader;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.RDFReaderF;
import org.apache.jena.rdf.model.impl.NTripleReader;
import org.apache.jena.rdfxml.xmlinput.JenaReader;
import org.apache.jena.shared.ConfigException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoReaderForLangException;

public class RDFReaderFImpl
implements RDFReaderF {
    private static final String TURTLEREADER = TurtleReader.class.getName();
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF", "RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N-Triples", "N3", "TURTLE", "Turtle", "TTL", "CSV"};
    protected static final String[] DEFAULTREADERS = new String[]{JenaReader.class.getName(), JenaReader.class.getName(), JenaReader.class.getName(), NTripleReader.class.getName(), NTripleReader.class.getName(), NTripleReader.class.getName(), TURTLEREADER, TURTLEREADER, TURTLEREADER, TURTLEREADER, "org.apache.jena.riot.adapters.RDFReaderRIOT_CSV"};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "org.apache.jena.reader.";

    private static void reset() {
        Properties newLangToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            newLangToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTREADERS[i]));
        }
        langToClassName = newLangToClassName;
    }

    private static String remove(String lang) {
        if (Arrays.asList(LANGS).contains(lang)) {
            throw new IllegalArgumentException(lang + " is an initial language and may not be removed");
        }
        Object prev = langToClassName.remove(lang);
        return prev == null ? null : prev.toString();
    }

    @Override
    public RDFReader getReader() {
        return this.getReader(DEFAULTLANG);
    }

    @Override
    public RDFReader getReader(String lang) {
        String className;
        if (lang == null || lang.equals("")) {
            lang = LANGS[0];
        }
        if ((className = langToClassName.getProperty(lang)) == null || className.equals("")) {
            throw new NoReaderForLangException(lang);
        }
        try {
            return (RDFReader)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigException("Reader not found on classpath", e);
        }
        catch (Exception e) {
            throw new JenaException(e);
        }
    }

    @Override
    public String setReaderClassName(String lang, String className) {
        return RDFReaderFImpl.setBaseReaderClassName(lang, className);
    }

    public static String setBaseReaderClassName(String lang, String className) {
        String oldClassName = langToClassName.getProperty(lang);
        langToClassName.setProperty(lang, className);
        return oldClassName;
    }

    @Override
    public void resetRDFReaderF() {
        RDFReaderFImpl.reset();
    }

    @Override
    public String removeReader(String lang) throws IllegalArgumentException {
        return RDFReaderFImpl.remove(lang);
    }

    static {
        RDFReaderFImpl.reset();
    }
}

