/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Arrays;
import java.util.Properties;
import org.apache.jena.JenaRuntime;
import org.apache.jena.n3.N3JenaWriter;
import org.apache.jena.n3.N3JenaWriterPP;
import org.apache.jena.n3.N3JenaWriterTriples;
import org.apache.jena.n3.N3TurtleJenaWriter;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.rdf.model.RDFWriterF;
import org.apache.jena.rdf.model.impl.NTripleWriter;
import org.apache.jena.rdfxml.xmloutput.impl.Abbreviated;
import org.apache.jena.rdfxml.xmloutput.impl.Basic;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.NoWriterForLangException;

public class RDFWriterFImpl
implements RDFWriterF {
    protected static Properties langToClassName = null;
    protected static final String[] LANGS = new String[]{"RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "N-TRIPLES", "N-Triples", "N3", "N3-PP", "N3-PLAIN", "N3-TRIPLES", "N3-TRIPLE", "TURTLE", "Turtle", "TTL"};
    protected static final String[] DEFAULTWRITERS = new String[]{Basic.class.getName(), Abbreviated.class.getName(), NTripleWriter.class.getName(), NTripleWriter.class.getName(), NTripleWriter.class.getName(), N3JenaWriter.class.getName(), N3JenaWriterPP.class.getName(), N3TurtleJenaWriter.class.getName(), N3TurtleJenaWriter.class.getName(), N3JenaWriterTriples.class.getName(), N3TurtleJenaWriter.class.getName(), N3TurtleJenaWriter.class.getName(), N3TurtleJenaWriter.class.getName()};
    protected static final String DEFAULTLANG = LANGS[0];
    protected static final String PROPNAMEBASE = "org.apache.jena.writer.";

    private static void reset() {
        Properties newLangToClassName = new Properties();
        for (int i = 0; i < LANGS.length; ++i) {
            newLangToClassName.setProperty(LANGS[i], JenaRuntime.getSystemProperty(PROPNAMEBASE + LANGS[i], DEFAULTWRITERS[i]));
        }
        langToClassName = newLangToClassName;
    }

    private static String remove(String lang) throws IllegalArgumentException {
        if (Arrays.asList(LANGS).contains(lang)) {
            throw new IllegalArgumentException(lang + " is a required language set in initialization");
        }
        Object prev = langToClassName.remove(lang);
        return prev == null ? null : prev.toString();
    }

    @Override
    public RDFWriter getWriter() {
        return this.getWriter(DEFAULTLANG);
    }

    @Override
    public RDFWriter getWriter(String lang) {
        String className;
        if (lang == null || lang.equals("")) {
            lang = LANGS[0];
        }
        if ((className = langToClassName.getProperty(lang)) == null || className.equals("")) {
            throw new NoWriterForLangException(lang);
        }
        try {
            return (RDFWriter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (e instanceof JenaException) {
                throw (JenaException)e;
            }
            throw new JenaException(e);
        }
    }

    @Override
    public String setWriterClassName(String lang, String className) {
        return RDFWriterFImpl.setBaseWriterClassName(lang, className);
    }

    public static String setBaseWriterClassName(String lang, String className) {
        String oldClassName = langToClassName.getProperty(lang);
        langToClassName.setProperty(lang, className);
        return oldClassName;
    }

    @Override
    public void resetRDFWriterF() {
        RDFWriterFImpl.reset();
    }

    @Override
    public String removeWriter(String lang) throws IllegalArgumentException {
        return RDFWriterFImpl.remove(lang);
    }

    static {
        RDFWriterFImpl.reset();
    }
}

