/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_ANY;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class PrintUtil {
    protected static PrefixMapping prefixMapping = PrefixMapping.Factory.create();
    public static final String egNS = "urn:x-hp:eg/";

    public static void init() {
        PrintUtil.registerPrefix("rdf", RDF.getURI());
        PrintUtil.registerPrefix("rdfs", RDFS.getURI());
        PrintUtil.registerPrefix("drdfs", "urn:x-hp-direct-predicate:http_//www.w3.org/2000/01/rdf-schema#");
        PrintUtil.registerPrefix("owl", OWL.getURI());
        PrintUtil.registerPrefix("jr", ReasonerVocabulary.getJenaReasonerNS());
        PrintUtil.registerPrefix("rb", ReasonerVocabulary.getRBNamespace());
        PrintUtil.registerPrefix("eg", egNS);
        PrintUtil.registerPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    }

    public static void registerPrefix(String prefix, String namespace) {
        prefixMapping.setNsPrefix(prefix, namespace);
    }

    public static void registerPrefixMap(Map<String, String> map) {
        prefixMapping.setNsPrefixes(map);
    }

    public static void removePrefix(String prefix) {
        prefixMapping.removeNsPrefix(prefix);
    }

    public static void removePrefixMap(Map<String, String> map) {
        for (String s : map.keySet()) {
            prefixMapping.removeNsPrefix(s);
        }
    }

    public static String print(Node node) {
        if (node instanceof Node_URI) {
            return node.toString(prefixMapping);
        }
        if (node instanceof Node_Literal) {
            String lf = node.getLiteralLexicalForm();
            return "'" + lf + "'" + (Util.isSimpleString(node) ? "" : "^^" + node.getLiteralDatatypeURI());
        }
        if (node instanceof Node_ANY) {
            return "*";
        }
        if (node == null) {
            return "null";
        }
        return node.toString();
    }

    public static String print(RDFNode node) {
        if (node == null) {
            return "null";
        }
        return PrintUtil.print(node.asNode());
    }

    public static String print(Triple triple) {
        if (triple == null) {
            return "(null)";
        }
        return "(" + PrintUtil.print(triple.getSubject()) + " " + PrintUtil.print(triple.getPredicate()) + " " + PrintUtil.print(triple.getObject()) + ")";
    }

    public static String print(TriplePattern triple) {
        if (triple == null) {
            return "(null)";
        }
        return "(" + PrintUtil.print(triple.getSubject()) + " " + PrintUtil.print(triple.getPredicate()) + " " + PrintUtil.print(triple.getObject()) + ")";
    }

    public static String print(Statement stmt) {
        if (stmt == null) {
            return "(null)";
        }
        return PrintUtil.print(stmt.asTriple());
    }

    public static String print(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Triple) {
            return PrintUtil.print((Triple)obj);
        }
        if (obj instanceof TriplePattern) {
            return PrintUtil.print((TriplePattern)obj);
        }
        if (obj instanceof Node) {
            return PrintUtil.print((Node)obj);
        }
        if (obj instanceof RDFNode) {
            return PrintUtil.print((RDFNode)obj);
        }
        if (obj instanceof Statement) {
            return PrintUtil.print((Statement)obj);
        }
        return obj.toString();
    }

    public static String expandQname(String uri) {
        return prefixMapping.expandPrefix(uri);
    }

    public static void printIndent(PrintWriter out, int indent) {
        StringBuilder spaces = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            spaces.append(" ");
        }
        out.print(spaces.toString());
    }

    public static void printOut(Iterator<?> it) {
        while (it.hasNext()) {
            System.out.println("   " + PrintUtil.print(it.next()));
        }
    }

    static {
        PrintUtil.init();
    }
}

