/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared.uuid;

import java.util.Locale;
import java.util.Random;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.shared.uuid.JenaUUID;
import org.apache.jena.shared.uuid.LibUUID;
import org.apache.jena.shared.uuid.UUIDFactory;
import org.apache.jena.shared.uuid.UUID_V4;

public class UUID_V4_Gen
implements UUIDFactory {
    static final int versionHere = 4;
    static final int variantHere = 2;
    private Random random = null;

    @Override
    public JenaUUID generate() {
        return this.generateV4();
    }

    public UUID_V4 generateV4() {
        this.init();
        long mostSigBits = this.random.nextLong();
        long leastSigBits = this.random.nextLong();
        mostSigBits = BitsLong.pack((long)mostSigBits, (long)4L, (int)12, (int)16);
        leastSigBits = BitsLong.pack((long)leastSigBits, (long)2L, (int)62, (int)64);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    @Override
    public JenaUUID parse(String s) {
        return this.parseV4(s);
    }

    public UUID_V4 parseV4(String s) {
        if ((s = s.toLowerCase(Locale.ENGLISH)).length() != 36) {
            throw new JenaUUID.UUIDFormatException("UUID string is not 36 chars long: it's " + s.length() + " [" + s + "]");
        }
        if (s.charAt(8) != '-' && s.charAt(13) != '-' && s.charAt(18) != '-' && s.charAt(23) != '-') {
            throw new JenaUUID.UUIDFormatException("String does not have dashes in the right places: " + s);
        }
        UUID_V4 u = UUID_V4_Gen.parse$(s);
        if (u.getVersion() != 4) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 4Got: " + u.getVersion() + "): " + s);
        }
        if (u.getVariant() != 2) {
            throw new JenaUUID.UUIDFormatException("Wrong version (Expected: 2Got: " + u.getVariant() + "): " + s);
        }
        return u;
    }

    static UUID_V4 parse$(String s) {
        long mostSigBits = BitsLong.unpack((String)s, (int)0, (int)8);
        mostSigBits = mostSigBits << 16 | BitsLong.unpack((String)s, (int)9, (int)13);
        mostSigBits = mostSigBits << 16 | BitsLong.unpack((String)s, (int)14, (int)18);
        long leastSigBits = BitsLong.unpack((String)s, (int)19, (int)23);
        leastSigBits = leastSigBits << 48 | BitsLong.unpack((String)s, (int)24, (int)36);
        return new UUID_V4(mostSigBits, leastSigBits);
    }

    private void init() {
        if (this.random == null) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.random = LibUUID.makeRandom();
    }
}

