/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.com.google.common.base;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.ext.com.google.common.annotations.GwtCompatible;
import org.apache.jena.ext.com.google.common.annotations.VisibleForTesting;
import org.apache.jena.ext.com.google.common.base.Platform;
import org.apache.jena.ext.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string) {
        return Platform.nullToEmpty(string);
    }

    public static @Nullable String emptyToNull(@Nullable String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string, int count) {
        int n;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a, CharSequence b) {
        int p;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxPrefixLength = Math.min(a.length(), b.length());
        for (p = 0; p < maxPrefixLength && a.charAt(p) == b.charAt(p); ++p) {
        }
        if (Strings.validSurrogatePairAt(a, p - 1) || Strings.validSurrogatePairAt(b, p - 1)) {
            --p;
        }
        return a.subSequence(0, p).toString();
    }

    public static String commonSuffix(CharSequence a, CharSequence b) {
        int s;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        int maxSuffixLength = Math.min(a.length(), b.length());
        for (s = 0; s < maxSuffixLength && a.charAt(a.length() - s - 1) == b.charAt(b.length() - s - 1); ++s) {
        }
        if (Strings.validSurrogatePairAt(a, a.length() - s - 1) || Strings.validSurrogatePairAt(b, b.length() - s - 1)) {
            --s;
        }
        return a.subSequence(a.length() - s, a.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    public static String lenientFormat(@Nullable String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args == null) {
            args = new Object[]{"(Object[])null"};
        } else {
            for (int i = 0; i < args.length; ++i) {
                args[i] = Strings.lenientToString(args[i]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@Nullable Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Exception e) {
            String string = o.getClass().getName();
            String string2 = Integer.toHexString(System.identityHashCode(o));
            String objectToString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('@').append(string2).toString();
            String string3 = String.valueOf(objectToString);
            Logger.getLogger("org.apache.jena.ext.com.google.common.base.Strings").log(Level.WARNING, string3.length() != 0 ? "Exception during lenientFormat for ".concat(string3) : new String("Exception during lenientFormat for "), e);
            string = e.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string).length()).append("<").append(objectToString).append(" threw ").append(string).append(">").toString();
        }
    }
}

