/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.sys.SystemTDB;
import org.apache.jena.tdb.transaction.DatasetBuilderTxn;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.Journal;
import org.apache.jena.tdb.transaction.JournalControl;
import org.apache.jena.tdb.transaction.SysTxnState;
import org.apache.jena.tdb.transaction.TDBTransactionException;
import org.apache.jena.tdb.transaction.Transaction;
import org.apache.jena.tdb.transaction.TransactionLifecycle;
import org.apache.jena.tdb.transaction.TxnState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager {
    private static boolean checking = true;
    private static Logger log = LoggerFactory.getLogger(TransactionManager.class);
    private Set<Transaction> currentActiveTransactions = ConcurrentHashMap.newKeySet();
    private boolean recordHistory = false;
    public static int QueueBatchSize = TransactionManager.setQueueBatchSize();
    public static int JournalThresholdSize = -1;
    public static int MaxQueueThreshold = 100;
    private List<Pair<Transaction, TxnPoint>> transactionStateTransition;
    int maxQueue = 0;
    List<Transaction> commitedAwaitingFlush = new ArrayList<Transaction>();
    static AtomicLong transactionId = new AtomicLong(1L);
    private List<TransactionLifecycle> additionalComponents = new ArrayList<TransactionLifecycle>();
    private AtomicLong version = new AtomicLong(0L);
    private AtomicLong activeTransactions = new AtomicLong(0L);
    AtomicLong activeReaders = new AtomicLong(0L);
    AtomicLong activeWriters = new AtomicLong(0L);
    AtomicLong finishedReaders = new AtomicLong(0L);
    AtomicLong committedWriters = new AtomicLong(0L);
    AtomicLong abortedWriters = new AtomicLong(0L);
    private AtomicReference<DatasetGraphTDB> currentReaderView = new AtomicReference<Object>(null);
    private Semaphore writerPermits = new Semaphore(1, true);
    private ReadWriteLock exclusivitylock = new ReentrantReadWriteLock(true);
    private BlockingQueue<Transaction> queue = new LinkedBlockingDeque<Transaction>();
    private DatasetGraphTDB baseDataset;
    private Journal journal;
    private TSM[] actions = new TSM[]{new TSM_Counters(), new TSM_Logger(), this.recordHistory ? new TSM_Record() : null, new TSM_WriteBackEndTxn()};
    public static final boolean DEBUG = false;
    private final boolean logstate = SystemTDB.syslog.isDebugEnabled() || log.isDebugEnabled();

    private static int setQueueBatchSize() {
        if (SystemTDB.is64bitSystem) {
            return 10;
        }
        return 0;
    }

    private void record(Transaction txn, TxnPoint state) {
        if (!this.recordHistory) {
            return;
        }
        this.initRecordingState();
        this.transactionStateTransition.add((Pair<Transaction, TxnPoint>)new Pair((Object)txn, (Object)state));
    }

    public boolean activeTransactions() {
        return this.activeTransactions.get() != 0L;
    }

    public long getCountActiveReaders() {
        return this.activeReaders.get();
    }

    public long getCountActiveWriters() {
        return this.activeWriters.get();
    }

    public long getQueueLength() {
        return this.queue.size();
    }

    static long inc(AtomicLong x) {
        return x.getAndIncrement();
    }

    static long dec(AtomicLong x) {
        return x.decrementAndGet();
    }

    public TransactionManager(DatasetGraphTDB dsg) {
        this.baseDataset = dsg;
        this.journal = Journal.create(dsg.getLocation());
    }

    public synchronized void closedown() {
        this.processDelayedReplayQueue(null);
        this.journal.close();
    }

    public void addAdditionComponent(TransactionLifecycle txnLifecycle) {
        this.additionalComponents.add(txnLifecycle);
    }

    public DatasetGraphTxn begin(TxnType txnType, String label) {
        return this.beginInternal(txnType, txnType, label);
    }

    private DatasetGraphTxn beginInternal(TxnType txnType, TxnType originalTxnType, String label) {
        this.startNonExclusive();
        if (txnType == TxnType.WRITE) {
            this.acquireWriterLock(true);
        }
        DatasetGraphTxn dsgtxn = this.begin$(txnType, originalTxnType, label);
        this.noteTxnStart(dsgtxn.getTransaction());
        return dsgtxn;
    }

    DatasetGraphTxn promote(DatasetGraphTxn dsgtxn, TxnType originalTxnType, Transactional.Promote promoteType) throws TDBTransactionException {
        Transaction txn = dsgtxn.getTransaction();
        if (txn.getState() != TxnState.ACTIVE) {
            throw new TDBTransactionException("promote: transaction is not active");
        }
        if (txn.getTxnMode() == ReadWrite.WRITE) {
            return dsgtxn;
        }
        if (txn.getTxnType() == TxnType.READ) {
            return null;
        }
        if (promoteType == Transactional.Promote.READ_COMMITTED) {
            this.acquireWriterLock(true);
            return this.promoteExec$(dsgtxn, originalTxnType);
        }
        if (txn.getVersion() != this.version.get()) {
            return null;
        }
        this.acquireWriterLock(true);
        return this.promoteSync$(dsgtxn, originalTxnType);
    }

    private synchronized DatasetGraphTxn promoteSync$(DatasetGraphTxn dsgtxn, TxnType originalTxnType) {
        Transaction txn = dsgtxn.getTransaction();
        if (txn.getVersion() != this.version.get()) {
            this.releaseWriterLock();
            return null;
        }
        return this.promoteExec$(dsgtxn, originalTxnType);
    }

    private DatasetGraphTxn promoteExec$(DatasetGraphTxn dsgtxn, TxnType originalTxnType) {
        Transaction txn = dsgtxn.getTransaction();
        DatasetGraphTxn dsgtxn2 = this.begin$(TxnType.WRITE, originalTxnType, txn.getLabel());
        this.noteTxnPromote(txn, dsgtxn2.getTransaction());
        return dsgtxn2;
    }

    private synchronized DatasetGraphTxn begin$(TxnType txnType, TxnType originalTxnType, String label) {
        Objects.requireNonNull(txnType);
        if (txnType == TxnType.WRITE && this.activeWriters.get() > 0L) {
            throw new TDBTransactionException("Existing active write transaction");
        }
        DatasetGraphTDB dsg = this.determineBaseDataset();
        Transaction txn = this.createTransaction(dsg, txnType, originalTxnType, label);
        this.log("begin$", txn);
        ReadWrite mode = TransactionManager.initialMode(txnType);
        DatasetGraphTxn dsgTxn = this.createDSGTxn(dsg, txn, mode);
        txn.setActiveDataset(dsgTxn);
        dsgTxn.getTransaction().forAllComponents(component -> component.begin(dsgTxn.getTransaction()));
        return dsgTxn;
    }

    private DatasetGraphTDB determineBaseDataset() {
        DatasetGraphTDB dsg = this.baseDataset;
        if (!this.commitedAwaitingFlush.isEmpty()) {
            dsg = this.commitedAwaitingFlush.get(this.commitedAwaitingFlush.size() - 1).getActiveDataset().getView();
        }
        return dsg;
    }

    private Transaction createTransaction(DatasetGraphTDB dsg, TxnType txnType, TxnType originalTxnType, String label) {
        if (originalTxnType == null) {
            originalTxnType = txnType;
        }
        Transaction txn = new Transaction(dsg, this.version.get(), txnType, TransactionManager.initialMode(txnType), transactionId.getAndIncrement(), originalTxnType, label, this);
        this.additionalComponents.forEach(txn::addAdditionaComponent);
        return txn;
    }

    private static ReadWrite initialMode(TxnType txnType) {
        return TxnType.initial((TxnType)txnType);
    }

    private DatasetGraphTxn createDSGTxn(DatasetGraphTDB dsg, Transaction txn, ReadWrite mode) {
        DatasetGraphTDB dsgCached;
        if (mode == ReadWrite.READ && (dsgCached = this.currentReaderView.get()) != null) {
            return new DatasetGraphTxn(dsgCached, txn);
        }
        DatasetGraphTxn dsgTxn = new DatasetBuilderTxn(this, dsg).build(txn, mode);
        if (mode == ReadWrite.READ) {
            this.currentReaderView.set(dsgTxn.getView());
        }
        return dsgTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCommit(Transaction transaction) {
        boolean excessiveQueue = false;
        TransactionManager transactionManager = this;
        synchronized (transactionManager) {
            if (!this.currentActiveTransactions.contains(transaction)) {
                SystemTDB.errlog.warn("Transaction not active: " + transaction.getTxnId());
            }
            this.noteTxnCommit(transaction);
            switch (transaction.getTxnMode()) {
                case READ: {
                    break;
                }
                case WRITE: {
                    this.version.incrementAndGet();
                    this.currentReaderView.set(null);
                    excessiveQueue = MaxQueueThreshold >= 0 && this.queue.size() > MaxQueueThreshold;
                    this.releaseWriterLock();
                }
            }
            this.finishNonExclusive();
        }
        if (excessiveQueue) {
            this.exclusiveFlushQueue();
        }
    }

    synchronized void notifyAbort(Transaction transaction) {
        if (!this.currentActiveTransactions.contains(transaction)) {
            SystemTDB.errlog.warn("Transaction not active: " + transaction.getTxnId());
        }
        this.noteTxnAbort(transaction);
        switch (transaction.getTxnMode()) {
            case READ: {
                break;
            }
            case WRITE: {
                this.releaseWriterLock();
            }
        }
        this.finishNonExclusive();
    }

    synchronized void notifyClose(Transaction txn) {
        if (txn.getState() == TxnState.ACTIVE) {
            String x = txn.getBaseDataset().getLocation().getDirectoryPath();
            SystemTDB.syslog.warn("close: Transaction not commited or aborted: Transaction: " + txn.getTxnId() + " @ " + x);
            txn.abort();
            txn.close();
            return;
        }
        this.noteTxnClose(txn);
    }

    private void releaseWriterLock() {
        int x = this.writerPermits.availablePermits();
        if (x != 0) {
            throw new TDBTransactionException("TransactionCoordinator: Probably mismatch of enableWriters/blockWriters calls");
        }
        this.writerPermits.release();
    }

    private boolean acquireWriterLock(boolean canBlock) {
        if (!canBlock) {
            return this.writerPermits.tryAcquire();
        }
        try {
            this.writerPermits.acquire();
            return true;
        }
        catch (InterruptedException e) {
            throw new TDBTransactionException(e);
        }
    }

    public void blockWriters() {
        this.acquireWriterLock(true);
    }

    public boolean tryBlockWriters() {
        return this.acquireWriterLock(false);
    }

    public void enableWriters() {
        this.releaseWriterLock();
    }

    private void exclusiveFlushQueue() {
        this.startExclusiveMode(true);
        this.finishExclusiveMode();
    }

    private void startNonExclusive() {
        this.exclusivitylock.readLock().lock();
    }

    private void finishNonExclusive() {
        this.exclusivitylock.readLock().unlock();
    }

    public void startExclusiveMode() {
        this.startExclusiveMode(true);
    }

    public boolean tryExclusiveMode() {
        return this.startExclusiveMode(false);
    }

    private boolean startExclusiveMode(boolean canBlock) {
        if (canBlock) {
            this.exclusivitylock.writeLock().lock();
            this.processDelayedReplayQueue(null);
            return true;
        }
        boolean b = this.exclusivitylock.writeLock().tryLock();
        if (!b) {
            return false;
        }
        this.processDelayedReplayQueue(null);
        return true;
    }

    public ReadWriteLock getExclusivityLock$() {
        return this.exclusivitylock;
    }

    public void finishExclusiveMode() {
        this.exclusivitylock.writeLock().unlock();
    }

    private void enactTransaction(Transaction transaction) {
        transaction.forAllComponents(x -> x.enactCommitted(transaction));
        transaction.forAllComponents(x -> x.clearupCommitted(transaction));
        transaction.signalEnacted();
    }

    public synchronized void flush() {
        this.processDelayedReplayQueue(null);
    }

    private void readerFinishesWorker(Transaction txn) {
        if (this.checkForJournalFlush()) {
            this.processDelayedReplayQueue(txn);
        }
    }

    private void writerAbortsWorker(Transaction txn) {
        if (this.checkForJournalFlush()) {
            this.processDelayedReplayQueue(txn);
        }
    }

    private boolean checkForJournalFlush() {
        boolean journalSizeFlush;
        if (this.queue.size() >= QueueBatchSize) {
            return true;
        }
        boolean bl = journalSizeFlush = JournalThresholdSize > 0 && this.journal.size() > (long)JournalThresholdSize;
        return journalSizeFlush;
    }

    private void writerCommitsWorker(Transaction txn) {
        if (this.activeReaders.get() == 0L && this.checkForJournalFlush()) {
            if (this.log()) {
                this.log("Commit immediately", txn);
            }
            this.processDelayedReplayQueue(txn);
            this.enactTransaction(txn);
            JournalControl.replay(txn);
        } else {
            this.commitedAwaitingFlush.add(txn);
            this.maxQueue = Math.max(this.commitedAwaitingFlush.size(), this.maxQueue);
            if (this.log()) {
                this.log("Add to pending queue", txn);
            }
            this.queue.add(txn);
        }
    }

    private void processDelayedReplayQueue(Transaction txn) {
        if (this.activeReaders.get() != 0L || this.activeWriters.get() != 0L) {
            if (this.queue.size() > 0 && this.log()) {
                this.log(String.format("Pending transactions: R=%s / W=%s", this.activeReaders, this.activeWriters), txn);
            }
            return;
        }
        if (this.queue.size() == 0 && txn != null) {
            return;
        }
        if (this.log()) {
            this.log("Start flush delayed commits", txn);
        }
        this.currentReaderView.set(null);
        while (this.queue.size() > 0) {
            try {
                Transaction txn2 = this.queue.take();
                if (txn2.getTxnMode() == ReadWrite.READ) continue;
                if (this.log()) {
                    this.log("  Flush delayed commit of " + txn2.getLabel(), txn);
                }
                this.checkReplaySafe();
                this.enactTransaction(txn2);
                this.commitedAwaitingFlush.remove(txn2);
            }
            catch (InterruptedException ex) {
                Log.error((Object)this, (String)"Interruped!", (Throwable)ex);
            }
        }
        this.checkReplaySafe();
        JournalControl.replay(this.journal, this.baseDataset);
        this.checkReplaySafe();
        if (this.log()) {
            this.log("End flush delayed commits", txn);
        }
    }

    private void checkNodesDatJrnl(String label, Transaction txn) {
        String x;
        long len;
        if (txn != null && (len = new File(x = txn.getBaseDataset().getLocation().getPath(label + ": nodes.dat-jrnl")).length()) != 0L) {
            this.log("nodes.dat-jrnl: not empty", txn);
        }
    }

    private void checkReplaySafe() {
        if (!checking) {
            return;
        }
        long x = this.activeTransactions.get();
        if (x == 0L) {
            return;
        }
        long r = this.activeReaders.get();
        long w = this.activeWriters.get();
        FmtLog.error((Logger)log, (String)"checkReplaySafe: There are currently active transactions. C=%d (R=%d, W=%d)", (Object[])new Object[]{x, r, w});
    }

    private void noteTxnStart(Transaction transaction) {
        switch (transaction.getTxnMode()) {
            case READ: {
                this.readerStarts(transaction);
                break;
            }
            case WRITE: {
                this.writerStarts(transaction);
            }
        }
        this.transactionStarts(transaction);
    }

    private void noteTxnPromote(Transaction transaction, Transaction transaction2) {
        this.transactionPromotes(transaction, transaction2);
    }

    private void noteTxnCommit(Transaction transaction) {
        switch (transaction.getTxnMode()) {
            case READ: {
                this.readerFinishes(transaction);
                break;
            }
            case WRITE: {
                this.writerCommits(transaction);
            }
        }
        this.transactionFinishes(transaction);
    }

    private void noteTxnAbort(Transaction transaction) {
        switch (transaction.getTxnMode()) {
            case READ: {
                this.readerFinishes(transaction);
                break;
            }
            case WRITE: {
                this.writerAborts(transaction);
            }
        }
        this.transactionFinishes(transaction);
    }

    private void noteTxnClose(Transaction transaction) {
        this.transactionCloses(transaction);
    }

    public boolean recording() {
        return this.recordHistory;
    }

    public void recording(boolean flag) {
        this.recordHistory = flag;
        if (this.recordHistory) {
            this.initRecordingState();
        }
    }

    public void clearRecordingState() {
        this.initRecordingState();
        this.transactionStateTransition.clear();
    }

    private void initRecordingState() {
        if (this.transactionStateTransition == null) {
            this.transactionStateTransition = new ArrayList<Pair<Transaction, TxnPoint>>();
        }
    }

    public Journal getJournal() {
        return this.journal;
    }

    private boolean log() {
        return this.logstate;
    }

    private void log(String msg, Transaction txn) {
        if (!this.log()) {
            return;
        }
        if (txn == null) {
            TransactionManager.logger().debug("<No txn>: " + msg);
        } else {
            TransactionManager.logger().debug(txn.getLabel() + ": " + msg);
        }
    }

    private void logInternal(String action, Transaction txn) {
        if (!this.log()) {
            return;
        }
        String txnStr = txn == null ? "<null>" : txn.getLabel();
        TransactionManager.logger().debug(String.format("%6s %s -- %s", action, txnStr, this.state()));
    }

    private static Logger logger() {
        if (SystemTDB.syslog.isDebugEnabled()) {
            return SystemTDB.syslog;
        }
        return log;
    }

    public synchronized SysTxnState state() {
        return new SysTxnState(this);
    }

    private void transactionStarts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionStarts(txn);
        }
    }

    private void transactionFinishes(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionFinishes(txn);
        }
    }

    private void transactionCloses(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionCloses(txn);
        }
    }

    private void readerStarts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.readerStarts(txn);
        }
    }

    private void readerFinishes(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.readerFinishes(txn);
        }
    }

    private void transactionPromotes(Transaction txnOld, Transaction txnNew) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.transactionPromotes(txnOld, txnNew);
        }
    }

    private void writerStarts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.writerStarts(txn);
        }
    }

    private void writerCommits(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.writerCommits(txn);
        }
    }

    private void writerAborts(Transaction txn) {
        for (TSM tsm : this.actions) {
            if (tsm == null) continue;
            tsm.writerAborts(txn);
        }
    }

    class Committer
    implements Runnable {
        Committer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Transaction txn = (Transaction)TransactionManager.this.queue.take();
                        JournalControl.replay(txn);
                        TransactionManager transactionManager = TransactionManager.this;
                        synchronized (transactionManager) {
                            TransactionManager.this.commitedAwaitingFlush.remove(txn);
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Log.error((Object)this, (String)"Interruped!", (Throwable)ex);
                    continue;
                }
                break;
            }
        }
    }

    class TSM_Record
    extends TSM_Base {
        TSM_Record() {
        }

        @Override
        public void transactionStarts(Transaction txn) {
            TransactionManager.this.record(txn, TxnPoint.BEGIN);
        }

        @Override
        public void transactionFinishes(Transaction txn) {
            TransactionManager.this.record(txn, TxnPoint.CLOSE);
        }
    }

    class TSM_MRSW_Writer
    extends TSM_Base {
        TSM_MRSW_Writer() {
        }
    }

    class TSM_WriterWriteBack
    extends TSM_Base {
        TSM_WriterWriteBack() {
        }
    }

    class TSM_WriteBackEndTxn
    extends TSM_Base {
        TSM_WriteBackEndTxn() {
        }

        @Override
        public void readerStarts(Transaction txn) {
            txn.getBaseDataset().getLock().enterCriticalSection(true);
        }

        @Override
        public void writerStarts(Transaction txn) {
            txn.getBaseDataset().getLock().enterCriticalSection(true);
        }

        @Override
        public void transactionPromotes(Transaction txnOld, Transaction txnNew) {
            txnOld.getBaseDataset().getLock().leaveCriticalSection();
            txnNew.getBaseDataset().getLock().enterCriticalSection(true);
        }

        @Override
        public void readerFinishes(Transaction txn) {
            txn.getBaseDataset().getLock().leaveCriticalSection();
            TransactionManager.this.readerFinishesWorker(txn);
        }

        @Override
        public void writerCommits(Transaction txn) {
            txn.getBaseDataset().getLock().leaveCriticalSection();
            TransactionManager.this.writerCommitsWorker(txn);
        }

        @Override
        public void writerAborts(Transaction txn) {
            txn.getBaseDataset().getLock().leaveCriticalSection();
            TransactionManager.this.writerAbortsWorker(txn);
        }
    }

    class TSM_Counters
    implements TSM {
        TSM_Counters() {
        }

        @Override
        public void transactionStarts(Transaction txn) {
            TransactionManager.this.currentActiveTransactions.add(txn);
        }

        @Override
        public void transactionFinishes(Transaction txn) {
            TransactionManager.this.currentActiveTransactions.remove(txn);
        }

        @Override
        public void transactionCloses(Transaction txn) {
        }

        @Override
        public void readerStarts(Transaction txn) {
            TransactionManager.inc(TransactionManager.this.activeTransactions);
            TransactionManager.inc(TransactionManager.this.activeReaders);
        }

        @Override
        public void readerFinishes(Transaction txn) {
            TransactionManager.dec(TransactionManager.this.activeReaders);
            TransactionManager.inc(TransactionManager.this.finishedReaders);
            TransactionManager.dec(TransactionManager.this.activeTransactions);
        }

        @Override
        public void transactionPromotes(Transaction txnOld, Transaction txnNew) {
            TransactionManager.this.currentActiveTransactions.add(txnNew);
            TransactionManager.this.currentActiveTransactions.remove(txnOld);
            TransactionManager.dec(TransactionManager.this.activeReaders);
            TransactionManager.inc(TransactionManager.this.finishedReaders);
            TransactionManager.inc(TransactionManager.this.activeWriters);
        }

        @Override
        public void writerStarts(Transaction txn) {
            TransactionManager.inc(TransactionManager.this.activeTransactions);
            TransactionManager.inc(TransactionManager.this.activeWriters);
        }

        @Override
        public void writerCommits(Transaction txn) {
            TransactionManager.dec(TransactionManager.this.activeWriters);
            TransactionManager.inc(TransactionManager.this.committedWriters);
            TransactionManager.dec(TransactionManager.this.activeTransactions);
        }

        @Override
        public void writerAborts(Transaction txn) {
            TransactionManager.dec(TransactionManager.this.activeWriters);
            TransactionManager.inc(TransactionManager.this.abortedWriters);
            TransactionManager.dec(TransactionManager.this.activeTransactions);
        }
    }

    class TSM_LoggerDebug
    extends TSM_Base {
        TSM_LoggerDebug() {
        }

        @Override
        public void readerStarts(Transaction txn) {
            TransactionManager.this.logInternal("start", txn);
        }

        @Override
        public void readerFinishes(Transaction txn) {
            TransactionManager.this.logInternal("finish", txn);
        }

        @Override
        public void transactionPromotes(Transaction txnOld, Transaction txnNew) {
            TransactionManager.this.logInternal("promote(old)", txnOld);
            TransactionManager.this.logInternal("promote(new)", txnNew);
        }

        @Override
        public void writerStarts(Transaction txn) {
            TransactionManager.this.logInternal("begin", txn);
        }

        @Override
        public void writerCommits(Transaction txn) {
            TransactionManager.this.logInternal("commit", txn);
        }

        @Override
        public void writerAborts(Transaction txn) {
            TransactionManager.this.logInternal("abort", txn);
        }
    }

    class TSM_Logger
    extends TSM_Base {
        TSM_Logger() {
        }

        @Override
        public void readerStarts(Transaction txn) {
            TransactionManager.this.log("start", txn);
        }

        @Override
        public void readerFinishes(Transaction txn) {
            TransactionManager.this.log("finish", txn);
        }

        @Override
        public void transactionPromotes(Transaction txnOld, Transaction txnNew) {
            TransactionManager.this.log("promote(old)", txnOld);
            TransactionManager.this.log("promote(new)", txnNew);
        }

        @Override
        public void writerStarts(Transaction txn) {
            TransactionManager.this.log("begin", txn);
        }

        @Override
        public void writerCommits(Transaction txn) {
            TransactionManager.this.log("commit", txn);
        }

        @Override
        public void writerAborts(Transaction txn) {
            TransactionManager.this.log("abort", txn);
        }
    }

    class TSM_Base
    implements TSM {
        TSM_Base() {
        }

        @Override
        public void transactionStarts(Transaction txn) {
        }

        @Override
        public void transactionFinishes(Transaction txn) {
        }

        @Override
        public void transactionCloses(Transaction txn) {
        }

        @Override
        public void readerStarts(Transaction txn) {
        }

        @Override
        public void readerFinishes(Transaction txn) {
        }

        @Override
        public void transactionPromotes(Transaction txnOld, Transaction txnNew) {
        }

        @Override
        public void writerStarts(Transaction txn) {
        }

        @Override
        public void writerCommits(Transaction txn) {
        }

        @Override
        public void writerAborts(Transaction txn) {
        }
    }

    private static interface TSM {
        public void transactionStarts(Transaction var1);

        public void transactionFinishes(Transaction var1);

        public void transactionCloses(Transaction var1);

        public void readerStarts(Transaction var1);

        public void readerFinishes(Transaction var1);

        public void transactionPromotes(Transaction var1, Transaction var2);

        public void writerStarts(Transaction var1);

        public void writerCommits(Transaction var1);

        public void writerAborts(Transaction var1);
    }

    static enum TxnPoint {
        BEGIN,
        COMMIT,
        ABORT,
        CLOSE,
        QUEUE,
        UNQUEUE;

    }
}

