/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ViewResultsFullVisualizer
extends AbstractVisualizer
implements ActionListener,
TreeSelectionListener,
Clearable,
ItemListener {
    private static final long serialVersionUID = 7338676747296593842L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final Color SERVER_ERROR_COLOR = Color.red;
    public static final Color CLIENT_ERROR_COLOR = Color.blue;
    public static final Color REDIRECT_COLOR = Color.green;
    private JSplitPane mainSplit;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private JTree jTree;
    private Component leftSide;
    private JTabbedPane rightSide;
    private JComboBox selectRenderPanel;
    private int selectedTab;
    protected static final String COMBO_CHANGE_COMMAND = "change_combo";
    private static final ImageIcon imageSuccess = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.success", (String)"icon_success_sml.gif"));
    private static final ImageIcon imageFailure = JMeterUtils.getImage((String)JMeterUtils.getPropDefault((String)"viewResultsTree.failure", (String)"icon_warning_sml.gif"));
    private static final int MAX_DISPLAY_SIZE = JMeterUtils.getPropDefault((String)"view.results.tree.max_size", (int)204800);
    private ResultRenderer resultsRender = null;
    private TreeSelectionEvent lastSelectionEvent;
    private JCheckBox autoScrollCB;

    public ViewResultsFullVisualizer() {
        this.init();
    }

    public void add(SampleResult sample) {
        this.updateGui(sample);
    }

    private synchronized void updateGui(SampleResult res) {
        DefaultMutableTreeNode currNode = new DefaultMutableTreeNode(res);
        this.treeModel.insertNodeInto(currNode, this.root, this.root.getChildCount());
        this.addSubResults(currNode, res);
        AssertionResult[] assertionResults = res.getAssertionResults();
        int assertionIndex = currNode.getChildCount();
        for (int j = 0; j < assertionResults.length; ++j) {
            AssertionResult item = assertionResults[j];
            if (!item.isFailure() && !item.isError()) continue;
            DefaultMutableTreeNode assertionNode = new DefaultMutableTreeNode(item);
            this.treeModel.insertNodeInto(assertionNode, currNode, assertionIndex++);
        }
        if (this.root.getChildCount() == 1) {
            this.jTree.expandPath(new TreePath(this.root));
        }
        if (this.autoScrollCB.isSelected() && this.root.getChildCount() > 1) {
            this.jTree.scrollPathToVisible(new TreePath(new Object[]{this.root, this.treeModel.getChild(this.root, this.root.getChildCount() - 1)}));
        }
    }

    private void addSubResults(DefaultMutableTreeNode currNode, SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        int leafIndex = 0;
        for (int i = 0; i < subResults.length; ++i) {
            SampleResult child = subResults[i];
            if (log.isDebugEnabled()) {
                log.debug("updateGui1 : child sample result - " + child);
            }
            DefaultMutableTreeNode leafNode = new DefaultMutableTreeNode(child);
            this.treeModel.insertNodeInto(leafNode, currNode, leafIndex++);
            this.addSubResults(leafNode, child);
            AssertionResult[] assertionResults = child.getAssertionResults();
            int assertionIndex = leafNode.getChildCount();
            for (int j = 0; j < assertionResults.length; ++j) {
                AssertionResult item = assertionResults[j];
                if (!item.isFailure() && !item.isError()) continue;
                DefaultMutableTreeNode assertionNode = new DefaultMutableTreeNode(item);
                this.treeModel.insertNodeInto(assertionNode, leafNode, assertionIndex++);
            }
        }
    }

    public synchronized void clearData() {
        while (this.root.getChildCount() > 0) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)this.root.getChildAt(0));
        }
        this.resultsRender.clearData();
    }

    public String getLabelResource() {
        return "view_results_tree_title";
    }

    protected void init() {
        log.debug("init() - pass");
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.leftSide = this.createLeftPanel();
        this.rightSide = new JTabbedPane();
        this.mainSplit = new JSplitPane(1, this.leftSide, this.rightSide);
        this.add(this.mainSplit, "Center");
        this.resultsRender.setRightSide(this.rightSide);
        this.resultsRender.init();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.lastSelectionEvent = e;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        if (node != null) {
            if (this.rightSide.getTabCount() > this.selectedTab) {
                this.resultsRender.setLastSelectedTab(this.rightSide.getSelectedIndex());
            }
            Object userObject = node.getUserObject();
            this.resultsRender.setSamplerResult(userObject);
            this.resultsRender.setupTabPane();
            if (userObject instanceof SampleResult) {
                SampleResult sampleResult = (SampleResult)userObject;
                if ("text".equals(sampleResult.getDataType())) {
                    this.resultsRender.renderResult(sampleResult);
                } else {
                    byte[] responseBytes = sampleResult.getResponseData();
                    if (responseBytes != null) {
                        this.resultsRender.renderImage(sampleResult);
                    }
                }
            }
        }
    }

    private synchronized Component createLeftPanel() {
        SampleResult rootSampleResult = new SampleResult();
        rootSampleResult.setSampleLabel("Root");
        rootSampleResult.setSuccessful(true);
        this.root = new DefaultMutableTreeNode(rootSampleResult);
        this.treeModel = new DefaultTreeModel(this.root);
        this.jTree = new JTree(this.treeModel);
        this.jTree.setCellRenderer(new ResultsNodeRenderer());
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addTreeSelectionListener(this);
        this.jTree.setRootVisible(false);
        this.jTree.setShowsRootHandles(true);
        JScrollPane treePane = new JScrollPane(this.jTree);
        treePane.setPreferredSize(new Dimension(200, 300));
        VerticalPanel leftPane = new VerticalPanel();
        leftPane.add((Component)treePane, (Object)"Center");
        VerticalPanel leftDownPane = new VerticalPanel();
        leftDownPane.add(this.createComboRender(), (Object)"North");
        this.autoScrollCB = new JCheckBox(JMeterUtils.getResString((String)"view_results_autoscroll"));
        this.autoScrollCB.setSelected(false);
        this.autoScrollCB.addItemListener(this);
        leftDownPane.add((Component)this.autoScrollCB, (Object)"South");
        leftPane.add((Component)leftDownPane, (Object)"South");
        return leftPane;
    }

    private Component createComboRender() {
        DefaultComboBoxModel nodesModel = new DefaultComboBoxModel();
        this.selectRenderPanel = new JComboBox(nodesModel);
        this.selectRenderPanel.setActionCommand(COMBO_CHANGE_COMMAND);
        this.selectRenderPanel.addActionListener(this);
        List classesToAdd = Collections.emptyList();
        try {
            classesToAdd = JMeterUtils.findClassesThatExtend(ResultRenderer.class);
        }
        catch (IOException e1) {
            // empty catch block
        }
        String textRenderer = JMeterUtils.getResString((String)"view_results_render_text");
        ResultRenderer textObject = null;
        for (String clazz : classesToAdd) {
            try {
                ResultRenderer renderer = (ResultRenderer)Class.forName(clazz).newInstance();
                if (textRenderer.equals(((Object)renderer).toString())) {
                    textObject = renderer;
                }
                renderer.setBackgroundColor(this.getBackground());
                this.selectRenderPanel.addItem(renderer);
            }
            catch (Exception e) {
                log.warn("Error in load result render:" + clazz, (Throwable)e);
            }
        }
        nodesModel.setSelectedItem(textObject);
        return this.selectRenderPanel;
    }

    public void actionPerformed(ActionEvent event) {
        JComboBox jcb;
        String command = event.getActionCommand();
        if (COMBO_CHANGE_COMMAND.equals(command) && (jcb = (JComboBox)event.getSource()) != null) {
            this.resultsRender = (ResultRenderer)jcb.getSelectedItem();
            if (this.rightSide != null) {
                this.selectedTab = this.rightSide.getSelectedIndex();
                this.mainSplit.remove(this.rightSide);
                this.rightSide = new JTabbedPane();
                this.mainSplit.add(this.rightSide);
                this.resultsRender.setRightSide(this.rightSide);
                this.resultsRender.setLastSelectedTab(this.selectedTab);
                log.debug("selectedTab=" + this.selectedTab);
                this.resultsRender.init();
                this.valueChanged(this.lastSelectionEvent);
            }
        }
    }

    public static String getResponseAsString(SampleResult res) {
        String response = null;
        if ("text".equals(res.getDataType())) {
            int len = res.getResponseData().length;
            if (MAX_DISPLAY_SIZE > 0 && len > MAX_DISPLAY_SIZE) {
                StringBuilder builder = new StringBuilder(MAX_DISPLAY_SIZE + 100);
                builder.append(JMeterUtils.getResString((String)"view_results_response_too_large_message")).append(len).append(" > Max: ").append(MAX_DISPLAY_SIZE).append(", ").append(JMeterUtils.getResString((String)"view_results_response_partial_message")).append("\n").append(res.getResponseDataAsString().substring(0, MAX_DISPLAY_SIZE)).append("\n...");
                response = builder.toString();
                log.warn(response);
            } else {
                response = res.getResponseDataAsString();
            }
        }
        return response;
    }

    public void itemStateChanged(ItemEvent e) {
    }

    private static class ResultsNodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 4159626601097711565L;

        private ResultsNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            boolean failure = true;
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof SampleResult) {
                failure = !((SampleResult)userObject).isSuccessful();
            } else if (userObject instanceof AssertionResult) {
                AssertionResult assertion = (AssertionResult)userObject;
                boolean bl = failure = assertion.isError() || assertion.isFailure();
            }
            if (failure) {
                this.setForeground(Color.red);
                this.setIcon(imageFailure);
            } else {
                this.setIcon(imageSuccess);
            }
            return this;
        }
    }
}

