/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.jmeter.assertions.XPathAssertion;
import org.apache.jmeter.extractor.XPathExtractor;
import org.apache.jmeter.util.JMeterUtils;

public class XMLConfPanel
extends JPanel {
    private static final long serialVersionUID = 240L;
    private JCheckBox validate;
    private JCheckBox tolerant;
    private JCheckBox whitespace;
    private JCheckBox namespace;
    private JCheckBox quiet;
    private JCheckBox reportErrors;
    private JCheckBox showWarnings;
    private JCheckBox downloadDTDs;

    public XMLConfPanel() {
        this.init();
    }

    private void init() {
        this.quiet = new JCheckBox(JMeterUtils.getResString((String)"xpath_tidy_quiet"), true);
        this.reportErrors = new JCheckBox(JMeterUtils.getResString((String)"xpath_tidy_report_errors"), true);
        this.showWarnings = new JCheckBox(JMeterUtils.getResString((String)"xpath_tidy_show_warnings"), true);
        this.namespace = new JCheckBox(JMeterUtils.getResString((String)"xml_namespace_button"));
        this.whitespace = new JCheckBox(JMeterUtils.getResString((String)"xml_whitespace_button"));
        this.validate = new JCheckBox(JMeterUtils.getResString((String)"xml_validate_button"));
        this.tolerant = new JCheckBox(JMeterUtils.getResString((String)"xml_tolerant_button"));
        this.tolerant.addActionListener(e -> this.tolerant());
        this.downloadDTDs = new JCheckBox(JMeterUtils.getResString((String)"xml_download_dtds"));
        Box tidyOptions = Box.createHorizontalBox();
        tidyOptions.setBorder(BorderFactory.createEtchedBorder());
        tidyOptions.add(this.tolerant);
        tidyOptions.add(this.quiet);
        tidyOptions.add(this.reportErrors);
        tidyOptions.add(this.showWarnings);
        Box untidyOptions = Box.createHorizontalBox();
        untidyOptions.setBorder(BorderFactory.createEtchedBorder());
        untidyOptions.add(this.namespace);
        untidyOptions.add(this.validate);
        untidyOptions.add(this.whitespace);
        untidyOptions.add(this.downloadDTDs);
        Box options = Box.createVerticalBox();
        options.add(tidyOptions);
        options.add(untidyOptions);
        this.add(options);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        this.whitespace.setSelected(false);
        this.validate.setSelected(false);
        this.tolerant.setSelected(false);
        this.namespace.setSelected(false);
        this.quiet.setSelected(true);
        this.reportErrors.setSelected(false);
        this.showWarnings.setSelected(false);
        this.downloadDTDs.setSelected(false);
        this.tolerant();
    }

    private void tolerant() {
        boolean isTolerant = this.tolerant.isSelected();
        this.validate.setEnabled(!isTolerant);
        this.whitespace.setEnabled(!isTolerant);
        this.namespace.setEnabled(!isTolerant);
        this.downloadDTDs.setEnabled(!isTolerant);
        this.quiet.setEnabled(isTolerant);
        this.reportErrors.setEnabled(isTolerant);
        this.showWarnings.setEnabled(isTolerant);
    }

    public void modifyTestElement(XPathAssertion assertion) {
        assertion.setValidating(this.validate.isSelected());
        assertion.setWhitespace(this.whitespace.isSelected());
        assertion.setTolerant(this.tolerant.isSelected());
        assertion.setNamespace(this.namespace.isSelected());
        assertion.setShowWarnings(this.showWarnings.isSelected());
        assertion.setReportErrors(this.reportErrors.isSelected());
        assertion.setQuiet(this.quiet.isSelected());
        assertion.setDownloadDTDs(this.downloadDTDs.isSelected());
    }

    public void modifyTestElement(XPathExtractor extractor) {
        extractor.setValidating(this.validate.isSelected());
        extractor.setWhitespace(this.whitespace.isSelected());
        extractor.setTolerant(this.tolerant.isSelected());
        extractor.setNameSpace(this.namespace.isSelected());
        extractor.setShowWarnings(this.showWarnings.isSelected());
        extractor.setReportErrors(this.reportErrors.isSelected());
        extractor.setQuiet(this.quiet.isSelected());
        extractor.setDownloadDTDs(this.downloadDTDs.isSelected());
    }

    public void configure(XPathAssertion assertion) {
        this.whitespace.setSelected(assertion.isWhitespace());
        this.validate.setSelected(assertion.isValidating());
        this.tolerant.setSelected(assertion.isTolerant());
        this.namespace.setSelected(assertion.isNamespace());
        this.quiet.setSelected(assertion.isQuiet());
        this.showWarnings.setSelected(assertion.showWarnings());
        this.reportErrors.setSelected(assertion.reportErrors());
        this.downloadDTDs.setSelected(assertion.isDownloadDTDs());
        this.tolerant();
    }

    public void configure(XPathExtractor extractor) {
        this.whitespace.setSelected(extractor.isWhitespace());
        this.validate.setSelected(extractor.isValidating());
        this.tolerant.setSelected(extractor.isTolerant());
        this.namespace.setSelected(extractor.useNameSpace());
        this.quiet.setSelected(extractor.isQuiet());
        this.showWarnings.setSelected(extractor.showWarnings());
        this.reportErrors.setSelected(extractor.reportErrors());
        this.downloadDTDs.setSelected(extractor.isDownloadDTDs());
        this.tolerant();
    }
}

