/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.SaveGraphics;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.HeaderAsPropertyRendererWrapper;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.AxisGraph;
import org.apache.jmeter.visualizers.BarGraph;
import org.apache.jmeter.visualizers.SamplingStatCalculator;
import org.apache.jmeter.visualizers.StatGraphProperties;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.gui.ObjectTableSorter;
import org.apache.jorphan.gui.RateRenderer;
import org.apache.jorphan.gui.RendererUtils;
import org.apache.jorphan.reflect.Functor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatGraphVisualizer
extends AbstractVisualizer
implements Clearable,
ActionListener {
    private static final long serialVersionUID = 242L;
    private static final String PCT1_LABEL = JMeterUtils.getPropDefault((String)"aggregate_rpt_pct1", (String)"90");
    private static final String PCT2_LABEL = JMeterUtils.getPropDefault((String)"aggregate_rpt_pct2", (String)"95");
    private static final String PCT3_LABEL = JMeterUtils.getPropDefault((String)"aggregate_rpt_pct3", (String)"99");
    private static final Float PCT1_VALUE = new Float(Float.parseFloat(PCT1_LABEL) / 100.0f);
    private static final Float PCT2_VALUE = new Float(Float.parseFloat(PCT2_LABEL) / 100.0f);
    private static final Float PCT3_VALUE = new Float(Float.parseFloat(PCT3_LABEL) / 100.0f);
    private static final Logger log = LoggerFactory.getLogger(StatGraphVisualizer.class);
    private static final String[] COLUMNS = new String[]{"sampler_label", "aggregate_report_count", "average", "aggregate_report_median", "aggregate_report_xx_pct1_line", "aggregate_report_xx_pct2_line", "aggregate_report_xx_pct3_line", "aggregate_report_min", "aggregate_report_max", "aggregate_report_error%", "aggregate_report_rate", "aggregate_report_bandwidth", "aggregate_report_sent_bytes_per_sec"};
    private static final String[] GRAPH_COLUMNS = new String[]{"average", "aggregate_report_median", "aggregate_report_xx_pct1_line", "aggregate_report_xx_pct2_line", "aggregate_report_xx_pct3_line", "aggregate_report_min", "aggregate_report_max"};
    private static final String TOTAL_ROW_LABEL = JMeterUtils.getResString((String)"aggregate_report_total_label");
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private static final int REFRESH_PERIOD = JMeterUtils.getPropDefault((String)"jmeter.gui.refresh_period", (int)500);
    private JTable myJTable;
    private JScrollPane myScrollPane;
    private transient ObjectTableModel model;
    private final transient Object lock = new Object();
    private final Map<String, SamplingStatCalculator> tableRows = new ConcurrentHashMap<String, SamplingStatCalculator>();
    private AxisGraph graphPanel = null;
    private JPanel settingsPane = null;
    private JSplitPane spane = null;
    private JTabbedPane tabbedGraph = new JTabbedPane(1);
    private JButton displayButton = new JButton(JMeterUtils.getResString((String)"aggregate_graph_display"));
    private JButton saveGraph = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save"));
    private JButton saveTable = new JButton(JMeterUtils.getResString((String)"aggregate_graph_save_table"));
    private JButton chooseForeColor = new JButton(JMeterUtils.getResString((String)"aggregate_graph_choose_foreground_color"));
    private JButton syncWithName = new JButton(JMeterUtils.getResString((String)"aggregate_graph_sync_with_name"));
    private JCheckBox saveHeaders = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_save_table_header"));
    private JLabeledTextField graphTitle = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_user_title"));
    private JLabeledTextField maxLengthXAxisLabel = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_max_length_xaxis_label"), 8);
    private JLabeledTextField maxValueYAxisLabel = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_yaxis_max_value"), 8);
    private JCheckBox dynamicGraphSize = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_dynamic_size"));
    private JLabeledTextField graphWidth = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_width"), 6);
    private JLabeledTextField graphHeight = new JLabeledTextField(JMeterUtils.getResString((String)"aggregate_graph_height"), 6);
    private String yAxisLabel = JMeterUtils.getResString((String)"aggregate_graph_response_time");
    private String yAxisTitle = JMeterUtils.getResString((String)"aggregate_graph_ms");
    private boolean saveGraphToFile = false;
    private int defaultWidth = 400;
    private int defaultHeight = 300;
    private JComboBox<String> columnsList = new JComboBox<String>(GRAPH_COLUMNS);
    private List<BarGraph> eltList = new ArrayList<BarGraph>();
    private JCheckBox columnSelection = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_column_selection"), false);
    private JTextField columnMatchLabel = new JTextField();
    private JButton applyFilterBtn = new JButton(JMeterUtils.getResString((String)"graph_apply_filter"));
    private JCheckBox caseChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_case"), false);
    private JCheckBox regexpChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_regexp"), true);
    private JComboBox<String> titleFontNameList = new JComboBox<String>(this.keys(StatGraphProperties.getFontNameMap()));
    private JComboBox<String> titleFontSizeList = new JComboBox<String>(StatGraphProperties.getFontSize());
    private JComboBox<String> titleFontStyleList = new JComboBox<String>(this.keys(StatGraphProperties.getFontStyleMap()));
    private JComboBox<String> valueFontNameList = new JComboBox<String>(this.keys(StatGraphProperties.getFontNameMap()));
    private JComboBox<String> valueFontSizeList = new JComboBox<String>(StatGraphProperties.getFontSize());
    private JComboBox<String> valueFontStyleList = new JComboBox<String>(this.keys(StatGraphProperties.getFontStyleMap()));
    private JComboBox<String> fontNameList = new JComboBox<String>(this.keys(StatGraphProperties.getFontNameMap()));
    private JComboBox<String> fontSizeList = new JComboBox<String>(StatGraphProperties.getFontSize());
    private JComboBox<String> fontStyleList = new JComboBox<String>(this.keys(StatGraphProperties.getFontStyleMap()));
    private JComboBox<String> legendPlacementList = new JComboBox<String>(this.keys(StatGraphProperties.getPlacementNameMap()));
    private JCheckBox drawOutlinesBar = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_draw_outlines"), true);
    private JCheckBox numberShowGrouping = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_number_grouping"), true);
    private JCheckBox valueLabelsVertical = new JCheckBox(JMeterUtils.getResString((String)"aggregate_graph_value_labels_vertical"), true);
    private Color colorBarGraph = Color.YELLOW;
    private Color colorForeGraph = Color.BLACK;
    private int nbColToGraph = 1;
    private Pattern pattern = null;
    private Deque<SamplingStatCalculator> newRows = new ConcurrentLinkedDeque<SamplingStatCalculator>();

    public StatGraphVisualizer() {
        this.model = StatGraphVisualizer.createObjectTableModel();
        Color red = new Color(202, 0, 0);
        Color blue = new Color(49, 49, 181);
        Color green = new Color(42, 121, 42);
        Color yellow = new Color(242, 226, 8);
        Color purple = new Color(202, 10, 232);
        this.eltList.add(new BarGraph(JMeterUtils.getResString((String)"average"), true, red));
        this.eltList.add(new BarGraph(JMeterUtils.getResString((String)"aggregate_report_median"), false, blue));
        this.eltList.add(new BarGraph(MessageFormat.format(JMeterUtils.getResString((String)"aggregate_report_xx_pct1_line"), PCT1_LABEL), false, green));
        this.eltList.add(new BarGraph(MessageFormat.format(JMeterUtils.getResString((String)"aggregate_report_xx_pct2_line"), PCT2_LABEL), false, yellow));
        this.eltList.add(new BarGraph(MessageFormat.format(JMeterUtils.getResString((String)"aggregate_report_xx_pct3_line"), PCT3_LABEL), false, purple));
        this.eltList.add(new BarGraph(JMeterUtils.getResString((String)"aggregate_report_min"), false, Color.LIGHT_GRAY));
        this.eltList.add(new BarGraph(JMeterUtils.getResString((String)"aggregate_report_max"), false, Color.DARK_GRAY));
        this.clearData();
        this.init();
    }

    static final Object[][] getColumnsMsgParameters() {
        return new Object[][]{null, null, null, null, {PCT1_LABEL}, {PCT2_LABEL}, {PCT3_LABEL}, null, null, null, null, null, null};
    }

    private String[] keys(Map<String, ?> map) {
        return map.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static final String[] getColumns() {
        String[] columns = new String[COLUMNS.length];
        System.arraycopy(COLUMNS, 0, columns, 0, COLUMNS.length);
        return columns;
    }

    static ObjectTableModel createObjectTableModel() {
        return new ObjectTableModel(StatGraphVisualizer.getLabels(COLUMNS), SamplingStatCalculator.class, new Functor[]{new Functor("getLabel"), new Functor("getCount"), new Functor("getMeanAsNumber"), new Functor("getMedian"), new Functor("getPercentPoint", new Object[]{PCT1_VALUE}), new Functor("getPercentPoint", new Object[]{PCT2_VALUE}), new Functor("getPercentPoint", new Object[]{PCT3_VALUE}), new Functor("getMin"), new Functor("getMax"), new Functor("getErrorPercentage"), new Functor("getRate"), new Functor("getKBPerSecond"), new Functor("getSentKBPerSecond")}, new Functor[]{null, null, null, null, null, null, null, null, null, null, null, null, null}, new Class[]{String.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Long.class, Double.class, Double.class, Double.class, Double.class});
    }

    static final Format[] getFormatters() {
        return new Format[]{null, null, null, null, null, null, null, null, null, new DecimalFormat("#0.000%"), new DecimalFormat("#.00000"), new DecimalFormat("#0.00"), new DecimalFormat("#0.00")};
    }

    static final TableCellRenderer[] getRenderers() {
        return new TableCellRenderer[]{null, null, null, null, null, null, null, null, null, new NumberRenderer("#0.00%"), new RateRenderer("#.0"), new NumberRenderer("#0.00"), new NumberRenderer("#0.00")};
    }

    static String[] getLabels(String[] keys) {
        String[] labels = new String[keys.length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = MessageFormat.format(JMeterUtils.getResString((String)keys[i]), StatGraphVisualizer.getColumnsMsgParameters()[i]);
        }
        return labels;
    }

    public static List<List<Object>> getAllTableData(ObjectTableModel model, Format[] formats) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        if (model.getRowCount() > 0) {
            for (int rw = 0; rw < model.getRowCount(); ++rw) {
                int cols = model.getColumnCount();
                ArrayList<Object> column = new ArrayList<Object>();
                data.add(column);
                for (int idx = 0; idx < cols; ++idx) {
                    Object val = model.getValueAt(rw, idx);
                    if (formats[idx] != null) {
                        column.add(formats[idx].format(val));
                        continue;
                    }
                    column.add(val);
                }
            }
        }
        return data;
    }

    public static boolean testFunctors() {
        StatGraphVisualizer instance = new StatGraphVisualizer();
        return instance.model.checkFunctors(null, instance.getClass());
    }

    public String getLabelResource() {
        return "aggregate_graph_title";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SampleResult res) {
        String sampleLabel = res.getSampleLabel();
        Matcher matcher = null;
        if (this.columnSelection.isSelected() && this.pattern != null) {
            matcher = this.pattern.matcher(sampleLabel);
        }
        if (matcher == null || matcher.find()) {
            SamplingStatCalculator row;
            Object object = row = this.tableRows.computeIfAbsent(sampleLabel, label -> {
                SamplingStatCalculator newRow = new SamplingStatCalculator(label);
                this.newRows.addLast(newRow);
                return newRow;
            });
            synchronized (object) {
                row.addSample(res);
            }
            object = this.lock;
            synchronized (object) {
                this.tableRows.get(TOTAL_ROW_LABEL).addSample(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData() {
        Object object = this.lock;
        synchronized (object) {
            this.model.clearData();
            this.tableRows.clear();
            this.newRows.clear();
            this.tableRows.put(TOTAL_ROW_LABEL, new SamplingStatCalculator(TOTAL_ROW_LABEL));
            this.model.addRow((Object)this.tableRows.get(TOTAL_ROW_LABEL));
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        EmptyBorder margin2 = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.makeTitlePanel());
        this.myJTable = new JTable((TableModel)this.model);
        this.myJTable.setRowSorter((RowSorter<? extends TableModel>)new ObjectTableSorter(this.model).fixLastRow());
        JMeterUtils.applyHiDPI((JTable)this.myJTable);
        HeaderAsPropertyRendererWrapper.setupDefaultRenderer((JTable)this.myJTable);
        this.myJTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        RendererUtils.applyRenderers((JTable)this.myJTable, (TableCellRenderer[])StatGraphVisualizer.getRenderers());
        this.myScrollPane = new JScrollPane(this.myJTable);
        this.settingsPane = new VerticalPanel();
        this.settingsPane.setBorder(margin2);
        this.graphPanel = new AxisGraph();
        this.graphPanel.setPreferredSize(new Dimension(this.defaultWidth, this.defaultHeight));
        this.settingsPane.add(this.createGraphActionsPane());
        this.settingsPane.add(this.createGraphColumnPane());
        this.settingsPane.add(this.createGraphTitlePane());
        this.settingsPane.add(this.createGraphDimensionPane());
        JPanel axisPane = new JPanel(new BorderLayout());
        axisPane.add((Component)this.createGraphXAxisPane(), "West");
        axisPane.add((Component)this.createGraphYAxisPane(), "Center");
        this.settingsPane.add(axisPane);
        this.settingsPane.add(this.createLegendPane());
        this.tabbedGraph.addTab(JMeterUtils.getResString((String)"aggregate_graph_tab_settings"), this.settingsPane);
        this.tabbedGraph.addTab(JMeterUtils.getResString((String)"aggregate_graph_tab_graph"), this.graphPanel);
        this.tabbedGraph.addChangeListener(changeEvent -> {
            int index;
            JTabbedPane srcTab = (JTabbedPane)changeEvent.getSource();
            if (srcTab.getTitleAt(index = srcTab.getSelectedIndex()).equals(JMeterUtils.getResString((String)"aggregate_graph_tab_graph"))) {
                this.actionMakeGraph();
            }
        });
        this.spane = new JSplitPane(0);
        this.spane.setOneTouchExpandable(true);
        this.spane.setLeftComponent(this.myScrollPane);
        this.spane.setRightComponent(this.tabbedGraph);
        this.spane.setResizeWeight(0.2);
        this.spane.setBorder(null);
        this.spane.setContinuousLayout(true);
        this.add(mainPanel, "North");
        this.add(this.spane, "Center");
        new Timer(REFRESH_PERIOD, e -> {
            Object object = this.lock;
            synchronized (object) {
                while (!this.newRows.isEmpty()) {
                    this.model.insertRow((Object)this.newRows.pop(), this.model.getRowCount() - 1);
                }
            }
            this.model.fireTableDataChanged();
        }).start();
    }

    public void makeGraph() {
        this.nbColToGraph = this.getNbColumns();
        Dimension size = this.graphPanel.getSize();
        String lstr = this.maxLengthXAxisLabel.getText();
        int width = (int)size.getWidth();
        int height = (int)size.getHeight();
        if (!this.dynamicGraphSize.isSelected()) {
            String wstr = this.graphWidth.getText();
            String hstr = this.graphHeight.getText();
            if (wstr.length() != 0) {
                width = Integer.parseInt(wstr);
            }
            if (hstr.length() != 0) {
                height = Integer.parseInt(hstr);
            }
        }
        if (lstr.length() == 0) {
            lstr = "20";
        }
        int maxLength = Integer.parseInt(lstr);
        String yAxisStr = this.maxValueYAxisLabel.getText();
        int maxYAxisScale = yAxisStr.length() == 0 ? 0 : Integer.parseInt(yAxisStr);
        this.graphPanel.setData(this.getData());
        this.graphPanel.setTitle(this.graphTitle.getText());
        this.graphPanel.setMaxLength(maxLength);
        this.graphPanel.setMaxYAxisScale(maxYAxisScale);
        this.graphPanel.setXAxisLabels(this.getAxisLabels());
        this.graphPanel.setXAxisTitle(JMeterUtils.getResString((String)((String)this.columnsList.getSelectedItem())));
        this.graphPanel.setYAxisLabels(this.yAxisLabel);
        this.graphPanel.setYAxisTitle(this.yAxisTitle);
        this.graphPanel.setLegendLabels(this.getLegendLabels());
        this.graphPanel.setColor(this.getBackColors());
        this.graphPanel.setForeColor(this.colorForeGraph);
        this.graphPanel.setOutlinesBarFlag(this.drawOutlinesBar.isSelected());
        this.graphPanel.setShowGrouping(this.numberShowGrouping.isSelected());
        this.graphPanel.setValueOrientation(this.valueLabelsVertical.isSelected());
        this.graphPanel.setLegendPlacement(StatGraphProperties.getPlacementNameMap().get(this.legendPlacementList.getSelectedItem()));
        this.graphPanel.setTitleFont(new Font(StatGraphProperties.getFontNameMap().get(this.titleFontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.titleFontStyleList.getSelectedItem()), Integer.parseInt((String)this.titleFontSizeList.getSelectedItem())));
        this.graphPanel.setLegendFont(new Font(StatGraphProperties.getFontNameMap().get(this.fontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.fontStyleList.getSelectedItem()), Integer.parseInt((String)this.fontSizeList.getSelectedItem())));
        this.graphPanel.setValueFont(new Font(StatGraphProperties.getFontNameMap().get(this.valueFontNameList.getSelectedItem()), (int)StatGraphProperties.getFontStyleMap().get(this.valueFontStyleList.getSelectedItem()), Integer.parseInt((String)this.valueFontSizeList.getSelectedItem())));
        this.graphPanel.setHeight(height);
        this.graphPanel.setWidth(width);
        this.spane.repaint();
    }

    public double[][] getData() {
        if (this.model.getRowCount() > 1) {
            int count = this.model.getRowCount() - 1;
            int size = this.nbColToGraph;
            double[][] data = new double[size][count];
            int s = 0;
            int cpt = 0;
            for (BarGraph bar : this.eltList) {
                if (bar.getChkBox().isSelected()) {
                    int col = this.model.findColumn(this.columnsList.getItemAt(cpt));
                    for (int idx = 0; idx < count; ++idx) {
                        data[s][idx] = ((Number)this.model.getValueAt(idx, col)).doubleValue();
                    }
                    ++s;
                }
                ++cpt;
            }
            return data;
        }
        return null;
    }

    public String[] getAxisLabels() {
        if (this.model.getRowCount() > 1) {
            int count = this.model.getRowCount() - 1;
            String[] labels = new String[count];
            for (int idx = 0; idx < count; ++idx) {
                labels[idx] = (String)this.model.getValueAt(idx, 0);
            }
            return labels;
        }
        return null;
    }

    private String[] getLegendLabels() {
        String[] legends = new String[this.nbColToGraph];
        int i = 0;
        for (BarGraph bar : this.eltList) {
            if (!bar.getChkBox().isSelected()) continue;
            legends[i] = bar.getLabel();
            ++i;
        }
        return legends;
    }

    private Color[] getBackColors() {
        Color[] backColors = new Color[this.nbColToGraph];
        int i = 0;
        for (BarGraph bar : this.eltList) {
            if (!bar.getChkBox().isSelected()) continue;
            backColors[i] = bar.getBackColor();
            ++i;
        }
        return backColors;
    }

    private int getNbColumns() {
        int i = 0;
        for (BarGraph bar : this.eltList) {
            if (!bar.getChkBox().isSelected()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton btn;
        boolean forceReloadData = false;
        Object eventSource = event.getSource();
        if (eventSource == this.displayButton) {
            this.actionMakeGraph();
        } else if (eventSource == this.saveGraph) {
            this.saveGraphToFile = true;
            try {
                ActionRouter.getInstance().getAction("save_graphics", SaveGraphics.class.getName()).doAction(new ActionEvent(this, event.getID(), "save_graphics"));
            }
            catch (Exception e) {
                log.error("Error saving to file", (Throwable)e);
            }
        } else if (eventSource == this.saveTable) {
            JFileChooser chooser = FileDialoger.promptToSaveFile((String)"statistics.csv");
            if (chooser == null) {
                return;
            }
            try (FileOutputStream fo = new FileOutputStream(chooser.getSelectedFile());
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fo, Charset.forName("UTF-8"));){
                CSVSaveService.saveCSVStats(StatGraphVisualizer.getAllTableData(this.model, StatGraphVisualizer.getFormatters()), (Writer)writer, (String[])(this.saveHeaders.isSelected() ? StatGraphVisualizer.getLabels(COLUMNS) : null));
            }
            catch (IOException e) {
                JMeterUtils.reportErrorToUser((String)e.getMessage(), (String)"Error saving data");
            }
        } else if (eventSource == this.chooseForeColor) {
            Color color = JColorChooser.showDialog(null, JMeterUtils.getResString((String)"aggregate_graph_choose_color"), this.colorBarGraph);
            if (color != null) {
                this.colorForeGraph = color;
            }
        } else if (eventSource == this.syncWithName) {
            this.graphTitle.setText(this.namePanel.getName());
        } else if (eventSource == this.dynamicGraphSize) {
            if (this.dynamicGraphSize.isSelected()) {
                this.graphWidth.setEnabled(false);
                this.graphHeight.setEnabled(false);
            } else {
                this.graphWidth.setEnabled(true);
                this.graphHeight.setEnabled(true);
            }
        } else if (eventSource == this.columnSelection) {
            if (this.columnSelection.isSelected()) {
                this.columnMatchLabel.setEnabled(true);
                this.applyFilterBtn.setEnabled(true);
                this.caseChkBox.setEnabled(true);
                this.regexpChkBox.setEnabled(true);
            } else {
                this.columnMatchLabel.setEnabled(false);
                this.applyFilterBtn.setEnabled(false);
                this.caseChkBox.setEnabled(false);
                this.regexpChkBox.setEnabled(false);
                forceReloadData = true;
            }
        }
        if (eventSource == this.applyFilterBtn || forceReloadData) {
            if (this.columnSelection.isSelected() && this.columnMatchLabel.getText() != null && this.columnMatchLabel.getText().length() > 0) {
                this.pattern = this.createPattern(this.columnMatchLabel.getText());
            } else if (forceReloadData) {
                this.pattern = null;
            }
            if (this.getFile() != null && this.getFile().length() > 0) {
                this.clearData();
                FilePanel filePanel = (FilePanel)this.getFilePanel();
                filePanel.actionPerformed(event);
            }
        } else if (eventSource instanceof JButton && (btn = (JButton)eventSource).getName() != null) {
            try {
                BarGraph bar = this.eltList.get(Integer.parseInt(btn.getName()));
                Color color = JColorChooser.showDialog(null, bar.getLabel(), bar.getBackColor());
                if (color != null) {
                    bar.setBackColor(color);
                    btn.setBackground(bar.getBackColor());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void actionMakeGraph() {
        if (this.model.getRowCount() > 1) {
            this.makeGraph();
            this.tabbedGraph.setSelectedIndex(1);
        } else {
            JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"aggregate_graph_no_values_to_graph"), JMeterUtils.getResString((String)"aggregate_graph_no_values_to_graph"), 2);
        }
    }

    public JComponent getPrintableComponent() {
        if (this.saveGraphToFile) {
            this.saveGraphToFile = false;
            if (this.model.getRowCount() > 1) {
                this.makeGraph();
            }
            this.graphPanel.setBounds(this.graphPanel.getLocation().x, this.graphPanel.getLocation().y, this.graphPanel.width, this.graphPanel.height);
            return this.graphPanel;
        }
        return this;
    }

    private JPanel createGraphActionsPane() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel displayPane = new JPanel();
        displayPane.add(this.displayButton);
        this.displayButton.addActionListener(this);
        buttonPanel.add((Component)displayPane, "West");
        JPanel savePane = new JPanel();
        savePane.add(this.saveGraph);
        savePane.add(this.saveTable);
        savePane.add(this.saveHeaders);
        this.saveGraph.addActionListener(this);
        this.saveTable.addActionListener(this);
        this.syncWithName.addActionListener(this);
        buttonPanel.add((Component)savePane, "East");
        return buttonPanel;
    }

    private JPanel createGraphColumnPane() {
        JPanel colPanel = new JPanel();
        colPanel.setLayout(new FlowLayout(0, 5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"aggregate_graph_columns_to_display"));
        colPanel.add(label);
        for (BarGraph bar : this.eltList) {
            colPanel.add(bar.getChkBox());
            colPanel.add(this.createColorBarButton(bar, this.eltList.indexOf(bar)));
        }
        colPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.chooseForeColor.setFont(FONT_SMALL);
        colPanel.add(this.chooseForeColor);
        this.chooseForeColor.addActionListener(this);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new FlowLayout(0, 0, 0));
        optionsPanel.add(this.createGraphFontValuePane());
        optionsPanel.add(this.drawOutlinesBar);
        optionsPanel.add(this.numberShowGrouping);
        optionsPanel.add(this.valueLabelsVertical);
        JPanel barPane = new JPanel(new BorderLayout());
        barPane.add((Component)colPanel, "North");
        barPane.add(Box.createRigidArea(new Dimension(0, 3)), "Center");
        barPane.add((Component)optionsPanel, "South");
        JPanel columnPane = new JPanel(new BorderLayout());
        columnPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_column_settings")));
        columnPane.add((Component)barPane, "North");
        columnPane.add(Box.createRigidArea(new Dimension(0, 3)), "Center");
        columnPane.add((Component)this.createGraphSelectionSubPane(), "South");
        return columnPane;
    }

    private JButton createColorBarButton(BarGraph barGraph, int index) {
        JButton colorBtn = new JButton();
        colorBtn.setName(String.valueOf(index));
        colorBtn.setFont(FONT_SMALL);
        colorBtn.addActionListener(this);
        colorBtn.setBackground(barGraph.getBackColor());
        return colorBtn;
    }

    private JPanel createGraphSelectionSubPane() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 0));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        searchPanel.add(this.columnSelection);
        this.columnMatchLabel.setEnabled(false);
        this.applyFilterBtn.setEnabled(false);
        this.caseChkBox.setEnabled(false);
        this.regexpChkBox.setEnabled(false);
        this.columnSelection.addActionListener(this);
        searchPanel.add(this.columnMatchLabel);
        searchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.applyFilterBtn.setFont(FONT_SMALL);
        this.applyFilterBtn.addActionListener(this);
        searchPanel.add(this.applyFilterBtn);
        this.caseChkBox.setFont(FONT_SMALL);
        searchPanel.add(this.caseChkBox);
        this.regexpChkBox.setFont(FONT_SMALL);
        searchPanel.add(this.regexpChkBox);
        return searchPanel;
    }

    private JPanel createGraphTitlePane() {
        JPanel titleNamePane = new JPanel(new BorderLayout());
        this.syncWithName.setFont(new Font("SansSerif", 0, 10));
        titleNamePane.add((Component)this.graphTitle, "Center");
        titleNamePane.add((Component)this.syncWithName, "East");
        JPanel titleStylePane = new JPanel();
        titleStylePane.setLayout(new FlowLayout(0, 0, 5));
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_font"), this.titleFontNameList));
        this.titleFontNameList.setSelectedIndex(0);
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), this.titleFontSizeList));
        this.titleFontSizeList.setSelectedItem(StatGraphProperties.getFontSize()[6]);
        titleStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), this.titleFontStyleList));
        this.titleFontStyleList.setSelectedItem(JMeterUtils.getResString((String)"fontstyle.bold"));
        JPanel titlePane = new JPanel(new BorderLayout());
        titlePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_title_group")));
        titlePane.add((Component)titleNamePane, "North");
        titlePane.add((Component)titleStylePane, "South");
        return titlePane;
    }

    private JPanel createGraphFontValuePane() {
        JPanel fontValueStylePane = new JPanel();
        fontValueStylePane.setLayout(new FlowLayout(0, 0, 0));
        fontValueStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_value_font"), this.valueFontNameList));
        this.valueFontNameList.setSelectedIndex(0);
        fontValueStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), this.valueFontSizeList));
        this.valueFontSizeList.setSelectedItem(StatGraphProperties.getFontSize()[2]);
        fontValueStylePane.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), this.valueFontStyleList));
        this.valueFontStyleList.setSelectedItem(JMeterUtils.getResString((String)"fontstyle.normal"));
        return fontValueStylePane;
    }

    private JPanel createGraphDimensionPane() {
        JPanel dimensionPane = new JPanel();
        dimensionPane.setLayout(new FlowLayout(0, 0, 0));
        dimensionPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_dimension")));
        dimensionPane.add(this.dynamicGraphSize);
        this.dynamicGraphSize.setSelected(true);
        this.graphWidth.setEnabled(false);
        this.graphHeight.setEnabled(false);
        this.dynamicGraphSize.addActionListener(this);
        dimensionPane.add(Box.createRigidArea(new Dimension(10, 0)));
        dimensionPane.add((Component)this.graphWidth);
        dimensionPane.add(Box.createRigidArea(new Dimension(5, 0)));
        dimensionPane.add((Component)this.graphHeight);
        return dimensionPane;
    }

    private JPanel createGraphXAxisPane() {
        JPanel xAxisPane = new JPanel();
        xAxisPane.setLayout(new FlowLayout(0, 0, 0));
        xAxisPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_xaxis_group")));
        xAxisPane.add((Component)this.maxLengthXAxisLabel);
        return xAxisPane;
    }

    private JPanel createGraphYAxisPane() {
        JPanel yAxisPane = new JPanel();
        yAxisPane.setLayout(new FlowLayout(0, 0, 0));
        yAxisPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_yaxis_group")));
        yAxisPane.add((Component)this.maxValueYAxisLabel);
        return yAxisPane;
    }

    private JPanel createLegendPane() {
        JPanel legendPanel = new JPanel();
        legendPanel.setLayout(new FlowLayout(0, 0, 0));
        legendPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"aggregate_graph_legend")));
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_legend_placement"), this.legendPlacementList));
        this.legendPlacementList.setSelectedItem(JMeterUtils.getResString((String)"aggregate_graph_legend.placement.bottom"));
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_font"), this.fontNameList));
        this.fontNameList.setSelectedIndex(0);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_size"), this.fontSizeList));
        this.fontSizeList.setSelectedItem(StatGraphProperties.getFontSize()[2]);
        legendPanel.add(GuiUtils.createLabelCombo((String)JMeterUtils.getResString((String)"aggregate_graph_style"), this.fontStyleList));
        this.fontStyleList.setSelectedItem(JMeterUtils.getResString((String)"fontstyle.normal"));
        return legendPanel;
    }

    private Pattern createPattern(String textToFind) {
        String textToFindQ = Pattern.quote(textToFind);
        if (this.regexpChkBox.isSelected()) {
            textToFindQ = textToFind;
        }
        Pattern result = null;
        try {
            result = this.caseChkBox.isSelected() ? Pattern.compile(textToFindQ) : Pattern.compile(textToFindQ, 2);
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
        return result;
    }
}

