/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.influxdb;

import java.io.Closeable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.influxdb.AbstractInfluxdbMetricsSender;
import org.apache.jmeter.visualizers.backend.influxdb.InfluxdbMetricsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpMetricsSender
extends AbstractInfluxdbMetricsSender {
    private static final Logger log = LoggerFactory.getLogger(HttpMetricsSender.class);
    private final Object lock = new Object();
    private List<InfluxdbMetricsSender.MetricTuple> metrics = new ArrayList<InfluxdbMetricsSender.MetricTuple>();
    private HttpPost httpRequest;
    private CloseableHttpAsyncClient httpClient;
    private URL url;
    private Future<HttpResponse> lastRequest;

    HttpMetricsSender() {
    }

    @Override
    public void setup(String influxdbUrl) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(1).setConnectTimeout(JMeterUtils.getPropDefault((String)"backend_influxdb.connection_timeout", (int)1000)).setSoTimeout(JMeterUtils.getPropDefault((String)"backend_influxdb.socket_timeout", (int)3000)).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        this.httpClient = HttpAsyncClientBuilder.create().setConnectionManager((NHttpClientConnectionManager)connManager).setMaxConnPerRoute(2).setMaxConnTotal(2).setUserAgent("ApacheJMeter" + JMeterUtils.getJMeterVersion()).disableCookieManagement().disableConnectionState().build();
        this.url = new URL(influxdbUrl);
        this.httpRequest = this.createRequest(this.url);
        this.httpClient.start();
    }

    private HttpPost createRequest(URL url) throws URISyntaxException {
        RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(JMeterUtils.getPropDefault((String)"backend_influxdb.connection_timeout", (int)1000)).setSocketTimeout(JMeterUtils.getPropDefault((String)"backend_influxdb.socket_timeout", (int)3000)).setConnectionRequestTimeout(JMeterUtils.getPropDefault((String)"backend_influxdb.connection_request_timeout", (int)100)).build();
        HttpPost currentHttpRequest = new HttpPost(url.toURI());
        currentHttpRequest.setConfig(defaultRequestConfig);
        log.debug("Created InfluxDBMetricsSender with url: {}", (Object)url);
        return currentHttpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(String mesurement, String tag, String field) {
        Object object = this.lock;
        synchronized (object) {
            this.metrics.add(new InfluxdbMetricsSender.MetricTuple(mesurement, tag, field, System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndSendMetrics() {
        List<InfluxdbMetricsSender.MetricTuple> tempMetrics;
        Object object = this.lock;
        synchronized (object) {
            if (this.metrics.isEmpty()) {
                return;
            }
            tempMetrics = this.metrics;
            this.metrics = new ArrayList<InfluxdbMetricsSender.MetricTuple>(tempMetrics.size());
        }
        final List<InfluxdbMetricsSender.MetricTuple> copyMetrics = tempMetrics;
        if (!copyMetrics.isEmpty()) {
            try {
                if (this.httpRequest == null) {
                    this.httpRequest = this.createRequest(this.url);
                }
                StringBuilder sb = new StringBuilder(copyMetrics.size() * 35);
                for (InfluxdbMetricsSender.MetricTuple metric : copyMetrics) {
                    sb.append(metric.measurement).append(metric.tag).append(" ").append(metric.field).append(" ").append(metric.timestamp + "000000").append("\n");
                }
                StringEntity entity = new StringEntity(sb.toString(), StandardCharsets.UTF_8);
                this.httpRequest.setEntity((HttpEntity)entity);
                this.lastRequest = this.httpClient.execute((HttpUriRequest)this.httpRequest, (FutureCallback)new FutureCallback<HttpResponse>(){

                    public void completed(HttpResponse response) {
                        int code = response.getStatusLine().getStatusCode();
                        if (log.isDebugEnabled()) {
                            if (code == 204) {
                                log.debug("Success, number of metrics written: {}", (Object)copyMetrics.size());
                            } else {
                                log.debug("Error writing metrics to influxDB Url: {}, responseCode: {}", (Object)HttpMetricsSender.this.url, (Object)code);
                            }
                        }
                    }

                    public void failed(Exception ex) {
                        log.error("failed to send data to influxDB server : {}", (Object)ex.getMessage());
                    }

                    public void cancelled() {
                        log.warn("Request to influxDB server was cancelled");
                    }
                });
            }
            catch (URISyntaxException ex) {
                log.error(ex.getMessage());
            }
            finally {
                copyMetrics.clear();
            }
        }
    }

    @Override
    public void destroy() {
        log.info("Destroying ");
        try {
            this.lastRequest.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("Error waiting for last request to be send to InfluxDB", (Throwable)e);
        }
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }
}

