/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.control;

import java.io.Serializable;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ParameterizedController
extends GenericController
implements Serializable,
LoopIterationListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean processed = false;
    private ValueReplacer replacer = new ValueReplacer();

    private void processVariables() {
        log.debug("Replacing values");
        this.replacer = new ValueReplacer();
        Arguments args1 = (Arguments)this.getUserDefinedVariablesAsProperty().getObjectValue();
        Arguments args = (Arguments)args1.clone();
        try {
            this.replacer.replaceValues((TestElement)args);
        }
        catch (InvalidVariableException ex) {
            log.error("Error replacing variables", (Throwable)ex);
        }
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        for (Map.Entry var : args.getArgumentsAsMap().entrySet()) {
            log.debug("Setting " + (String)var.getKey() + "=" + (String)var.getValue());
            vars.put((String)var.getKey(), (String)var.getValue());
        }
    }

    public Sampler next() {
        if (!this.processed) {
            this.processVariables();
        }
        this.processed = true;
        return super.next();
    }

    public void setUserDefinedVariables(Arguments vars) {
        this.setProperty((JMeterProperty)new TestElementProperty(this.getClass().getSimpleName(), (TestElement)vars));
    }

    public JMeterProperty getUserDefinedVariablesAsProperty() {
        return this.getProperty(this.getClass().getSimpleName());
    }

    public void iterationStart(LoopIterationEvent lie) {
        this.processed = false;
    }
}

