/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dcerpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import kg.apc.jmeter.dcerpc.DCERPCMarshalling;
import kg.apc.jmeter.dcerpc.DCERPCSamplerUtils;
import kg.apc.jmeter.dcerpc.RPCCallException;
import kg.apc.jmeter.dcerpc.RPCMarshallingException;
import kg.apc.jmeter.dcerpc.RPCPacket;
import org.apache.jmeter.protocol.tcp.sampler.AbstractTCPClient;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DCERPCSampler
extends AbstractTCPClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String unmarshalOptions = "";

    public void write(OutputStream os, InputStream is) {
        throw new UnsupportedOperationException();
    }

    public String read(InputStream is) {
        String hexString = "";
        try {
            byte packetFlags = 1;
            byte[] packetWithoutHeader = null;
            ByteArrayOutputStream stubDataStream = new ByteArrayOutputStream();
            while ((packetFlags & 2) != 2) {
                byte[] packetBytes = this.readNextPacket(is);
                packetFlags = RPCPacket.getPacketFlags(packetBytes);
                log.debug("Read packet flags: " + Byte.toString(packetFlags));
                try {
                    packetWithoutHeader = RPCPacket.getPacketWithoutHeader(packetBytes);
                }
                catch (RPCCallException ex) {
                    log.error("RPC returned error", (Throwable)ex);
                    packetWithoutHeader = packetBytes;
                }
                stubDataStream.write(packetWithoutHeader);
            }
            hexString = DCERPCMarshalling.unmarshalData(stubDataStream.toByteArray(), this.unmarshalOptions);
        }
        catch (RPCMarshallingException ex) {
            log.error("Unmarshal error: ", (Throwable)ex);
            hexString = "";
        }
        catch (SocketTimeoutException e) {
            log.warn(e.getMessage());
        }
        catch (InterruptedIOException e) {
            log.warn(e.getMessage());
        }
        catch (IOException e) {
            log.warn("Read error:" + e);
            hexString = "";
        }
        return hexString;
    }

    private byte[] readNextPacket(InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        short fragLen = 0;
        int singleReadCount = 0;
        short totalReadCount = 0;
        ByteArrayOutputStream resultsStream = new ByteArrayOutputStream();
        int readLimit = buffer.length;
        log.debug("Reading next packet");
        singleReadCount = is.read(buffer, 0, 16);
        if (singleReadCount != 16) {
            throw new IOException("Failed to read RPC header bytes");
        }
        resultsStream.write(buffer, 0, singleReadCount);
        fragLen = RPCPacket.fragLenFromRPCHeader(buffer);
        readLimit = fragLen - (totalReadCount += singleReadCount);
        log.debug("Read header: " + Integer.toString(totalReadCount) + " bytes, total size: " + Integer.toString(fragLen));
        while ((singleReadCount = is.read(buffer, 0, readLimit > buffer.length ? buffer.length : readLimit)) > -1) {
            resultsStream.write(buffer, 0, singleReadCount);
            readLimit = fragLen - (totalReadCount += singleReadCount);
            log.debug("Read body: " + Integer.toString(totalReadCount) + "/" + Integer.toString(fragLen) + " bytes");
            if (totalReadCount < fragLen) continue;
            break;
        }
        return resultsStream.toByteArray();
    }

    public void write(OutputStream os, String paramsdata) {
        String stubData;
        String callParams;
        int pos = paramsdata.indexOf(10);
        if (pos < 0) {
            callParams = paramsdata;
            stubData = "";
        } else {
            stubData = paramsdata.substring(pos);
            callParams = paramsdata.substring(0, pos);
        }
        this.setReadParams(callParams);
        RPCPacket[] callReq = DCERPCSamplerUtils.getRequestsArrayByString(callParams, stubData);
        for (int packetNum = 0; packetNum < callReq.length; ++packetNum) {
            byte[] reqBytes = callReq[packetNum].getBytes();
            log.debug("Bytes to send: " + Integer.toString(reqBytes.length));
            try {
                os.write(reqBytes);
                continue;
            }
            catch (IOException ex) {
                log.error("Request error", (Throwable)ex);
            }
        }
    }

    private void setReadParams(String callParams) {
        String[] fields = callParams.split("[\t ]");
        if (fields.length > 2) {
            this.unmarshalOptions = fields[2];
        }
    }
}

