/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.util.JMeterUtils;

public class SteppingThreadGroup
extends AbstractThreadGroup {
    public static final String THREAD_GROUP_DELAY = "Threads initial delay";
    public static final String INC_USER_PERIOD = "Start users period";
    public static final String INC_USER_COUNT = "Start users count";
    public static final String DEC_USER_PERIOD = "Stop users period";
    public static final String DEC_USER_COUNT = "Stop users count";
    public static final String FLIGHT_TIME = "flighttime";

    public void scheduleThread(JMeterThread thread) {
        int additionalRampUp = 0;
        String rampupProperty = JMeterUtils.getProperty((String)"steppingthreadgroup.additionalrampup");
        if (rampupProperty != null) {
            additionalRampUp = Integer.parseInt(rampupProperty);
        }
        int threadGroupDelay = this.getThreadGroupDelay();
        int inUserPeriod = this.getInUserPeriod();
        int inUserCount = this.getInUserCount();
        int flightTime = this.getFlightTime();
        int outUserPeriod = this.getOutUserPeriod();
        int outUserCount = this.getOutUserCount();
        long ascentPoint = System.currentTimeMillis() + (long)(1000 * threadGroupDelay);
        long descentPoint = ascentPoint + (long)(1000 * inUserPeriod * (int)Math.floor((double)this.getNumThreads() / (double)inUserCount)) + (long)(1000 * flightTime);
        thread.setStartTime(ascentPoint + (long)(1000 * inUserPeriod * (int)Math.floor((double)thread.getThreadNum() / (double)inUserCount)) + (long)(additionalRampUp * thread.getThreadNum()));
        thread.setEndTime(descentPoint + (long)(1000 * outUserPeriod * (int)Math.floor((double)thread.getThreadNum() / (double)outUserCount)));
        thread.setScheduled(true);
    }

    public int getThreadGroupDelay() {
        return this.getPropertyAsInt(THREAD_GROUP_DELAY, 0);
    }

    public int getInUserPeriod() {
        return this.getPropertyAsInt(INC_USER_PERIOD, 0);
    }

    public int getInUserCount() {
        return this.getPropertyAsInt(INC_USER_COUNT, 1);
    }

    public int getFlightTime() {
        return this.getPropertyAsInt(FLIGHT_TIME, 0);
    }

    public int getOutUserPeriod() {
        return this.getPropertyAsInt(DEC_USER_PERIOD, 0);
    }

    public int getOutUserCount() {
        return this.getPropertyAsInt(DEC_USER_COUNT, 1);
    }
}

