/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import kg.apc.jmeter.charting.AbstractGraphPanelChartElement;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphPanelChart;
import kg.apc.jmeter.charting.GraphRowSumValues;
import kg.apc.jmeter.threads.UltimateThreadGroup;
import kg.apc.jmeter.vizualizers.DateTimeRenderer;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UltimateThreadGroupGui
extends AbstractThreadGroupGui
implements TableModelListener,
CellEditorListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected ConcurrentHashMap<String, AbstractGraphRow> model;
    private GraphPanelChart chart;
    public static final String[] columnIdentifiers = new String[]{"Start Threads Count", "Initial Delay, sec", "Startup Time, sec", "Hold Load For, sec", "Shutdown Time"};
    public static final Class[] columnClasses = new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class};
    private static Integer[] defaultValues = new Integer[]{100, 0, 30, 60, 10};
    private LoopControlPanel loopPanel;
    private PowerTableModel tableModel;
    JTable grid;
    JButton addRowButton;
    JButton deleteRowButton;

    public UltimateThreadGroupGui() {
        this.init();
    }

    protected final void init() {
        VerticalPanel containerPanel = new VerticalPanel();
        containerPanel.add((Component)this.createParamsPanel(), "North");
        containerPanel.add(this.createChart(), "Center");
        this.add((Component)containerPanel, "Center");
        this.createControllerPanel();
    }

    private void calculateRowMaxY(GraphRowSumValues row) {
        double max = Double.MIN_VALUE;
        Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> it = row.iterator();
        while (it.hasNext()) {
            double el = it.next().getValue().getValue();
            if (!(el > max)) continue;
            max = el;
        }
        row.setMaxY(max);
    }

    private JPanel createParamsPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createTitledBorder("Threads Schedule"));
        panel.setPreferredSize(new Dimension(200, 200));
        JScrollPane scroll = new JScrollPane(this.createGrid());
        scroll.setPreferredSize(scroll.getMinimumSize());
        panel.add((Component)scroll, "Center");
        panel.add(this.createButtons(), "South");
        return panel;
    }

    private JTable createGrid() {
        this.grid = new JTable();
        this.grid.getDefaultEditor(Integer.class).addCellEditorListener(this);
        this.createTableModel();
        this.grid.setSelectionMode(0);
        this.grid.setMinimumSize(new Dimension(200, 100));
        return this.grid;
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Ultimate Thread Group";
    }

    public TestElement createTestElement() {
        UltimateThreadGroup tg = new UltimateThreadGroup();
        this.modifyTestElement((TestElement)tg);
        return tg;
    }

    public void modifyTestElement(TestElement tg) {
        if (this.grid.isEditing()) {
            this.grid.getCellEditor().stopCellEditing();
        }
        if (tg instanceof UltimateThreadGroup) {
            UltimateThreadGroup utg = (UltimateThreadGroup)tg;
            CollectionProperty rows = UltimateThreadGroup.tableModelToCollectionProperty(this.tableModel);
            utg.setData(rows);
            this.updateChart(utg);
            utg.setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
        super.configureTestElement(tg);
    }

    public void configure(TestElement tg) {
        super.configure(tg);
        this.createTableModel();
        UltimateThreadGroup utg = (UltimateThreadGroup)tg;
        JMeterProperty threadValues = utg.getData();
        if (!(threadValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)threadValues;
            PropertyIterator iter = columns.iterator();
            int count = 0;
            while (iter.hasNext()) {
                List list = (List)iter.next().getObjectValue();
                this.tableModel.setColumnData(count, list);
                ++count;
            }
            this.updateChart(utg);
        } else {
            log.warn("Received null property instead of collection");
        }
        TestElement te = (TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue();
        if (te != null) {
            this.loopPanel.configure(te);
        }
    }

    private void updateChart(UltimateThreadGroup tg) {
        int n;
        this.model.clear();
        GraphRowSumValues row = new GraphRowSumValues();
        row.setColor(Color.RED);
        row.setDrawLine(true);
        row.setMarkerSize(0);
        row.setDrawThickLines(true);
        HashTree hashTree = new HashTree();
        hashTree.add((Object)new LoopController());
        JMeterThread thread = new JMeterThread(hashTree, null, null);
        int numThreads = tg.getNumThreads();
        for (n = 0; n < numThreads; ++n) {
            thread.setThreadNum(n);
            tg.scheduleThread(thread);
            row.add(thread.getStartTime() - 1L, 0.0);
            row.add(thread.getStartTime(), 1.0);
        }
        for (n = 0; n < tg.getNumThreads(); ++n) {
            thread.setThreadNum(n);
            tg.scheduleThread(thread);
            row.add(thread.getEndTime() - 1L, 0.0);
            row.add(thread.getEndTime(), -1.0);
        }
        this.calculateRowMaxY(row);
        this.model.put("Expected parallel users count", row);
        this.chart.repaint();
    }

    private JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(-1);
        looper.setContinueForever(true);
        this.loopPanel.configure((TestElement)looper);
        return this.loopPanel;
    }

    private Component createChart() {
        this.chart = new GraphPanelChart();
        this.model = new ConcurrentHashMap();
        this.chart.setRows(this.model);
        this.chart.setDrawFinalZeroingLines(true);
        this.chart.setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        return this.chart;
    }

    private Component createButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2));
        this.addRowButton = new JButton("Add Row");
        this.deleteRowButton = new JButton("Delete Row");
        buttonPanel.add(this.addRowButton);
        buttonPanel.add(this.deleteRowButton);
        this.addRowButton.addActionListener(new AddRowAction());
        this.deleteRowButton.addActionListener(new DeleteRowAction());
        return buttonPanel;
    }

    public void tableChanged(TableModelEvent e) {
        this.updateChart();
    }

    private void createTableModel() {
        this.tableModel = new PowerTableModel(columnIdentifiers, columnClasses);
        this.tableModel.addTableModelListener((TableModelListener)this);
        this.grid.setModel((TableModel)this.tableModel);
    }

    public void editingStopped(ChangeEvent e) {
        this.updateChart();
    }

    public void editingCanceled(ChangeEvent e) {
    }

    private void updateChart() {
        GuiPackage.getInstance().updateCurrentGui();
    }

    public void clearGui() {
        this.tableModel.clearData();
    }

    private class DeleteRowAction
    implements ActionListener {
        private DeleteRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int rowSelected;
            if (UltimateThreadGroupGui.this.grid.isEditing()) {
                TableCellEditor cellEditor = UltimateThreadGroupGui.this.grid.getCellEditor(UltimateThreadGroupGui.this.grid.getEditingRow(), UltimateThreadGroupGui.this.grid.getEditingColumn());
                cellEditor.cancelCellEditing();
            }
            if ((rowSelected = UltimateThreadGroupGui.this.grid.getSelectedRow()) >= 0) {
                UltimateThreadGroupGui.this.tableModel.removeRow(rowSelected);
                UltimateThreadGroupGui.this.tableModel.fireTableDataChanged();
                if (UltimateThreadGroupGui.this.tableModel.getRowCount() == 0) {
                    UltimateThreadGroupGui.this.deleteRowButton.setEnabled(false);
                } else {
                    int rowToSelect = rowSelected;
                    if (rowSelected >= UltimateThreadGroupGui.this.tableModel.getRowCount()) {
                        rowToSelect = rowSelected - 1;
                    }
                    UltimateThreadGroupGui.this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
            }
        }
    }

    private class AddRowAction
    implements ActionListener {
        private AddRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (UltimateThreadGroupGui.this.grid.isEditing()) {
                TableCellEditor cellEditor = UltimateThreadGroupGui.this.grid.getCellEditor(UltimateThreadGroupGui.this.grid.getEditingRow(), UltimateThreadGroupGui.this.grid.getEditingColumn());
                cellEditor.stopCellEditing();
            }
            UltimateThreadGroupGui.this.tableModel.addRow((Object[])defaultValues);
            UltimateThreadGroupGui.this.tableModel.fireTableDataChanged();
            UltimateThreadGroupGui.this.deleteRowButton.setEnabled(true);
            int rowToSelect = UltimateThreadGroupGui.this.tableModel.getRowCount() - 1;
            UltimateThreadGroupGui.this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }
}

