/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.concurrent.ConcurrentSkipListMap;
import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphPanelChart;
import kg.apc.jmeter.vizualizers.ColorsDispatcher;
import kg.apc.jmeter.vizualizers.GraphPanel;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import kg.apc.jmeter.vizualizers.SettingsInterface;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractGraphPanelVisualizer
extends AbstractVisualizer
implements Clearable,
GraphListener,
ImageVisualizer,
SettingsInterface {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected ConcurrentSkipListMap<String, AbstractGraphRow> model = new ConcurrentSkipListMap();
    protected long lastRepaint = 0L;
    private int interval = 500;
    protected GraphPanel graphPanel;
    protected ColorsDispatcher colors = new ColorsDispatcher();
    private static final long REPAINT_INTERVAL = 500L;
    public static final String INTERVAL_PROPERTY = "interval_grouping";
    private JSettingsPanel settingsPanel = null;

    public AbstractGraphPanelVisualizer() {
        this.initGui();
    }

    protected abstract JSettingsPanel getSettingsPanel();

    private void initGui() {
        this.setLayout(new BorderLayout());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.createGraphPanel(), "Center");
        this.settingsPanel = this.getSettingsPanel();
        this.graphPanel.getSettingsTab().add((Component)this.settingsPanel, "Center");
    }

    protected GraphPanel createGraphPanel() {
        this.graphPanel = new GraphPanel();
        this.graphPanel.getGraphObject().setRows(this.model);
        return this.graphPanel;
    }

    public void updateGui(Sample sample) {
        long time = System.currentTimeMillis();
        if (time - this.lastRepaint >= 500L) {
            this.updateGui();
            this.repaint();
            this.lastRepaint = time;
        }
    }

    public void updateGui() {
        this.graphPanel.updateGui();
    }

    public void clearData() {
        this.model.clear();
        this.colors.reset();
        this.graphPanel.clearRowsTab();
        this.updateGui();
        this.repaint();
    }

    public Image getImage() {
        return this.graphPanel.getGraphImage();
    }

    public int getGranulation() {
        return this.interval;
    }

    public void setGranulation(int granulation) {
        if (granulation < 1) {
            throw new IllegalArgumentException("Interval cannot be less than 1");
        }
        this.interval = granulation;
        this.settingsPanel.setGranulationValue(granulation);
    }

    public TestElement createTestElement() {
        TestElement el = super.createTestElement();
        return el;
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        c.setProperty((JMeterProperty)new LongProperty(INTERVAL_PROPERTY, (long)this.interval));
    }

    public void configure(TestElement el) {
        super.configure(el);
        int intervalProp = el.getPropertyAsInt(INTERVAL_PROPERTY);
        if (intervalProp > 0) {
            this.setGranulation(intervalProp);
        }
    }

    public GraphPanelChart getGraphPanelChart() {
        return this.graphPanel.getGraphObject();
    }
}

