/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import kg.apc.jmeter.vizualizers.SettingsInterface;

public class JSettingsPanel
extends JPanel {
    private SettingsInterface parent = null;
    private int originalTooltipDisplayTime = 0;
    private JCheckBox jCheckBoxDrawCurrentX;
    private JCheckBox jCheckBoxDrawFinalZeroingLines;
    private JCheckBox jCheckBoxMaxPoints;
    private JCheckBox jCheckBoxPaintGradient;
    private JComboBox jComboBoxGranulation;
    private JComboBox jComboBoxMaxPoints;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelInfoGrpValues;
    private JLabel jLabelInfoMaxPoint;
    private JLabel jLabelMaxPoints;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelTimeLine;

    public JSettingsPanel(SettingsInterface parent, boolean showTimelinePanel, boolean showGradientOption, boolean showCurrentXOption, boolean showFinalZeroingLinesOption, boolean showLimitPointOption) {
        this.initComponents();
        this.parent = parent;
        this.jPanelTimeLine.setVisible(showTimelinePanel);
        this.jCheckBoxPaintGradient.setVisible(showGradientOption);
        this.jCheckBoxDrawCurrentX.setVisible(showCurrentXOption);
        this.jCheckBoxDrawFinalZeroingLines.setVisible(showFinalZeroingLinesOption);
        this.jCheckBoxMaxPoints.setVisible(showLimitPointOption);
        this.jComboBoxMaxPoints.setVisible(showLimitPointOption);
        this.jLabelMaxPoints.setVisible(showLimitPointOption);
        this.jLabelInfoMaxPoint.setVisible(showLimitPointOption);
        this.originalTooltipDisplayTime = ToolTipManager.sharedInstance().getDismissDelay();
        this.jCheckBoxPaintGradient.setSelected(parent.getGraphPanelChart().isSettingsDrawGradient());
        this.jCheckBoxDrawCurrentX.setSelected(parent.getGraphPanelChart().isSettingsDrawCurrentX());
        if (showFinalZeroingLinesOption) {
            this.jCheckBoxDrawFinalZeroingLines.setSelected(parent.getGraphPanelChart().isSettingsDrawFinalZeroingLines());
        } else {
            parent.getGraphPanelChart().setSettingsDrawFinalZeroingLines(false);
        }
    }

    private int getValueFromString(String sValue) {
        int ret;
        try {
            ret = Integer.valueOf(sValue);
            if (ret <= 0) {
                ret = -1;
            }
        }
        catch (NumberFormatException ex) {
            ret = -1;
        }
        return ret;
    }

    public void setGranulationValue(int value) {
        this.jComboBoxGranulation.setSelectedItem(Integer.toString(value));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jPanelTimeLine = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jComboBoxGranulation = new JComboBox();
        this.jLabelInfoGrpValues = new JLabel();
        this.jPanel5 = new JPanel();
        this.jCheckBoxPaintGradient = new JCheckBox();
        this.jCheckBoxDrawFinalZeroingLines = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jCheckBoxDrawCurrentX = new JCheckBox();
        this.jCheckBoxMaxPoints = new JCheckBox();
        this.jLabelMaxPoints = new JLabel();
        this.jComboBoxMaxPoints = new JComboBox();
        this.jLabelInfoMaxPoint = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/logoSimple.png")));
        this.jPanel1.add(this.jLabel1);
        this.add((Component)this.jPanel1, "Last");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanelTimeLine.setBorder(BorderFactory.createTitledBorder("Timeline Settings"));
        this.jPanelTimeLine.setLayout(new GridBagLayout());
        this.jLabel2.setText("Group values for:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelTimeLine.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelTimeLine.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelTimeLine.add((Component)this.jPanel4, gridBagConstraints);
        this.jComboBoxGranulation.setEditable(true);
        this.jComboBoxGranulation.setModel(new DefaultComboBoxModel<String>(new String[]{"500", "1000", "2000", "5000", "10000", "30000", "60000"}));
        this.jComboBoxGranulation.setPreferredSize(new Dimension(80, 20));
        this.jComboBoxGranulation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxGranulationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelTimeLine.add((Component)this.jComboBoxGranulation, gridBagConstraints);
        this.jLabelInfoGrpValues.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/information.png")));
        this.jLabelInfoGrpValues.setToolTipText("<html>You can specify here the duration used internally<br>\nby the plugin to combine the values received during<br>\nthe test. This will result in <b>more readable graphs</b> and<br>\n<b>less resources needs</b>. It <b>cannot be undo</b>.<br>\nThis parameter is saved with the test plan.");
        this.jLabelInfoGrpValues.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanelTimeLine.add((Component)this.jLabelInfoGrpValues, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanelTimeLine, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Rendering Options"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.jCheckBoxPaintGradient.setText("Paint gradient");
        this.jCheckBoxPaintGradient.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxPaintGradientActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jCheckBoxPaintGradient, gridBagConstraints);
        this.jCheckBoxDrawFinalZeroingLines.setText("Draw final zeroing lines");
        this.jCheckBoxDrawFinalZeroingLines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxDrawFinalZeroingLinesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jCheckBoxDrawFinalZeroingLines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jCheckBoxDrawCurrentX.setText("Draw current X line");
        this.jCheckBoxDrawCurrentX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxDrawCurrentXActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jCheckBoxDrawCurrentX, gridBagConstraints);
        this.jCheckBoxMaxPoints.setText("Limit number of points in row to");
        this.jCheckBoxMaxPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jCheckBoxMaxPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel5.add((Component)this.jCheckBoxMaxPoints, gridBagConstraints);
        this.jLabelMaxPoints.setText("points");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel5.add((Component)this.jLabelMaxPoints, gridBagConstraints);
        this.jComboBoxMaxPoints.setEditable(true);
        this.jComboBoxMaxPoints.setModel(new DefaultComboBoxModel<String>(new String[]{"20", "50", "100", "150", "200"}));
        this.jComboBoxMaxPoints.setSelectedIndex(1);
        this.jComboBoxMaxPoints.setPreferredSize(new Dimension(50, 20));
        this.jComboBoxMaxPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSettingsPanel.this.jComboBoxMaxPointsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel5.add((Component)this.jComboBoxMaxPoints, gridBagConstraints);
        this.jLabelInfoMaxPoint.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/vizualizers/information.png")));
        this.jLabelInfoMaxPoint.setToolTipText("<html>This option will <b>dynamically</b> adjust the graph<br>\nrendering so it is <b>more readable</b>. It <b>can be undo</b>.<br>\nThis parameter is not saved with the test plan.<br>");
        this.jLabelInfoMaxPoint.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                JSettingsPanel.this.infoLabelMouseExited(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel5.add((Component)this.jLabelInfoMaxPoint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.add((Component)this.jPanel2, "Center");
    }

    private void jComboBoxGranulationActionPerformed(ActionEvent evt) {
        int newValue = this.getValueFromString((String)this.jComboBoxGranulation.getSelectedItem());
        if (newValue != -1 && this.parent.getGranulation() != newValue) {
            this.parent.setGranulation(newValue);
        }
    }

    private void jCheckBoxPaintGradientActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().setSettingsDrawGradient(this.jCheckBoxPaintGradient.isSelected());
    }

    private void jCheckBoxDrawFinalZeroingLinesActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().setSettingsDrawFinalZeroingLines(this.jCheckBoxDrawFinalZeroingLines.isSelected());
    }

    private void jCheckBoxDrawCurrentXActionPerformed(ActionEvent evt) {
        this.parent.getGraphPanelChart().setSettingsDrawCurrentX(this.jCheckBoxDrawCurrentX.isSelected());
    }

    private void jCheckBoxMaxPointsActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMaxPoints.isSelected()) {
            this.parent.getGraphPanelChart().setMaxPoints(this.getValueFromString((String)this.jComboBoxMaxPoints.getSelectedItem()));
        } else {
            this.parent.getGraphPanelChart().setMaxPoints(-1);
        }
    }

    private void jComboBoxMaxPointsActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxMaxPoints.isSelected()) {
            this.parent.getGraphPanelChart().setMaxPoints(this.getValueFromString((String)this.jComboBoxMaxPoints.getSelectedItem()));
        }
    }

    private void infoLabelMouseEntered(MouseEvent evt) {
        ToolTipManager.sharedInstance().setDismissDelay(60000);
    }

    private void infoLabelMouseExited(MouseEvent evt) {
        ToolTipManager.sharedInstance().setDismissDelay(this.originalTooltipDisplayTime);
    }
}

