/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.jmeter.charting.AbstractGraphRow;
import kg.apc.jmeter.charting.GraphRowAverages;
import kg.apc.jmeter.vizualizers.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.DateTimeRenderer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class ThroughputOverTimeGui
extends AbstractGraphPanelVisualizer {
    public ThroughputOverTimeGui() {
        this.graphPanel.getGraphObject().setxAxisLabelRenderer(new DateTimeRenderer("HH:mm:ss"));
        this.graphPanel.getGraphObject().setDrawFinalZeroingLines(true);
    }

    private synchronized AbstractGraphRow getNewRow(String label) {
        AbstractGraphRow row = null;
        if (!this.model.containsKey(label)) {
            row = new GraphRowAverages();
            row.setLabel(label);
            row.setColor(this.colors.getNextColor());
            row.setDrawLine(true);
            row.setMarkerSize(2);
            this.model.put(label, row);
            this.graphPanel.addRow(row);
        } else {
            row = (AbstractGraphRow)this.model.get(label);
        }
        return row;
    }

    private void addThreadGroupRecord(String threadGroupName, long time, double rTime) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(threadGroupName);
        }
        row.add(time, rTime);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Transaction Throughput Over Time";
    }

    public void add(SampleResult res) {
        double val = res.getTime() == 0L ? 0.0 : 1000.0 * (double)res.getAllThreads() / (double)res.getTime();
        this.addThreadGroupRecord(res.getSampleLabel(), res.getEndTime() - res.getEndTime() % (long)this.getGranulation(), val);
        this.updateGui(null);
    }

    protected JSettingsPanel getSettingsPanel() {
        return new JSettingsPanel(this, true, true, false, true, true);
    }
}

