/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import java.text.DecimalFormatSymbols;
import kg.apc.jmeter.charting.GraphRowAverages;
import kg.apc.jmeter.charting.GraphRowOverallAverages;
import kg.apc.jmeter.vizualizers.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.RateRenderer;

public class ThroughputVsThreadsGui
extends AbstractGraphPanelVisualizer {
    public ThroughputVsThreadsGui() {
        this.graphPanel.getGraphObject().setDrawCurrentX(true);
        this.graphPanel.getGraphObject().setyAxisLabelRenderer((NumberRenderer)new CustomRateRenderer("#.0"));
        this.graphPanel.getGraphObject().setForcedMinX(0);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Transaction Throughput vs Threads";
    }

    public void add(SampleResult res) {
        GraphRowOverallAverages avgRow;
        GraphRowAverages row;
        long time = res.getTime();
        if (time < 1L) {
            return;
        }
        String label = res.getSampleLabel();
        String averageLabel = "Average " + res.getSampleLabel();
        if (!this.model.containsKey(label) || !this.model.containsKey(averageLabel)) {
            row = this.getNewRow(label);
            avgRow = this.getNewAveragesRow(averageLabel, row.getColor());
        } else {
            row = (GraphRowAverages)this.model.get(label);
            avgRow = (GraphRowOverallAverages)this.model.get(averageLabel);
        }
        int allThreads = res.getAllThreads();
        double throughput = (double)allThreads * 1000.0 / (double)time;
        row.add(allThreads, throughput);
        avgRow.add(allThreads, throughput);
        this.graphPanel.getGraphObject().setCurrentX(allThreads);
        this.updateGui(null);
    }

    private synchronized GraphRowOverallAverages getNewAveragesRow(String averageLabel, Color color) {
        GraphRowOverallAverages avgRow = null;
        if (!this.model.containsKey(averageLabel)) {
            avgRow = new GraphRowOverallAverages();
            avgRow.setLabel(averageLabel);
            avgRow.setColor(color);
            avgRow.setMarkerSize(4);
            avgRow.setDrawValueLabel(true);
            avgRow.setShowInLegend(false);
            this.model.put(averageLabel, avgRow);
            this.graphPanel.addRow(avgRow);
        } else {
            avgRow = (GraphRowOverallAverages)this.model.get(averageLabel);
        }
        return avgRow;
    }

    private synchronized GraphRowAverages getNewRow(String label) {
        GraphRowAverages row = null;
        if (!this.model.containsKey(label)) {
            row = new GraphRowAverages();
            row.setLabel(label);
            row.setColor(this.colors.getNextColor());
            row.setDrawLine(true);
            row.setMarkerSize(2);
            this.model.put(label, row);
            this.graphPanel.addRow(row);
        } else {
            row = (GraphRowAverages)this.model.get(label);
        }
        return row;
    }

    protected JSettingsPanel getSettingsPanel() {
        return new JSettingsPanel(this, false, true, true, false, false);
    }

    private class CustomRateRenderer
    extends RateRenderer {
        private String zeroLabel;

        public CustomRateRenderer(String format) {
            super(format);
            this.zeroLabel = "0" + new DecimalFormatSymbols().getDecimalSeparator() + "0/sec";
        }

        public void setValue(Object value) {
            if (value != null && value instanceof Double && (Double)value == 0.0) {
                this.setText(this.zeroLabel);
            } else {
                super.setValue(value);
            }
        }
    }
}

