/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTableModel
extends DefaultTableModel {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private transient ArrayList<Object> objects = new ArrayList();
    private transient List<String> headers = new ArrayList<String>();
    private transient ArrayList<Class<?>> classes = new ArrayList();
    private transient ArrayList<Functor> readFunctors = new ArrayList();
    private transient ArrayList<Functor> writeFunctors = new ArrayList();
    private transient Class<?> objectClass = null;
    private transient boolean cellEditable = true;

    public ObjectTableModel(String[] headers, Class<?> _objClass, Functor[] readFunctors, Functor[] writeFunctors, Class<?>[] editorClasses) {
        this(headers, readFunctors, writeFunctors, editorClasses);
        this.objectClass = _objClass;
    }

    public ObjectTableModel(String[] headers, Class<?> _objClass, Functor[] readFunctors, Functor[] writeFunctors, Class<?>[] editorClasses, boolean cellEditable) {
        this(headers, readFunctors, writeFunctors, editorClasses);
        this.objectClass = _objClass;
        this.cellEditable = cellEditable;
    }

    public ObjectTableModel(String[] headers, Functor[] readFunctors, Functor[] writeFunctors, Class<?>[] editorClasses) {
        int numRead;
        int numWrite;
        this.headers.addAll(Arrays.asList(headers));
        this.classes.addAll(Arrays.asList(editorClasses));
        this.readFunctors = new ArrayList<Functor>(Arrays.asList(readFunctors));
        this.writeFunctors = new ArrayList<Functor>(Arrays.asList(writeFunctors));
        int numHeaders = headers.length;
        int numClasses = this.classes.size();
        if (numClasses != numHeaders) {
            log.warn("Header count=" + numHeaders + " but classes count=" + numClasses);
        }
        if ((numWrite = writeFunctors.length) > 0 && numWrite != numHeaders) {
            log.warn("Header count=" + numHeaders + " but writeFunctor count=" + numWrite);
        }
        if ((numRead = readFunctors.length) > 0 && numRead != numHeaders) {
            log.warn("Header count=" + numHeaders + " but readFunctor count=" + numRead);
        }
    }

    private Object readResolve() {
        this.objects = new ArrayList();
        this.headers = new ArrayList<String>();
        this.classes = new ArrayList();
        this.readFunctors = new ArrayList();
        this.writeFunctors = new ArrayList();
        return this;
    }

    public Iterator<?> iterator() {
        return this.objects.iterator();
    }

    public void clearData() {
        int size = this.getRowCount();
        this.objects.clear();
        super.fireTableRowsDeleted(0, size);
    }

    public void addRow(Object value) {
        Class<?> valueClass;
        log.debug("Adding row value: " + value);
        if (this.objectClass != null && !this.objectClass.isAssignableFrom(valueClass = value.getClass())) {
            throw new IllegalArgumentException("Trying to add class: " + valueClass.getName() + "; expecting class: " + this.objectClass.getName());
        }
        this.objects.add(value);
        super.fireTableRowsInserted(this.objects.size() - 1, this.objects.size());
    }

    public void insertRow(Object value, int index) {
        this.objects.add(index, value);
        super.fireTableRowsInserted(index, index + 1);
    }

    @Override
    public int getColumnCount() {
        return this.headers.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.headers.get(col);
    }

    @Override
    public int getRowCount() {
        if (this.objects == null) {
            return 0;
        }
        return this.objects.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        log.debug("Getting row value");
        Object value = this.objects.get(row);
        if (this.headers.size() == 1 && col >= this.readFunctors.size()) {
            return value;
        }
        Functor getMethod = this.readFunctors.get(col);
        if (getMethod != null && value != null) {
            return getMethod.invoke(value);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return this.cellEditable;
    }

    @Override
    public void moveRow(int start, int end, int to) {
        ArrayList<Object> subList = new ArrayList<Object>(this.objects.subList(start, end));
        for (int x = end - 1; x >= start; --x) {
            this.objects.remove(x);
        }
        this.objects.addAll(to, subList);
        super.fireTableChanged(new TableModelEvent(this));
    }

    @Override
    public void removeRow(int row) {
        this.objects.remove(row);
        super.fireTableRowsDeleted(row, row);
    }

    @Override
    public void setValueAt(Object cellValue, int row, int col) {
        if (row < this.objects.size()) {
            Object value = this.objects.get(row);
            if (col < this.writeFunctors.size()) {
                Functor setMethod = this.writeFunctors.get(col);
                if (setMethod != null) {
                    setMethod.invoke(value, new Object[]{cellValue});
                    super.fireTableDataChanged();
                }
            } else if (this.headers.size() == 1) {
                this.objects.set(row, cellValue);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return this.classes.get(arg0);
    }

    public boolean checkFunctors(Object _value, Class<?> caller) {
        Object value;
        if (_value == null && this.objectClass != null) {
            try {
                value = this.objectClass.newInstance();
            }
            catch (InstantiationException e) {
                log.error("Cannot create instance of class " + this.objectClass.getName(), (Throwable)e);
                return false;
            }
            catch (IllegalAccessException e) {
                log.error("Cannot create instance of class " + this.objectClass.getName(), (Throwable)e);
                return false;
            }
        } else {
            value = _value;
        }
        boolean status = true;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Functor getMethod;
            Functor setMethod = this.writeFunctors.get(i);
            if (setMethod != null && !setMethod.checkMethod(value, this.getColumnClass(i))) {
                status = false;
                log.warn(caller.getName() + " is attempting to use nonexistent " + setMethod.toString());
            }
            if ((getMethod = this.readFunctors.get(i)) == null || getMethod.checkMethod(value)) continue;
            status = false;
            log.warn(caller.getName() + " is attempting to use nonexistent " + getMethod.toString());
        }
        return status;
    }

    public Object getObjectList() {
        return this.objects;
    }

    public void setRows(Iterable<?> rows) {
        this.clearData();
        for (Object val : rows) {
            this.addRow(val);
        }
    }
}

