/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.xml.bind.DatatypeConverter;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.ReaderHandler;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.converter.EnumConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.JohnzonCollectionType;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;
import org.apache.johnzon.mapper.reflection.Mappings;

public class Mapper
implements Closeable {
    private static final Adapter<Object, String> FALLBACK_CONVERTER = new ConverterAdapter<Object>(new FallbackConverter());
    private static final JohnzonParameterizedType ANY_LIST = new JohnzonParameterizedType((Type)((Object)List.class), new Type[]{Object.class});
    protected final Mappings mappings;
    protected final JsonReaderFactory readerFactory;
    protected final JsonGeneratorFactory generatorFactory;
    protected final boolean close;
    protected final ConcurrentMap<AdapterKey, Adapter<?, ?>> adapters;
    protected final ConcurrentMap<Adapter<?, ?>, AdapterKey> reverseAdaptersRegistry = new ConcurrentHashMap();
    protected final int version;
    protected final boolean skipNull;
    protected final boolean skipEmptyArray;
    protected final boolean treatByteArrayAsBase64;
    protected final boolean treatByteArrayAsBase64URL;
    protected final Charset encoding;
    protected final ReaderHandler readerHandler;
    protected final Collection<Closeable> closeables;

    public Mapper(JsonReaderFactory readerFactory, JsonGeneratorFactory generatorFactory, boolean doClose, Map<AdapterKey, Adapter<?, ?>> adapters, int version, Comparator<String> attributeOrder, boolean skipNull, boolean skipEmptyArray, AccessMode accessMode, boolean treatByteArrayAsBase64, boolean treatByteArrayAsBase64URL, Charset encoding, Collection<Closeable> closeables) {
        this.readerFactory = readerFactory;
        this.generatorFactory = generatorFactory;
        this.close = doClose;
        this.adapters = new ConcurrentHashMap(adapters);
        this.version = version;
        this.mappings = new Mappings(attributeOrder, accessMode, version, this.adapters);
        this.skipNull = skipNull;
        this.skipEmptyArray = skipEmptyArray;
        this.treatByteArrayAsBase64 = treatByteArrayAsBase64;
        this.treatByteArrayAsBase64URL = treatByteArrayAsBase64URL;
        this.encoding = encoding;
        this.readerHandler = ReaderHandler.create(readerFactory);
        this.closeables = closeables;
    }

    private static JsonGenerator writePrimitives(JsonGenerator generator, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            return generator.write(value.toString());
        }
        if (type == Long.TYPE || type == Long.class) {
            return generator.write(((Long)Long.class.cast(value)).longValue());
        }
        if (Mapper.isInt(type)) {
            return generator.write(((Number)Number.class.cast(value)).intValue());
        }
        if (Mapper.isFloat(type)) {
            double doubleValue = ((Number)Number.class.cast(value)).doubleValue();
            if (Double.isNaN(doubleValue)) {
                return generator;
            }
            return generator.write(doubleValue);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return generator.write(((Boolean)Boolean.class.cast(value)).booleanValue());
        }
        if (type == BigDecimal.class) {
            return generator.write((BigDecimal)BigDecimal.class.cast(value));
        }
        if (type == BigInteger.class) {
            return generator.write((BigInteger)BigInteger.class.cast(value));
        }
        if (type == Character.TYPE || type == Character.class) {
            return generator.write(((Character)Character.class.cast(value)).toString());
        }
        return null;
    }

    private static JsonGenerator writePrimitives(JsonGenerator generator, String key, Class<?> type, Object value) {
        if (type == String.class) {
            return generator.write(key, value.toString());
        }
        if (type == Long.TYPE || type == Long.class) {
            return generator.write(key, ((Long)Long.class.cast(value)).longValue());
        }
        if (Mapper.isInt(type)) {
            return generator.write(key, ((Number)Number.class.cast(value)).intValue());
        }
        if (Mapper.isFloat(type)) {
            double doubleValue = ((Number)Number.class.cast(value)).doubleValue();
            if (Double.isNaN(doubleValue)) {
                return generator;
            }
            return generator.write(key, doubleValue);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return generator.write(key, ((Boolean)Boolean.class.cast(value)).booleanValue());
        }
        if (type == BigDecimal.class) {
            return generator.write(key, (BigDecimal)BigDecimal.class.cast(value));
        }
        if (type == BigInteger.class) {
            return generator.write(key, (BigInteger)BigInteger.class.cast(value));
        }
        if (type == Character.TYPE || type == Character.class) {
            return generator.write(key, ((Character)Character.class.cast(value)).toString());
        }
        return generator;
    }

    private static boolean isInt(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class;
    }

    private static boolean isFloat(Class<?> type) {
        return type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class;
    }

    private static <T> Object doConvertFrom(T value, Adapter<T, Object> converter) {
        if (converter == null) {
            throw new MapperException("can't convert " + value + " to String");
        }
        return converter.from(value);
    }

    private Adapter findAdapter(Type aClass) {
        Class clazz;
        Adapter converter = (Adapter)this.adapters.get(new AdapterKey(aClass, (Type)((Object)String.class)));
        if (converter != null) {
            return converter;
        }
        if (Class.class.isInstance(aClass) && (clazz = (Class)Class.class.cast(aClass)).isEnum()) {
            ConverterAdapter enumConverter = new ConverterAdapter(new EnumConverter(clazz));
            this.adapters.putIfAbsent(new AdapterKey((Type)((Object)String.class), aClass), enumConverter);
            return enumConverter;
        }
        return null;
    }

    private Object convertTo(Type aClass, String text) {
        if (Object.class == aClass || String.class == aClass) {
            return text;
        }
        Adapter converter = this.findAdapter(aClass);
        if (converter == null) {
            this.adapters.putIfAbsent(new AdapterKey((Type)((Object)String.class), aClass), FALLBACK_CONVERTER);
            return FALLBACK_CONVERTER.to(text);
        }
        return converter.to(text);
    }

    public <T> void writeArray(Object object, OutputStream stream) {
        this.writeArray(Arrays.asList((Object[])object), stream);
    }

    public <T> void writeArray(T[] object, OutputStream stream) {
        this.writeArray(Arrays.asList(object), stream);
    }

    public <T> void writeArray(T[] object, Writer stream) {
        this.writeArray(Arrays.asList(object), stream);
    }

    public <T> void writeArray(Collection<T> object, OutputStream stream) {
        this.writeArray(object, (Writer)new OutputStreamWriter(stream, this.encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeArray(Collection<T> object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        try {
            generator = this.doWriteArray(object, generator);
        }
        finally {
            this.doCloseOrFlush(generator);
        }
    }

    private <T> JsonGenerator doWriteArray(Collection<T> object, JsonGenerator inGenerator) {
        JsonGenerator generator = inGenerator;
        if (object == null) {
            generator = generator.writeStartArray().writeEnd();
        } else {
            generator = generator.writeStartArray();
            for (T t : object) {
                if (JsonValue.class.isInstance(t)) {
                    generator = generator.write((JsonValue)JsonValue.class.cast(t));
                    continue;
                }
                generator = this.writeItem(generator, t);
            }
            generator = generator.writeEnd();
        }
        return generator;
    }

    private void doCloseOrFlush(JsonGenerator generator) {
        if (this.close) {
            generator.close();
        } else {
            generator.flush();
        }
    }

    public <T> void writeIterable(Iterable<T> object, OutputStream stream) {
        this.writeIterable(object, new OutputStreamWriter(stream, this.encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void writeIterable(Iterable<T> object, Writer stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        try {
            if (object == null) {
                generator = generator.writeStartArray().writeEnd();
            } else {
                generator.writeStartArray();
                for (T t : object) {
                    generator = this.writeItem(generator, t);
                }
                generator.writeEnd();
            }
        }
        finally {
            this.doCloseOrFlush(generator);
        }
    }

    public void writeObject(Object object, Writer stream) {
        if (JsonValue.class.isInstance(object) || String.class.isInstance(object) || Number.class.isInstance(object) || object == null) {
            try {
                stream.write(String.valueOf(object));
            }
            catch (IOException e) {
                throw new MapperException(e);
            }
            finally {
                if (this.close) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        stream.flush();
                    }
                    catch (IOException iOException) {}
                }
            }
            return;
        }
        JsonGenerator generator = this.generatorFactory.createGenerator(stream);
        this.doWriteHandlingNullObject(object, generator);
    }

    public void writeObject(Object object, OutputStream stream) {
        JsonGenerator generator = this.generatorFactory.createGenerator(stream, this.encoding);
        this.doWriteHandlingNullObject(object, generator);
    }

    public String writeArrayAsString(Collection<?> instance) {
        StringWriter writer = new StringWriter();
        this.writeArray(instance, (Writer)writer);
        return writer.toString();
    }

    public <T> String writeArrayAsString(T[] instance) {
        StringWriter writer = new StringWriter();
        this.writeArray(instance, (Writer)writer);
        return writer.toString();
    }

    public String writeObjectAsString(Object instance) {
        StringWriter writer = new StringWriter();
        this.writeObject(instance, writer);
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteHandlingNullObject(Object object, JsonGenerator generator) {
        if (object == null) {
            generator.writeStartObject().writeEnd().close();
            return;
        }
        if (JsonObject.class.isInstance(object)) {
            JsonObject jsonObject = (JsonObject)JsonObject.class.cast(object);
            generator.writeStartObject();
            for (Map.Entry value : jsonObject.entrySet()) {
                generator.write((String)value.getKey(), (JsonValue)value.getValue());
            }
            generator.writeEnd().close();
            return;
        }
        try {
            this.doWriteObject(generator, object);
        }
        finally {
            this.doCloseOrFlush(generator);
        }
    }

    private JsonGenerator doWriteObject(JsonGenerator generator, Object object) {
        try {
            JsonGenerator gen = generator;
            if (object == null) {
                return generator;
            }
            if (Map.class.isInstance(object)) {
                gen = gen.writeStartObject();
                gen = this.writeMapBody((Map)object, gen, null);
                gen = gen.writeEnd();
                return gen;
            }
            JsonGenerator jsonGenerator = Mapper.writePrimitives(generator, object);
            if (jsonGenerator != null) {
                return jsonGenerator;
            }
            Class<?> objectClass = object.getClass();
            if (objectClass.isEnum()) {
                Adapter adapter = this.findAdapter(objectClass);
                String adaptedValue = adapter.from(object).toString();
                return gen.write(adaptedValue);
            }
            gen = gen.writeStartObject();
            gen = this.doWriteObjectBody(gen, object);
            return gen.writeEnd();
        }
        catch (InvocationTargetException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
    }

    private JsonGenerator doWriteObjectBody(JsonGenerator gen, Object object) throws IllegalAccessException, InvocationTargetException {
        Class<?> objectClass = object.getClass();
        Mappings.ClassMapping classMapping = this.mappings.findOrCreateClassMapping(objectClass);
        if (classMapping == null) {
            throw new MapperException("No mapping for " + objectClass.getName());
        }
        JsonGenerator generator = gen;
        for (Map.Entry<String, Mappings.Getter> getterEntry : classMapping.getters.entrySet()) {
            Mappings.Getter getter = getterEntry.getValue();
            if (getter.version >= 0 && this.version >= getter.version) continue;
            Object value = getter.reader.read(object);
            if (JsonValue.class.isInstance(value)) {
                generator = generator.write(getterEntry.getKey(), (JsonValue)JsonValue.class.cast(value));
                continue;
            }
            if (value == null) {
                if (this.skipNull && !getter.reader.isNillable()) continue;
                gen.writeNull(getterEntry.getKey());
                continue;
            }
            Object val = getter.converter == null ? value : getter.converter.from(value);
            generator = this.writeValue(generator, val.getClass(), getter.primitive, getter.array, getter.collection, getter.map, getter.itemConverter, getterEntry.getKey(), val);
        }
        return generator;
    }

    private JsonGenerator writeMapBody(Map<?, ?> object, JsonGenerator gen, Adapter itemConverter) throws InvocationTargetException, IllegalAccessException {
        JsonGenerator generator = gen;
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value == null) {
                if (this.skipNull) continue;
                gen.writeNull(key == null ? "null" : key.toString());
                continue;
            }
            Class<?> valueClass = value.getClass();
            boolean primitive = Mappings.isPrimitive(valueClass);
            boolean clazz = this.mappings.getClassMapping(valueClass) != null;
            boolean array = clazz || primitive ? false : valueClass.isArray();
            boolean collection = clazz || primitive || array ? false : Collection.class.isAssignableFrom(valueClass);
            boolean map = clazz || primitive || array || collection ? false : Map.class.isAssignableFrom(valueClass);
            generator = this.writeValue(generator, valueClass, primitive, array, collection, map, itemConverter, key == null ? "null" : key.toString(), value);
        }
        return generator;
    }

    private JsonGenerator writeValue(JsonGenerator generator, Class<?> type, boolean primitive, boolean array, boolean collection, boolean map, Adapter itemConverter, String key, Object value) throws InvocationTargetException, IllegalAccessException {
        if (array) {
            int length = Array.getLength(value);
            if (length == 0 && this.skipEmptyArray) {
                return generator;
            }
            if (this.treatByteArrayAsBase64 && type == byte[].class) {
                String base64EncodedByteArray = DatatypeConverter.printBase64Binary((byte[])((byte[])value));
                generator.write(key, base64EncodedByteArray);
                return generator;
            }
            if (this.treatByteArrayAsBase64URL && type == byte[].class) {
                return generator.write(key, String.valueOf(((Adapter)Adapter.class.cast(this.adapters.get(new AdapterKey((Type)((Object)byte[].class), (Type)((Object)String.class))))).to(value)));
            }
            JsonGenerator gen = generator.writeStartArray(key);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                gen = this.writeItem(gen, itemConverter != null ? itemConverter.from(o) : o);
            }
            return gen.writeEnd();
        }
        if (collection) {
            JsonGenerator gen = generator.writeStartArray(key);
            for (Object o : (Collection)Collection.class.cast(value)) {
                gen = this.writeItem(gen, itemConverter != null ? itemConverter.from(o) : o);
            }
            return gen.writeEnd();
        }
        if (map) {
            JsonGenerator gen = generator.writeStartObject(key);
            gen = this.writeMapBody((Map)value, gen, itemConverter);
            return gen.writeEnd();
        }
        if (primitive) {
            return Mapper.writePrimitives(generator, key, type, value);
        }
        Adapter converter = this.findAdapter(type);
        if (converter != null) {
            Object adapted = Mapper.doConvertFrom(value, converter);
            JsonGenerator written = Mapper.writePrimitives(generator, key, adapted.getClass(), adapted);
            if (written != null) {
                return written;
            }
            return this.writeValue(generator, String.class, true, false, false, false, null, key, adapted);
        }
        return this.doWriteObjectBody(generator.writeStartObject(key), value).writeEnd();
    }

    private JsonGenerator writeItem(JsonGenerator generator, Object o) {
        JsonGenerator newGen = Mapper.writePrimitives(generator, o);
        if (newGen == null) {
            if (Collection.class.isInstance(o)) {
                newGen = this.doWriteArray((Collection)Collection.class.cast(o), generator);
            } else if (o != null && o.getClass().isArray()) {
                int length = Array.getLength(o);
                if (length > 0 || !this.skipEmptyArray) {
                    newGen = generator.writeStartArray();
                    for (int i = 0; i < length; ++i) {
                        newGen = this.writeItem(newGen, Array.get(o, i));
                    }
                    newGen = newGen.writeEnd();
                }
            } else {
                newGen = o == null ? generator.writeNull() : this.doWriteObject(generator, o);
            }
        }
        return newGen;
    }

    public <T> T readObject(String string, Type clazz) {
        return this.readObject(new StringReader(string), clazz);
    }

    public <T> T readObject(Reader stream, Type clazz) {
        return this.mapObject(clazz, this.readerFactory.createReader(stream));
    }

    public <T> T readObject(InputStream stream, Type clazz) {
        return this.mapObject(clazz, this.readerFactory.createReader(stream));
    }

    private <T> T mapObject(Type clazz, JsonReader reader) {
        try {
            Boolean bl;
            JsonValue object = this.readerHandler.read(reader);
            if (JsonStructure.class == clazz || JsonObject.class == clazz || JsonValue.class == clazz) {
                JsonValue jsonValue = object;
                return (T)jsonValue;
            }
            if (JsonObject.class.isInstance(object)) {
                Object object2 = this.buildObject(clazz, (JsonObject)JsonObject.class.cast(object));
                return (T)object2;
            }
            if (JsonString.class.isInstance(object) && clazz == String.class) {
                String string = ((JsonString)JsonString.class.cast(object)).getString();
                return (T)string;
            }
            if (JsonNumber.class.isInstance(object)) {
                JsonNumber number = (JsonNumber)JsonNumber.class.cast(object);
                if (clazz == Integer.TYPE || clazz == Integer.class) {
                    Integer n = number.intValue();
                    return (T)n;
                }
                if (clazz == Long.TYPE || clazz == Long.class) {
                    Long l = number.longValue();
                    return (T)l;
                }
                if (clazz == Double.TYPE || clazz == Double.class) {
                    Double d = number.doubleValue();
                    return (T)d;
                }
                if (clazz == BigDecimal.class) {
                    BigDecimal bigDecimal = number.bigDecimalValue();
                    return (T)bigDecimal;
                }
                if (clazz == BigInteger.class) {
                    BigInteger bigInteger = number.bigIntegerValue();
                    return (T)bigInteger;
                }
            }
            if (JsonValue.NULL == object) {
                bl = null;
                return (T)bl;
            }
            if (JsonValue.TRUE == object && (Boolean.class == clazz || Boolean.TYPE == clazz)) {
                bl = Boolean.TRUE;
                return (T)bl;
            }
            if (JsonValue.FALSE == object && (Boolean.class == clazz || Boolean.TYPE == clazz)) {
                bl = Boolean.FALSE;
                return (T)bl;
            }
            try {
                throw new IllegalArgumentException("Unsupported " + object + " for type " + clazz);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    public <T> Collection<T> readCollection(InputStream stream, ParameterizedType genericType) {
        JsonReader reader = this.readerFactory.createReader(stream);
        Mappings.CollectionMapping mapping = this.mappings.findCollectionMapping(genericType);
        if (mapping == null) {
            throw new UnsupportedOperationException("type " + genericType + " not supported");
        }
        try {
            Collection<T> collection = this.mapCollection(mapping, reader.readArray(), null);
            return collection;
        }
        catch (Exception e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    public <T> T readJohnzonCollection(InputStream stream, JohnzonCollectionType<T> genericType) {
        return (T)this.readCollection(stream, genericType);
    }

    public <T> T readJohnzonCollection(Reader stream, JohnzonCollectionType<T> genericType) {
        return (T)this.readCollection(stream, genericType);
    }

    public <T> Collection<T> readCollection(Reader stream, ParameterizedType genericType) {
        JsonReader reader = this.readerFactory.createReader(stream);
        Mappings.CollectionMapping mapping = this.mappings.findCollectionMapping(genericType);
        if (mapping == null) {
            throw new UnsupportedOperationException("type " + genericType + " not supported");
        }
        try {
            Collection<T> collection = this.mapCollection(mapping, reader.readArray(), null);
            return collection;
        }
        catch (Exception e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    public <T> T[] readArray(Reader stream, Class<T> clazz) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return (Object[])this.mapArray(clazz, reader);
    }

    public <T> T readTypedArray(InputStream stream, Class<?> elementType, Class<T> arrayType) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return arrayType.cast(this.mapArray(elementType, reader));
    }

    public <T> T readTypedArray(Reader stream, Class<?> elementType, Class<T> arrayType) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return arrayType.cast(this.mapArray(elementType, reader));
    }

    public <T> T[] readArray(InputStream stream, Class<T> clazz) {
        JsonReader reader = this.readerFactory.createReader(stream);
        return (Object[])this.mapArray(clazz, reader);
    }

    private Object mapArray(Class<?> clazz, JsonReader reader) {
        try {
            Object object = this.buildArrayWithComponentType(reader.readArray(), clazz, null);
            return object;
        }
        catch (Exception e) {
            throw new MapperException(e);
        }
        finally {
            if (this.close) {
                reader.close();
            }
        }
    }

    private Object buildObject(Type inType, JsonObject object) throws Exception {
        Mappings.ClassMapping classMapping;
        Type type = inType;
        if (inType == Object.class) {
            type = new JohnzonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Object.class});
        }
        if ((classMapping = this.mappings.findOrCreateClassMapping(type)) == null) {
            if (ParameterizedType.class.isInstance(type)) {
                Class raw;
                AbstractMap map;
                ParameterizedType aType = (ParameterizedType)ParameterizedType.class.cast(type);
                Type[] fieldArgTypes = aType.getActualTypeArguments();
                if (fieldArgTypes.length >= 2 && (map = LinkedHashMap.class == (raw = (Class)Class.class.cast(aType.getRawType())) ? new LinkedHashMap() : (SortedMap.class.isAssignableFrom(raw) || NavigableMap.class == raw || TreeMap.class == raw ? new TreeMap() : (ConcurrentMap.class.isAssignableFrom(raw) ? new ConcurrentHashMap(object.size()) : (EnumMap.class.isAssignableFrom(raw) ? new EnumMap((Class)Class.class.cast(fieldArgTypes[0])) : (Map.class.isAssignableFrom(raw) ? new HashMap(object.size()) : null))))) != null) {
                    Type keyType = ParameterizedType.class.isInstance(fieldArgTypes[0]) ? fieldArgTypes[0] : fieldArgTypes[0];
                    boolean any = fieldArgTypes.length < 2 || fieldArgTypes[1] == Object.class;
                    for (Map.Entry value : object.entrySet()) {
                        JsonNumber number;
                        JsonValue jsonValue = (JsonValue)value.getValue();
                        if (JsonLongImpl.class.isInstance(jsonValue) && any) {
                            long asLong;
                            number = (JsonNumber)JsonNumber.class.cast(jsonValue);
                            int integer = number.intValue();
                            if ((long)integer == (asLong = number.longValue())) {
                                map.put(value.getKey(), integer);
                                continue;
                            }
                            map.put(value.getKey(), asLong);
                            continue;
                        }
                        if (JsonNumber.class.isInstance(jsonValue) && any) {
                            number = (JsonNumber)JsonNumber.class.cast(jsonValue);
                            map.put(value.getKey(), !number.isIntegral() ? number.bigDecimalValue() : Integer.valueOf(number.intValue()));
                            continue;
                        }
                        if (JsonString.class.isInstance(jsonValue) && any) {
                            map.put(value.getKey(), ((JsonString)JsonString.class.cast(jsonValue)).getString());
                            continue;
                        }
                        map.put(this.convertTo(keyType, (String)value.getKey()), this.toObject(jsonValue, fieldArgTypes[1], null));
                    }
                    return map;
                }
            } else if (Map.class == type || HashMap.class == type || LinkedHashMap.class == type) {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry value : object.entrySet()) {
                    map.put(value.getKey(), this.toObject((JsonValue)value.getValue(), (Type)((Object)Object.class), null));
                }
                return map;
            }
        }
        if (classMapping == null) {
            throw new MapperException("Can't map " + type);
        }
        if (classMapping.factory == null) {
            throw new IllegalArgumentException(classMapping.clazz + " not instantiable");
        }
        Object t = classMapping.factory.getParameterTypes().length == 0 ? classMapping.factory.create(null) : classMapping.factory.create(this.createParameters(classMapping, object));
        for (Map.Entry<String, Mappings.Setter> setter : classMapping.setters.entrySet()) {
            JsonValue jsonValue = (JsonValue)object.get((Object)setter.getKey());
            Mappings.Setter value = setter.getValue();
            if (JsonValue.class == value.paramType) {
                setter.getValue().writer.write(t, jsonValue);
                continue;
            }
            if (jsonValue == null) continue;
            AccessMode.Writer setterMethod = value.writer;
            if (jsonValue == JsonValue.NULL) {
                setterMethod.write(t, null);
                continue;
            }
            Object convertedValue = this.toValue(jsonValue, value.converter, value.itemConverter, value.paramType);
            if (convertedValue == null) continue;
            setterMethod.write(t, convertedValue);
        }
        return t;
    }

    private Object toValue(JsonValue jsonValue, Adapter converter, Adapter itemConverter, Type type) throws Exception {
        return converter == null ? this.toObject(jsonValue, type, itemConverter) : (jsonValue.getValueType() == JsonValue.ValueType.STRING ? converter.to(((JsonString)JsonString.class.cast(jsonValue)).getString()) : this.convertTo(converter, jsonValue));
    }

    private Object convertTo(Adapter converter, JsonValue jsonValue) {
        if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            Object param;
            AdapterKey adapterKey = (AdapterKey)this.reverseAdaptersRegistry.get(converter);
            if (adapterKey == null) {
                for (Map.Entry entry : this.adapters.entrySet()) {
                    if (entry.getValue() != converter) continue;
                    adapterKey = (AdapterKey)entry.getKey();
                    this.reverseAdaptersRegistry.put(converter, adapterKey);
                    break;
                }
            }
            try {
                param = this.buildObject(adapterKey.getTo(), (JsonObject)JsonObject.class.cast(jsonValue));
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
            return converter.to(param);
        }
        return converter.to(jsonValue.toString());
    }

    private Object[] createParameters(Mappings.ClassMapping mapping, JsonObject object) throws Exception {
        int length = mapping.factory.getParameterTypes().length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = this.toValue((JsonValue)object.get((Object)mapping.factory.getParameterNames()[i]), mapping.factory.getParameterConverter()[i], mapping.factory.getParameterItemConverter()[i], mapping.factory.getParameterTypes()[i]);
        }
        return objects;
    }

    private Object toObject(JsonValue jsonValue, Type type, Adapter itemConverter) throws Exception {
        if (jsonValue == null || JsonValue.NULL == jsonValue) {
            return null;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            throw new MapperException("Unable to parse " + jsonValue + " to boolean");
        }
        if (this.treatByteArrayAsBase64 && jsonValue.getValueType() == JsonValue.ValueType.STRING && type == byte[].class) {
            return DatatypeConverter.parseBase64Binary((String)((JsonString)jsonValue).getString());
        }
        if (Object.class == type) {
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            if (JsonNumber.class.isInstance(jsonValue)) {
                JsonNumber jsonNumber = (JsonNumber)JsonNumber.class.cast(jsonValue);
                if (jsonNumber.isIntegral()) {
                    return jsonNumber.intValue();
                }
                return jsonNumber.doubleValue();
            }
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.convertTo((Type)Class.class.cast(type), ((JsonString)JsonString.class.cast(jsonValue)).getString());
        }
        if (JsonObject.class.isInstance(jsonValue)) {
            if (JsonObject.class == type || JsonStructure.class == type) {
                return jsonValue;
            }
            return this.buildObject(type, (JsonObject)JsonObject.class.cast(jsonValue));
        }
        if (JsonArray.class.isInstance(jsonValue)) {
            if (JsonArray.class == type || JsonStructure.class == type) {
                return jsonValue;
            }
            return this.buildArray(type, (JsonArray)JsonArray.class.cast(jsonValue), itemConverter);
        }
        if (JsonNumber.class.isInstance(jsonValue)) {
            if (JsonNumber.class == type) {
                return jsonValue;
            }
            JsonNumber number = (JsonNumber)JsonNumber.class.cast(jsonValue);
            if (type == Integer.class || type == Integer.TYPE) {
                return number.intValue();
            }
            if (type == Long.class || type == Long.TYPE) {
                return number.longValue();
            }
            if (type == Short.class || type == Short.TYPE) {
                return (short)number.intValue();
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return (byte)number.intValue();
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf((float)number.doubleValue());
            }
            if (type == Double.class || type == Double.TYPE) {
                return number.doubleValue();
            }
            if (type == BigInteger.class) {
                return number.bigIntegerValue();
            }
            if (type == BigDecimal.class) {
                return number.bigDecimalValue();
            }
        } else if (JsonString.class.isInstance(jsonValue)) {
            if (JsonString.class == type) {
                return jsonValue;
            }
            String string = ((JsonString)JsonString.class.cast(jsonValue)).getString();
            if (itemConverter == null) {
                return this.convertTo((Type)Class.class.cast(type), string);
            }
            return itemConverter.to(string);
        }
        throw new MapperException("Unable to parse " + jsonValue + " to " + type);
    }

    private Object buildArray(Type type, JsonArray jsonArray, Adapter itemConverter) throws Exception {
        Mappings.CollectionMapping mapping;
        Class clazz;
        if (Class.class.isInstance(type) && (clazz = (Class)Class.class.cast(type)).isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return this.buildArrayWithComponentType(jsonArray, componentType, itemConverter);
        }
        if (ParameterizedType.class.isInstance(type) && (mapping = this.mappings.findCollectionMapping((ParameterizedType)ParameterizedType.class.cast(type))) != null) {
            return this.mapCollection(mapping, jsonArray, itemConverter);
        }
        if (Object.class == type) {
            return this.buildArray(ANY_LIST, jsonArray, null);
        }
        throw new UnsupportedOperationException("type " + type + " not supported");
    }

    private <T> Collection<T> mapCollection(Mappings.CollectionMapping mapping, JsonArray jsonArray, Adapter itemConverter) throws Exception {
        AbstractCollection collection;
        if (SortedSet.class == mapping.raw || NavigableSet.class == mapping.raw || TreeSet.class == mapping.raw) {
            collection = new TreeSet<Object>();
        } else if (Set.class == mapping.raw || HashSet.class == mapping.raw) {
            collection = new HashSet(jsonArray.size());
        } else if (Queue.class == mapping.raw || ArrayBlockingQueue.class == mapping.raw) {
            collection = new ArrayBlockingQueue(jsonArray.size());
        } else if (List.class == mapping.raw || Collection.class == mapping.raw || ArrayList.class == mapping.raw || EnumSet.class == mapping.raw) {
            collection = new ArrayList(jsonArray.size());
        } else if (LinkedHashSet.class == mapping.raw) {
            collection = new LinkedHashSet(jsonArray.size());
        } else if (Deque.class == mapping.raw || ArrayDeque.class == mapping.raw) {
            collection = new ArrayDeque(jsonArray.size());
        } else if (Queue.class == mapping.raw || PriorityQueue.class == mapping.raw) {
            collection = new PriorityQueue(jsonArray.size());
        } else {
            throw new IllegalStateException("not supported collection type: " + mapping.raw.getName());
        }
        for (JsonValue value : jsonArray) {
            collection.add(value == JsonValue.NULL ? null : this.toObject(value, mapping.arg, itemConverter));
        }
        if (EnumSet.class == mapping.raw) {
            if (collection.isEmpty()) {
                return EnumSet.noneOf((Class)Class.class.cast(mapping.arg));
            }
            if (collection.size() == 1) {
                return (Collection)Collection.class.cast(EnumSet.of((Enum)Enum.class.cast(collection.iterator().next())));
            }
            List list = (List)List.class.cast(collection);
            return (Collection)Collection.class.cast(EnumSet.of((Enum)list.get(0), list.subList(1, list.size()).toArray(new Enum[list.size() - 1])));
        }
        return collection;
    }

    private Object buildArrayWithComponentType(JsonArray jsonArray, Class<?> componentType, Adapter itemConverter) throws Exception {
        Object array = Array.newInstance(componentType, jsonArray.size());
        int i = 0;
        for (JsonValue value : jsonArray) {
            Array.set(array, i++, this.toObject(value, componentType, itemConverter));
        }
        return array;
    }

    @Override
    public synchronized void close() {
        ArrayList<IOException> errors = null;
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (IOException e) {
                if (errors == null) {
                    errors = new ArrayList<IOException>();
                }
                errors.add(e);
            }
        }
        this.closeables.clear();
        if (errors != null) {
            throw new IllegalStateException(((Object)errors).toString());
        }
    }

    private static class FallbackConverter
    implements Converter<Object> {
        private FallbackConverter() {
        }

        @Override
        public String toString(Object instance) {
            return instance.toString();
        }

        @Override
        public Object fromString(String text) {
            throw new UnsupportedOperationException("Using fallback converter, this only works in write mode but not in read. Please register a custom converter to do so.");
        }
    }
}

