/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.io.Closeable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.json.JsonReaderFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.FieldAccessMode;
import org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.apache.johnzon.mapper.access.MethodAccessMode;
import org.apache.johnzon.mapper.converter.BigDecimalConverter;
import org.apache.johnzon.mapper.converter.BigIntegerConverter;
import org.apache.johnzon.mapper.converter.BooleanConverter;
import org.apache.johnzon.mapper.converter.ByteConverter;
import org.apache.johnzon.mapper.converter.CachedDelegateConverter;
import org.apache.johnzon.mapper.converter.CharacterConverter;
import org.apache.johnzon.mapper.converter.ClassConverter;
import org.apache.johnzon.mapper.converter.DateConverter;
import org.apache.johnzon.mapper.converter.DoubleConverter;
import org.apache.johnzon.mapper.converter.FloatConverter;
import org.apache.johnzon.mapper.converter.IntegerConverter;
import org.apache.johnzon.mapper.converter.LocaleConverter;
import org.apache.johnzon.mapper.converter.LongConverter;
import org.apache.johnzon.mapper.converter.ShortConverter;
import org.apache.johnzon.mapper.converter.StringConverter;
import org.apache.johnzon.mapper.converter.URIConverter;
import org.apache.johnzon.mapper.converter.URLConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;

public class MapperBuilder {
    private static final Map<AdapterKey, Adapter<?, ?>> DEFAULT_CONVERTERS = new HashMap(23);
    private JsonReaderFactory readerFactory;
    private JsonGeneratorFactory generatorFactory;
    private boolean doCloseOnStreams = false;
    private boolean supportHiddenAccess = true;
    private int version = -1;
    private int maxSize = -1;
    private int bufferSize = -1;
    private String bufferStrategy;
    private Comparator<String> attributeOrder = null;
    private boolean skipNull = true;
    private boolean skipEmptyArray = false;
    private boolean supportsComments = false;
    protected boolean pretty;
    private AccessMode accessMode;
    private boolean treatByteArrayAsBase64;
    private boolean treatByteArrayAsBase64URL;
    private final Map<AdapterKey, Adapter<?, ?>> adapters = new HashMap(DEFAULT_CONVERTERS);
    private boolean supportConstructors;
    private Charset encoding = Charset.forName(System.getProperty("johnzon.mapper.encoding", "UTF-8"));
    private boolean useGetterForCollections;
    private String accessModeName;
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();

    public Mapper build() {
        if (this.readerFactory == null || this.generatorFactory == null) {
            JsonProvider provider = JsonProvider.provider();
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (this.bufferStrategy != null) {
                config.put("org.apache.johnzon.buffer-strategy", this.bufferStrategy);
            }
            if (this.pretty) {
                config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if (this.generatorFactory == null) {
                this.generatorFactory = provider.createGeneratorFactory(config);
            }
            config.remove("javax.json.stream.JsonGenerator.prettyPrinting");
            if (this.supportsComments) {
                config.put("org.apache.johnzon.supports-comments", "true");
            }
            if (this.maxSize > 0) {
                config.put("org.apache.johnzon.max-string-length", this.maxSize);
            }
            if (this.bufferSize > 0) {
                config.put("org.apache.johnzon.default-char-buffer", this.bufferSize);
            }
            if (this.readerFactory == null) {
                this.readerFactory = provider.createReaderFactory(config);
            }
        }
        if (this.accessMode == null) {
            this.accessMode = "field".equalsIgnoreCase(this.accessModeName) ? new FieldAccessMode(this.supportConstructors, this.supportHiddenAccess) : ("method".equalsIgnoreCase(this.accessModeName) ? new MethodAccessMode(this.supportConstructors, this.supportHiddenAccess, true) : ("strict-method".equalsIgnoreCase(this.accessModeName) ? new MethodAccessMode(this.supportConstructors, this.supportHiddenAccess, false) : ("both".equalsIgnoreCase(this.accessModeName) ? new FieldAndMethodAccessMode(this.supportConstructors, this.supportHiddenAccess) : new MethodAccessMode(this.supportConstructors, this.supportHiddenAccess, this.useGetterForCollections))));
        }
        return new Mapper(this.readerFactory, this.generatorFactory, this.doCloseOnStreams, this.adapters, this.version, this.attributeOrder, this.skipNull, this.skipEmptyArray, this.accessMode, this.treatByteArrayAsBase64, this.treatByteArrayAsBase64URL, this.encoding, this.closeables);
    }

    public MapperBuilder addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
        return this;
    }

    public MapperBuilder setIgnoreFieldsForType(Class<?> type, String ... fields) {
        if (BaseAccessMode.class.isInstance(this.accessMode)) {
            if (fields == null || fields.length == 0) {
                ((BaseAccessMode)BaseAccessMode.class.cast(this.accessMode)).getFieldsToRemove().remove(type);
            } else {
                ((BaseAccessMode)BaseAccessMode.class.cast(this.accessMode)).getFieldsToRemove().put(type, fields);
            }
        } else {
            throw new IllegalStateException("AccessMode is not an BaseAccessMode");
        }
        return this;
    }

    public MapperBuilder setSupportGetterForCollections(boolean useGetterForCollections) {
        this.useGetterForCollections = useGetterForCollections;
        return this;
    }

    public MapperBuilder setSupportsComments(boolean supportsComments) {
        this.supportsComments = supportsComments;
        return this;
    }

    public MapperBuilder setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public MapperBuilder setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public MapperBuilder setBufferStrategy(String bufferStrategy) {
        this.bufferStrategy = bufferStrategy;
        return this;
    }

    public MapperBuilder setMaxSize(int size) {
        this.maxSize = size;
        return this;
    }

    public MapperBuilder setAccessMode(AccessMode mode) {
        this.accessMode = mode;
        return this;
    }

    public MapperBuilder setAccessModeName(String mode) {
        if (!("field".equalsIgnoreCase(mode) || "method".equalsIgnoreCase(mode) || "strict-method".equalsIgnoreCase(mode) || "both".equalsIgnoreCase(mode))) {
            throw new IllegalArgumentException("Mode " + mode + " unsupported");
        }
        this.accessModeName = mode;
        return this;
    }

    public MapperBuilder setSupportHiddenAccess(boolean supportHiddenAccess) {
        this.supportHiddenAccess = supportHiddenAccess;
        return this;
    }

    public MapperBuilder setAttributeOrder(Comparator<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
        return this;
    }

    public MapperBuilder setReaderFactory(JsonReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
        return this;
    }

    public MapperBuilder setGeneratorFactory(JsonGeneratorFactory generatorFactory) {
        this.generatorFactory = generatorFactory;
        return this;
    }

    public MapperBuilder setDoCloseOnStreams(boolean doCloseOnStreams) {
        this.doCloseOnStreams = doCloseOnStreams;
        return this;
    }

    @Deprecated
    public MapperBuilder addPropertyEditor(Class<?> clazz, Converter<?> converter) {
        this.adapters.put(new AdapterKey(clazz, (Type)((Object)String.class)), new ConverterAdapter(converter));
        return this;
    }

    @Deprecated
    public MapperBuilder addConverter(Type clazz, Converter<?> converter) {
        this.adapters.put(new AdapterKey(clazz, (Type)((Object)String.class)), new ConverterAdapter(converter));
        return this;
    }

    public MapperBuilder addAdapter(Type from, Type to, Adapter<?, ?> adapter) {
        this.adapters.put(new AdapterKey(from, to), adapter);
        return this;
    }

    public MapperBuilder addAdapter(Adapter<?, ?> converter) {
        for (Type gi : converter.getClass().getGenericInterfaces()) {
            if (!ParameterizedType.class.isInstance(gi) || Adapter.class != ((ParameterizedType)ParameterizedType.class.cast(gi)).getRawType()) continue;
            Type[] args = ((ParameterizedType)ParameterizedType.class.cast(gi)).getActualTypeArguments();
            this.adapters.put(new AdapterKey(args[0], args[1]), converter);
            return this;
        }
        throw new IllegalArgumentException("Can't find Adapter generics from " + converter + ", please use addAdapter(t1, t2, adapter) instead");
    }

    public MapperBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    public MapperBuilder setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public MapperBuilder setSkipEmptyArray(boolean skipEmptyArray) {
        this.skipEmptyArray = skipEmptyArray;
        return this;
    }

    public MapperBuilder setTreatByteArrayAsBase64(boolean treatByteArrayAsBase64) {
        this.treatByteArrayAsBase64 = treatByteArrayAsBase64;
        return this;
    }

    public MapperBuilder setTreatByteArrayAsBase64URL(boolean treatByteArrayAsBase64URL) {
        this.treatByteArrayAsBase64URL = treatByteArrayAsBase64URL;
        return this;
    }

    public MapperBuilder setSupportConstructors(boolean supportConstructors) {
        this.supportConstructors = supportConstructors;
        return this;
    }

    public MapperBuilder setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
        return this;
    }

    static {
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Date.class), (Type)((Object)String.class)), new ConverterAdapter<Date>(new DateConverter("yyyyMMddHHmmssZ")));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)URL.class), (Type)((Object)String.class)), new ConverterAdapter<URL>(new URLConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)URI.class), (Type)((Object)String.class)), new ConverterAdapter<URI>(new URIConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Class.class), (Type)((Object)String.class)), new ConverterAdapter(new ClassConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)String.class), (Type)((Object)String.class)), new ConverterAdapter<String>(new StringConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)BigDecimal.class), (Type)((Object)String.class)), new ConverterAdapter<BigDecimal>(new BigDecimalConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)BigInteger.class), (Type)((Object)String.class)), new ConverterAdapter<BigInteger>(new BigIntegerConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Byte.class), (Type)((Object)String.class)), new ConverterAdapter<Byte>(new CachedDelegateConverter<Byte>(new ByteConverter())));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Character.class), (Type)((Object)String.class)), new ConverterAdapter<Character>(new CharacterConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Double.class), (Type)((Object)String.class)), new ConverterAdapter<Double>(new DoubleConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Float.class), (Type)((Object)String.class)), new ConverterAdapter<Float>(new FloatConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Integer.class), (Type)((Object)String.class)), new ConverterAdapter<Integer>(new IntegerConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Long.class), (Type)((Object)String.class)), new ConverterAdapter<Long>(new LongConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Short.class), (Type)((Object)String.class)), new ConverterAdapter<Short>(new ShortConverter()));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Boolean.class), (Type)((Object)String.class)), new ConverterAdapter<Boolean>(new CachedDelegateConverter<Boolean>(new BooleanConverter())));
        DEFAULT_CONVERTERS.put(new AdapterKey(Byte.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Byte.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Character.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Character.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Double.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Double.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Float.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Float.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Integer.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Integer.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Long.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Long.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Short.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Short.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey(Boolean.TYPE, (Type)((Object)String.class)), DEFAULT_CONVERTERS.get(new AdapterKey((Type)((Object)Boolean.class), (Type)((Object)String.class))));
        DEFAULT_CONVERTERS.put(new AdapterKey((Type)((Object)Locale.class), (Type)((Object)String.class)), new LocaleConverter());
    }
}

