/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.maven.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="example-to-model", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ExampleToModelMojo
extends AbstractMojo {
    private static final List<Character> FORBIDDEN_JAVA_NAMES = Arrays.asList(Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.'));
    @Parameter(property="johnzon.source", defaultValue="${project.basedir}/src/main/johnzon")
    protected File source;
    @Parameter(property="johnzon.target", defaultValue="${project.build.directory}/generated-sources/johnzon")
    protected File target;
    @Parameter(property="johnzon.package", defaultValue="com.johnzon.generated")
    protected String packageBase;
    @Parameter
    protected String header;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="johnzon.attach", defaultValue="true")
    protected boolean attach;

    public void execute() throws MojoExecutionException, MojoFailureException {
        JsonReaderFactory readerFactory = Json.createReaderFactory(Collections.emptyMap());
        if (this.source.isFile()) {
            this.generateFile(readerFactory, this.source);
        } else {
            File[] children = this.source.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".json");
                }
            });
            if (children == null || children.length == 0) {
                throw new MojoExecutionException("No json file found in " + this.source);
            }
            for (File child : children) {
                this.generateFile(readerFactory, child);
            }
        }
        if (this.attach && this.project != null) {
            this.project.addCompileSourceRoot(this.target.getAbsolutePath());
        }
    }

    private void generate(JsonReaderFactory readerFactory, File source, Writer writer, String javaName) throws MojoExecutionException {
        try (JsonReader reader = null;){
            reader = readerFactory.createReader((Reader)new FileReader(source));
            JsonStructure structure = reader.read();
            if (JsonArray.class.isInstance(structure) || !JsonObject.class.isInstance(structure)) {
                throw new MojoExecutionException("This plugin doesn't support array generation, generate the model (generic) and handle arrays in your code");
            }
            JsonObject object = (JsonObject)JsonObject.class.cast(structure);
            TreeSet<String> imports = new TreeSet<String>();
            StringWriter memBuffer = new StringWriter();
            this.generateFieldsAndMethods(memBuffer, object, "    ", imports);
            if (this.header != null) {
                writer.write(this.header);
                writer.write(10);
            }
            writer.write("package " + this.packageBase + ";\n\n");
            if (!imports.isEmpty()) {
                for (String imp : imports) {
                    writer.write("import " + imp + ";\n");
                }
                writer.write(10);
            }
            writer.write("public class " + javaName + " {\n");
            writer.write(memBuffer.toString());
            writer.write("}\n");
        }
    }

    private void generateFieldsAndMethods(Writer writer, JsonObject object, String prefix, Collection<String> imports) throws IOException {
        Map.Entry entry;
        TreeMap<String, JsonObject> nestedTypes = new TreeMap<String, JsonObject>();
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            String fieldName = this.toJavaFieldName(key);
            switch (((JsonValue)entry.getValue()).getValueType()) {
                case ARRAY: {
                    imports.add("java.util.List");
                    this.handleArray(writer, prefix, nestedTypes, (JsonValue)entry.getValue(), key, fieldName, 1, imports);
                    break;
                }
                case OBJECT: {
                    String type = this.toJavaName(fieldName);
                    nestedTypes.put(type, (JsonObject)JsonObject.class.cast(entry.getValue()));
                    this.fieldGetSetMethods(writer, key, fieldName, type, prefix, 0, imports);
                    break;
                }
                case TRUE: 
                case FALSE: {
                    this.fieldGetSetMethods(writer, key, fieldName, "Boolean", prefix, 0, imports);
                    break;
                }
                case NUMBER: {
                    this.fieldGetSetMethods(writer, key, fieldName, "Double", prefix, 0, imports);
                    break;
                }
                case STRING: {
                    this.fieldGetSetMethods(writer, key, fieldName, "String", prefix, 0, imports);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported " + entry.getValue() + ".");
                }
            }
            if (!iterator.hasNext()) continue;
            writer.write("\n");
        }
        if (!object.isEmpty() && !nestedTypes.isEmpty()) {
            writer.write("\n");
        }
        Iterator entries = nestedTypes.entrySet().iterator();
        while (entries.hasNext()) {
            entry = entries.next();
            writer.write(prefix + "public static class " + (String)entry.getKey() + " {\n");
            this.generateFieldsAndMethods(writer, (JsonObject)entry.getValue(), "    " + prefix, imports);
            writer.write(prefix + "}\n");
            if (!entries.hasNext()) continue;
            writer.write("\n");
        }
    }

    private void handleArray(Writer writer, String prefix, Map<String, JsonObject> nestedTypes, JsonValue value, String jsonField, String fieldName, int arrayLevel, Collection<String> imports) throws IOException {
        JsonArray array = (JsonArray)JsonArray.class.cast(value);
        if (array.size() > 0) {
            JsonValue jsonValue = (JsonValue)array.get(0);
            switch (jsonValue.getValueType()) {
                case OBJECT: {
                    String javaName = this.toJavaName(fieldName);
                    nestedTypes.put(javaName, (JsonObject)JsonObject.class.cast(jsonValue));
                    this.fieldGetSetMethods(writer, jsonField, fieldName, javaName, prefix, arrayLevel, imports);
                    break;
                }
                case TRUE: 
                case FALSE: {
                    this.fieldGetSetMethods(writer, jsonField, fieldName, "Boolean", prefix, arrayLevel, imports);
                    break;
                }
                case NUMBER: {
                    this.fieldGetSetMethods(writer, jsonField, fieldName, "Double", prefix, arrayLevel, imports);
                    break;
                }
                case STRING: {
                    this.fieldGetSetMethods(writer, jsonField, fieldName, "String", prefix, arrayLevel, imports);
                    break;
                }
                case ARRAY: {
                    this.handleArray(writer, prefix, nestedTypes, jsonValue, jsonField, fieldName, arrayLevel + 1, imports);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported " + value + ".");
                }
            }
        } else {
            this.getLog().warn((CharSequence)"Empty arrays are ignored");
        }
    }

    private void fieldGetSetMethods(Writer writer, String jsonField, String field, String type, String prefix, int arrayLevel, Collection<String> imports) throws IOException {
        String actualType = this.buildArrayType(arrayLevel, type);
        String actualField = this.buildValidFieldName(jsonField);
        String methodName = this.capitalize(actualField);
        if (!jsonField.equals(field)) {
            imports.add("org.apache.johnzon.mapper.JohnzonProperty");
            writer.append(prefix).append("@JohnzonProperty(\"").append(jsonField).append("\")\n");
        }
        writer.append(prefix).append("private ").append(actualType).append(" ").append(actualField).append(";\n");
        writer.append(prefix).append("public ").append(actualType).append(" get").append(methodName).append("() {\n");
        writer.append(prefix).append("    return ").append(actualField).append(";\n");
        writer.append(prefix).append("}\n");
        writer.append(prefix).append("public void set").append(methodName).append("(final ").append(actualType).append(" newValue) {\n");
        writer.append(prefix).append("    this.").append(actualField).append(" = newValue;\n");
        writer.append(prefix).append("}\n");
    }

    private String capitalize(String str) {
        if (str != null && !str.isEmpty()) {
            char firstChar = str.charAt(0);
            return Character.isTitleCase(firstChar) ? str : Character.toTitleCase(firstChar) + str.substring(1);
        }
        return str;
    }

    private String buildArrayType(int arrayLevel, String type) {
        int i;
        if (arrayLevel == 0) {
            return type;
        }
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < arrayLevel; ++i) {
            builder.append("List<");
        }
        builder.append(type);
        for (i = 0; i < arrayLevel; ++i) {
            builder.append(">");
        }
        return builder.toString();
    }

    private void visit(JsonStructure structure, Visitor visitor) {
        if (JsonObject.class.isInstance(structure)) {
            visitor.visitObject((JsonObject)JsonObject.class.cast(structure));
        } else if (JsonArray.class.isInstance(structure)) {
            visitor.visitArray((JsonArray)JsonArray.class.cast(structure));
        } else {
            throw new UnsupportedOperationException("Can't visit " + structure);
        }
    }

    private void generateFile(JsonReaderFactory readerFactory, File source) throws MojoExecutionException {
        String javaName = this.capitalize(this.toJavaName(source.getName()));
        String jsonToClass = this.packageBase + '.' + javaName;
        File outputFile = new File(this.target, jsonToClass.replace('.', '/') + ".java");
        outputFile.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(outputFile);
            this.generate(readerFactory, source, writer, javaName);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private String buildValidFieldName(String jsonField) {
        String val = jsonField;
        if (Character.isDigit(jsonField.charAt(0))) {
            val = "_" + jsonField;
        }
        return val.replace(".", "");
    }

    private String toJavaFieldName(String key) {
        String javaName = this.toJavaName(key);
        return Character.toLowerCase(javaName.charAt(0)) + javaName.substring(1);
    }

    private String toJavaName(String file) {
        StringBuilder builder = new StringBuilder();
        boolean nextUpper = false;
        for (char anIn : file.replace(".json", "").toCharArray()) {
            if (FORBIDDEN_JAVA_NAMES.contains(Character.valueOf(anIn))) {
                nextUpper = true;
                continue;
            }
            if (nextUpper) {
                builder.append(Character.toUpperCase(anIn));
                nextUpper = false;
                continue;
            }
            builder.append(anIn);
        }
        return this.capitalize(builder.toString());
    }

    private static interface Visitor {
        public void visitObject(JsonObject var1);

        public void visitArray(JsonArray var1);
    }
}

